/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.MathUtil;
import framework.Ray;
import raytrace.engine.HitList;
import raytrace.engine.MaterialPrimitive;

public class Torus
extends MaterialPrimitive {
    static final double r = 0.4;
    static final double R = 1.6;

    public Torus(M3d color) {
        super(color);
    }

    @Override
    protected M3d getNormal(M3d point) {
        M3d proj = new M3d(point.getX(), 0.0, point.getZ()).normalized().times(1.6);
        return point.minus(proj).normalized();
    }

    @Override
    public boolean testLocalRay(Ray ray, HitList collisions) {
        double ax = ray.direction.getX();
        double ay = ray.direction.getY();
        double az = ray.direction.getZ();
        double x0 = ray.origin.getX();
        double y0 = ray.origin.getY();
        double z0 = ray.origin.getZ();
        double p = 1.0;
        double A0 = 10.240000000000002;
        double B0 = 2.4000000000000004;
        double C0 = ax * ax + p * ay * ay + az * az;
        double D0 = x0 * ax + p * y0 * ay + z0 * az;
        double E0 = x0 * x0 + p * y0 * y0 + z0 * z0 + B0;
        double[] coefficients = new double[]{E0 * E0 - A0 * (x0 * x0 + z0 * z0), 4.0 * D0 * E0 - 2.0 * A0 * (x0 * ax + z0 * az), 4.0 * D0 * D0 + 2.0 * E0 * C0 - A0 * (ax * ax + az * az), 4.0 * D0 * C0, C0 * C0};
        double[] solutions = new double[4];
        int numSolutions = MathUtil.SolveQuartic(coefficients, solutions);
        boolean success = false;
        int i = 0;
        while (i < numSolutions) {
            success |= this.recordCollision(solutions[i], ray, collisions) != null;
            ++i;
        }
        return success;
    }
}

