/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.M3d;
import framework.Ray;
import raytrace.engine.HitList;
import raytrace.engine.MaterialPrimitive;
import raytrace.engine.RayCollision;

public class Cube
extends MaterialPrimitive {
    public Cube(M3d color) {
        super(color);
    }

    @Override
    protected M3d getNormal(M3d point) {
        return point.toAxis();
    }

    @Override
    protected RayCollision recordCollision(double t, Ray ray, HitList collisions) {
        M3d pt;
        if (t > 0.001 && Math.abs((pt = ray.at(t)).getX()) <= 1.00001 && Math.abs(pt.getY()) <= 1.00001 && Math.abs(pt.getZ()) <= 1.00001) {
            return super.recordCollision(t, ray, collisions);
        }
        return null;
    }

    @Override
    public boolean testLocalRay(Ray ray, HitList collisions) {
        boolean success = false;
        success |= this.recordCollision(-(ray.origin.getX() - 1.0) / ray.direction.getX(), ray, collisions) != null;
        success |= this.recordCollision(-(ray.origin.getX() + 1.0) / ray.direction.getX(), ray, collisions) != null;
        success |= this.recordCollision(-(ray.origin.getY() - 1.0) / ray.direction.getY(), ray, collisions) != null;
        success |= this.recordCollision(-(ray.origin.getY() + 1.0) / ray.direction.getY(), ray, collisions) != null;
        success |= this.recordCollision(-(ray.origin.getZ() - 1.0) / ray.direction.getZ(), ray, collisions) != null;
        return success |= this.recordCollision(-(ray.origin.getZ() + 1.0) / ray.direction.getZ(), ray, collisions) != null;
    }
}

