/*
 * Decompiled with CFR 0.152.
 */
package raytrace.engine;

import framework.Ray;
import raytrace.engine.HitList;
import raytrace.engine.Primitive;
import raytrace.engine.RayCollision;

public abstract class CsgBoolean
extends Primitive {
    protected static final HitList NONE = new HitList();
    protected Primitive A;
    protected Primitive B;

    public CsgBoolean(Primitive A, Primitive B) {
        this.A = A;
        this.B = B;
    }

    protected HitList push(RayCollision toAdd, HitList hits) {
        HitList result = new HitList();
        result.add(toAdd);
        for (RayCollision hit : hits) {
            result.add(hit);
        }
        return result;
    }

    protected HitList pop(HitList hits) {
        HitList result = new HitList();
        int i = 1;
        while (i < hits.size()) {
            result.add((RayCollision)hits.get(i));
            ++i;
        }
        return result;
    }

    boolean mergeHitLists(boolean inA, HitList hitsA, boolean inB, HitList hitsB, HitList collisions) {
        int a = 0;
        int b = 0;
        int initialSize = collisions.size();
        while (a < hitsA.size() && b < hitsB.size()) {
            if (((RayCollision)hitsA.get((int)a)).t < ((RayCollision)hitsB.get((int)b)).t) {
                if (this.op(inA, !inA, inB, inB)) {
                    collisions.insert((RayCollision)hitsA.get(a));
                }
                ++a;
                inA = !inA;
                continue;
            }
            if (this.op(inA, inA, inB, !inB)) {
                collisions.insert((RayCollision)hitsB.get(b));
            }
            ++b;
            boolean bl = inB = !inB;
        }
        while (a < hitsA.size()) {
            if (this.op(inA, !inA, inB, inB)) {
                collisions.insert((RayCollision)hitsA.get(a));
            }
            ++a;
            boolean bl = inA = !inA;
        }
        while (b < hitsB.size()) {
            if (this.op(inA, inA, inB, !inB)) {
                collisions.insert((RayCollision)hitsB.get(b));
            }
            ++b;
            boolean bl = inB = !inB;
        }
        return initialSize != collisions.size();
    }

    @Override
    public boolean testLocalRay(Ray ray, HitList collisions) {
        boolean inA;
        HitList hitsA = new HitList();
        HitList hitsB = new HitList();
        this.A.traceRay(ray, hitsA);
        this.B.traceRay(ray, hitsB);
        boolean bl = hitsA.isEmpty() ? false : (inA = ((RayCollision)hitsA.get((int)0)).normal.dot(ray.direction) > 0.0);
        boolean inB = hitsB.isEmpty() ? false : ((RayCollision)hitsB.get((int)0)).normal.dot(ray.direction) > 0.0;
        return this.mergeHitLists(inA, hitsA, inB, hitsB, collisions);
    }

    abstract boolean op(boolean var1, boolean var2, boolean var3, boolean var4);
}

