/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.M3d;
import framework.M4x4;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

public abstract class Renderer
implements GLEventListener,
KeyListener,
MouseListener,
MouseMotionListener {
    protected M4x4 cameraTransform = new M4x4();
    protected float cameraDistance = 4.0f;
    protected boolean showAxes = true;
    Point lastCapturedMousePosition;

    public abstract String getTitle();

    public void init(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        gl.glShadeModel(7425);
        gl.glClearColor(0.2f, 0.4f, 0.6f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glEnable(2896);
        gl.glEnable(2903);
        gl.glEnable(16384);
        gl.glShadeModel(7424);
        gl.glColorMaterial(1032, 5634);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glEnable(6406);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glDisable(3024);
        glDrawable.addKeyListener((KeyListener)this);
        glDrawable.addMouseListener((MouseListener)this);
        glDrawable.addMouseMotionListener((MouseMotionListener)this);
    }

    public void preDisplay(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        gl.glClear(16384);
        gl.glClear(256);
        gl.glLoadIdentity();
        gl.glTranslatef(0.0f, 0.0f, -this.cameraDistance);
        gl.glMultMatrixd(this.cameraTransform.getData(), 0);
        if (this.showAxes) {
            gl.glDisable(2896);
            gl.glBegin(1);
            gl.glColor3f(1.0f, 1.0f, 1.0f);
            gl.glVertex3i(-100, 0, 0);
            gl.glVertex3i(100, 0, 0);
            gl.glVertex3i(0, -100, 0);
            gl.glVertex3i(0, 100, 0);
            gl.glVertex3i(0, 0, -100);
            gl.glVertex3i(0, 0, 100);
            gl.glEnd();
            gl.glEnable(2896);
        }
    }

    public void postDisplay(GLAutoDrawable glDrawable) {
    }

    public void displayChanged(GLAutoDrawable glDrawable, boolean modeChanged, boolean deviceChanged) {
    }

    public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width, int height) {
        GL gl = gLDrawable.getGL();
        if (height <= 0) {
            height = 1;
        }
        float h = (float)width / (float)height;
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        new GLU().gluPerspective(50.0, (double)h, 0.1, 100.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                System.exit(0);
                break;
            }
            case 34: {
                this.cameraDistance = (float)((double)this.cameraDistance + 0.25);
                break;
            }
            case 33: {
                this.cameraDistance = (float)((double)this.cameraDistance - 0.25);
                break;
            }
            case 49: {
                this.cameraTransform = new M4x4();
                break;
            }
            case 50: {
                this.cameraTransform = M4x4.rotation(new M3d(0.0, 1.0, 0.0), -0.39269908169872414);
                this.cameraTransform.rotate(new M3d(1.0, 0.0, -1.0), 0.39269908169872414);
                this.cameraTransform.rotate(new M3d(0.0, 0.0, 1.0), 0.2454369260617026);
                break;
            }
            case 51: {
                this.cameraTransform = M4x4.rotation(new M3d(1.0, 0.0, 0.0), 1.570796);
                break;
            }
            case 52: {
                this.cameraTransform = M4x4.rotation(new M3d(1.0, 0.0, 0.0), -1.2173669);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastCapturedMousePosition = e.getLocationOnScreen();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int dx = e.getLocationOnScreen().x - this.lastCapturedMousePosition.x;
        int dy = e.getLocationOnScreen().y - this.lastCapturedMousePosition.y;
        double len = Math.sqrt(dx * dx + dy * dy) / (10.0 * (double)this.cameraDistance);
        M3d right = this.cameraTransform.getRow(0);
        M3d up = this.cameraTransform.getRow(1);
        M3d axis = up.times(dx).plus(right.times(dy)).normalized();
        this.lastCapturedMousePosition = e.getLocationOnScreen();
        this.cameraTransform.rotate(axis, len);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

