/*
 * Decompiled with CFR 0.152.
 */
package framework;

import framework.M3d;

public class M4x4 {
    double[] data = new double[16];

    public M4x4() {
        int i = 0;
        while (i < 16) {
            this.data[i] = i / 4 == i % 4 ? 1 : 0;
            ++i;
        }
    }

    public M4x4(double[][] A) {
        int row = 0;
        while (row < 4) {
            int col = 0;
            while (col < 4) {
                this.data[row * 4 + col] = A[row][col];
                ++col;
            }
            ++row;
        }
    }

    public M4x4(M4x4 A) {
        int i = 0;
        while (i < 16) {
            this.data[i] = A.data[i];
            ++i;
        }
    }

    public double[] getData() {
        return this.data;
    }

    public void identity() {
        int i = 0;
        while (i < 16) {
            this.data[i] = i / 4 == i % 4 ? 1 : 0;
            ++i;
        }
    }

    public boolean isIdentity() {
        int i = 0;
        while (i < 16) {
            if (this.data[i] != (double)(i / 4 == i % 4 ? 1 : 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public M4x4 plus(M4x4 A) {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 16) {
            M.data[i] = this.data[i] + A.data[i];
            ++i;
        }
        return M;
    }

    public M4x4 minus(M4x4 A) {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 16) {
            M.data[i] = this.data[i] - A.data[i];
            ++i;
        }
        return M;
    }

    public M4x4 neg() {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 16) {
            M.data[i] = -this.data[i];
            ++i;
        }
        return M;
    }

    public M4x4 times(M4x4 A) {
        M4x4 M = new M4x4();
        int j = 0;
        while (j < 4) {
            int i = 0;
            while (i < 4) {
                double ab = 0.0;
                int k = 0;
                while (k < 4) {
                    ab += this.data[k * 4 + i] * A.data[j * 4 + k];
                    ++k;
                }
                M.data[j * 4 + i] = ab;
                ++i;
            }
            ++j;
        }
        return M;
    }

    public M4x4 times(double k) {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 16) {
            M.data[i] = this.data[i] * k;
            ++i;
        }
        return M;
    }

    public M4x4 transposed() {
        M4x4 M = new M4x4();
        int j = 0;
        while (j < 4) {
            int i = j + 1;
            while (i < 4) {
                double swp = this.data[j * 4 + i];
                M.data[j * 4 + i] = this.data[i * 4 + j];
                M.data[i * 4 + j] = swp;
                ++i;
            }
            ++j;
        }
        return M;
    }

    double cell(int col, int row) {
        return this.data[col * 4 + row];
    }

    void setCell(int col, int row, double value) {
        this.data[col * 4 + row] = value;
    }

    private boolean inverse(double[][] A, double[][] AI) {
        int i;
        int j;
        int n = A.length;
        int[] row = new int[n];
        int[] col = new int[n];
        double[] temp = new double[n];
        if (A[0].length != n || AI.length != n || AI[0].length != n) {
            return false;
        }
        int i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < n) {
                AI[i2][j] = A[i2][j];
                ++j;
            }
            ++i2;
        }
        int k = 0;
        while (k < n) {
            row[k] = k;
            col[k] = k;
            ++k;
        }
        k = 0;
        while (k < n) {
            int j2;
            double pivot = AI[row[k]][col[k]];
            int I_pivot = k;
            int J_pivot = k;
            i = k;
            while (i < n) {
                j2 = k;
                while (j2 < n) {
                    double abs_pivot = Math.abs(pivot);
                    if (Math.abs(AI[row[i]][col[j2]]) > abs_pivot) {
                        I_pivot = i;
                        J_pivot = j2;
                        pivot = AI[row[i]][col[j2]];
                    }
                    ++j2;
                }
                ++i;
            }
            if (Math.abs(pivot) < 1.0E-15) {
                return false;
            }
            int hold = row[k];
            row[k] = row[I_pivot];
            row[I_pivot] = hold;
            hold = col[k];
            col[k] = col[J_pivot];
            col[J_pivot] = hold;
            AI[row[k]][col[k]] = 1.0 / pivot;
            j = 0;
            while (j < n) {
                if (j != k) {
                    AI[row[k]][col[j]] = AI[row[k]][col[j]] * AI[row[k]][col[k]];
                }
                ++j;
            }
            i = 0;
            while (i < n) {
                if (k != i) {
                    j2 = 0;
                    while (j2 < n) {
                        if (k != j2) {
                            AI[row[i]][col[j2]] = AI[row[i]][col[j2]] - AI[row[i]][col[k]] * AI[row[k]][col[j2]];
                        }
                        ++j2;
                    }
                    AI[row[i]][col[k]] = -AI[row[i]][col[k]] * AI[row[k]][col[k]];
                }
                ++i;
            }
            ++k;
        }
        int j3 = 0;
        while (j3 < n) {
            i = 0;
            while (i < n) {
                temp[col[i]] = AI[row[i]][j3];
                ++i;
            }
            i = 0;
            while (i < n) {
                AI[i][j3] = temp[i];
                ++i;
            }
            ++j3;
        }
        i2 = 0;
        while (i2 < n) {
            j = 0;
            while (j < n) {
                temp[row[j]] = AI[i2][col[j]];
                ++j;
            }
            j = 0;
            while (j < n) {
                AI[i2][j] = temp[j];
                ++j;
            }
            ++i2;
        }
        return true;
    }

    public M4x4 inverted() {
        double[][] input = new double[4][4];
        double[][] output = new double[4][4];
        int row = 0;
        while (row < 4) {
            int col = 0;
            while (col < 4) {
                input[row][col] = this.cell(row, col);
                output[row][col] = 0.0;
                ++col;
            }
            ++row;
        }
        if (!this.inverse(input, output)) {
            throw new IllegalArgumentException("Could not invert matrix" + this);
        }
        return new M4x4(output);
    }

    public static M4x4 translation(M3d t) {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 3) {
            M.data[12 + i] = t.get(i);
            ++i;
        }
        return M;
    }

    public static M4x4 scale(M3d t) {
        M4x4 M = new M4x4();
        int i = 0;
        while (i < 3) {
            M.data[i * 4 + i] = t.get(i);
            ++i;
        }
        return M;
    }

    public void translate(M3d t) {
        int i = 0;
        while (i < 3) {
            int n = 12 + i;
            this.data[n] = this.data[n] + (this.data[0 + i] * t.get(0) + this.data[4 + i] * t.get(1) + this.data[8 + i] * t.get(2));
            ++i;
        }
    }

    public static M4x4 rotation(M3d axis, double phi) {
        double c = Math.cos(phi);
        double s = Math.sin(phi);
        double t = 1.0 - c;
        M4x4 M = new M4x4();
        double[] data = M.getData();
        axis = axis.normalized();
        double x = axis.getX();
        double y = axis.getY();
        double z = axis.getZ();
        data[0] = t * x * x + c;
        data[1] = t * x * y + s * z;
        data[2] = t * x * z - s * y;
        data[3] = 0.0;
        data[4] = t * x * y - s * z;
        data[5] = t * y * y + c;
        data[6] = t * y * z + s * x;
        data[7] = 0.0;
        data[8] = t * x * z + s * y;
        data[9] = t * y * z - s * x;
        data[10] = t * z * z + c;
        data[11] = 0.0;
        data[12] = 0.0;
        data[13] = 0.0;
        data[14] = 0.0;
        data[15] = 1.0;
        return M;
    }

    public void rotate(M3d axis, double phi) {
        this.data = this.times(M4x4.rotation(axis, phi)).getData();
    }

    public M3d getCol(int col) {
        return new M3d(this.data[col * 4 + 0], this.data[col * 4 + 1], this.data[col * 4 + 2]);
    }

    public M3d getRow(int row) {
        return new M3d(this.data[0 + row], this.data[4 + row], this.data[8 + row]);
    }

    public M3d times(M3d C) {
        double a = this.data[0] * C.get(0) + this.data[4] * C.get(1) + this.data[8] * C.get(2) + this.data[12];
        double b = this.data[1] * C.get(0) + this.data[5] * C.get(1) + this.data[9] * C.get(2) + this.data[13];
        double c = this.data[2] * C.get(0) + this.data[6] * C.get(1) + this.data[10] * C.get(2) + this.data[14];
        return new M3d(a, b, c);
    }

    public M4x4 extract3x3() {
        M4x4 M = new M4x4();
        double[] d = M.getData();
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                d[i * 4 + j] = i < 3 ? this.data[i * 4 + j] : (i == j ? 1.0 : 0.0);
                ++j;
            }
            ++i;
        }
        return M;
    }

    public String toString() {
        String str = new String();
        int i = 0;
        while (i < 16) {
            str = String.valueOf(str) + this.data[i];
            if (i < 15) {
                str = String.valueOf(str) + ", ";
            }
            ++i;
        }
        return str.toString();
    }
}

