/*
 * Decompiled with CFR 0.152.
 */
package framework;

public class M3d {
    static final double EPSILON = 1.0E-5;
    double[] vec = new double[3];

    public M3d() {
        this.vec[2] = 0.0;
        this.vec[1] = 0.0;
        this.vec[0] = 0.0;
    }

    public M3d(double x, double y, double z) {
        this.vec[0] = x;
        this.vec[1] = y;
        this.vec[2] = z;
    }

    public M3d(M3d A) {
        this.vec[0] = A.vec[0];
        this.vec[1] = A.vec[1];
        this.vec[2] = A.vec[2];
    }

    public void set(M3d A) {
        this.vec[0] = A.vec[0];
        this.vec[1] = A.vec[1];
        this.vec[2] = A.vec[2];
    }

    public void set(double[] data) {
        this.vec[0] = data[0];
        this.vec[1] = data[1];
        this.vec[2] = data[2];
    }

    public M3d neg() {
        return new M3d(-this.vec[0], -this.vec[1], -this.vec[2]);
    }

    public M3d plus(M3d B) {
        return new M3d(this.vec[0] + B.vec[0], this.vec[1] + B.vec[1], this.vec[2] + B.vec[2]);
    }

    public M3d minus(M3d B) {
        return new M3d(this.vec[0] - B.vec[0], this.vec[1] - B.vec[1], this.vec[2] - B.vec[2]);
    }

    public M3d times(double k) {
        return new M3d(k * this.vec[0], k * this.vec[1], k * this.vec[2]);
    }

    public M3d cross(M3d B) {
        return new M3d(this.vec[1] * B.vec[2] - this.vec[2] * B.vec[1], this.vec[2] * B.vec[0] - this.vec[0] * B.vec[2], this.vec[0] * B.vec[1] - this.vec[1] * B.vec[0]);
    }

    public M3d lerp(M3d B, double t) {
        return new M3d(this.vec[0] + t * (B.vec[0] - this.vec[0]), this.vec[1] + t * (B.vec[1] - this.vec[1]), this.vec[2] + t * (B.vec[2] - this.vec[2]));
    }

    public M3d normalized() {
        double len = this.length();
        if (len > 1.0E-5) {
            return this.times(1.0 / len);
        }
        return new M3d(0.0, 0.0, 0.0);
    }

    public double get(int i) {
        return this.vec[i];
    }

    public double[] get() {
        return this.vec;
    }

    public void set(int i, double val) {
        this.vec[i] = val;
    }

    public double getX() {
        return this.vec[0];
    }

    public void setX(double val) {
        this.vec[0] = val;
    }

    public double getY() {
        return this.vec[1];
    }

    public void setY(double val) {
        this.vec[1] = val;
    }

    public double getZ() {
        return this.vec[2];
    }

    public void setZ(double val) {
        this.vec[2] = val;
    }

    public boolean equals(M3d A) {
        return this.cmp(A, 1.0E-5);
    }

    public double dot(M3d A) {
        return this.vec[0] * A.vec[0] + this.vec[1] * A.vec[1] + this.vec[2] * A.vec[2];
    }

    public boolean cmp(M3d A, double epsilon) {
        return Math.abs(this.vec[0] - A.vec[0]) < epsilon && Math.abs(this.vec[1] - A.vec[1]) < epsilon && Math.abs(this.vec[2] - A.vec[2]) < epsilon;
    }

    public double length() {
        return Math.sqrt(this.vec[0] * this.vec[0] + this.vec[1] * this.vec[1] + this.vec[2] * this.vec[2]);
    }

    public double lengthSquared() {
        return this.vec[0] * this.vec[0] + this.vec[1] * this.vec[1] + this.vec[2] * this.vec[2];
    }

    public boolean lessThan(M3d A) {
        return this.getX() < A.getX() || this.getX() == A.getX() && this.getY() < A.getY() || this.getX() == A.getX() && this.getY() == A.getY() && this.getZ() < A.getZ();
    }

    public M3d toAxis() {
        double x = Math.abs(this.getX());
        double y = Math.abs(this.getY());
        double z = Math.abs(this.getZ());
        if (x >= y && x >= z) {
            return new M3d(this.getX() < 0.0 ? -1 : 1, 0.0, 0.0);
        }
        if (y >= x && y >= z) {
            return new M3d(0.0, this.getY() < 0.0 ? -1 : 1, 0.0);
        }
        if (z >= x && z >= y) {
            return new M3d(0.0, 0.0, this.getZ() < 0.0 ? -1 : 1);
        }
        return new M3d(0.0, 0.0, 0.0);
    }

    public String toString() {
        return String.valueOf(this.getX()) + ", " + this.getY() + ", " + this.getZ();
    }
}

