/*
 * Decompiled with CFR 0.152.
 */
package abnormals;

import framework.M3d;
import framework.M4x4;
import framework.Renderer;
import java.awt.event.KeyEvent;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class NormalsAnimation
extends Renderer {
    private int tick = 0;
    private int displayListId = -1;
    private boolean paused = true;

    @Override
    public String getTitle() {
        return "Normals animation";
    }

    @Override
    public void init(GLAutoDrawable glDrawable) {
        super.init(glDrawable);
        GL gl = glDrawable.getGL();
        GLU glu = new GLU();
        GLUquadric quadric = glu.gluNewQuadric();
        gl.glCullFace(1029);
        gl.glEnable(2884);
        glu.gluQuadricOrientation(quadric, 100020);
        this.displayListId = gl.glGenLists(1);
        gl.glNewList(this.displayListId, 4864);
        gl.glPushMatrix();
        gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        glu.gluSphere(quadric, 1.0, 50, 50);
        gl.glPopMatrix();
        gl.glEndList();
    }

    public void arrow(GL gl, M3d from, M3d to) {
        M3d axis = to.minus(from).normalized();
        M3d pt = axis.cross(new M3d(0.0, 1.0, 0.0)).normalized().times(0.02);
        gl.glBegin(7);
        double t = 0.0;
        while (t <= 6.283285307179586) {
            M4x4 T1 = M4x4.rotation(axis, t);
            M4x4 T2 = M4x4.rotation(axis, t + 0.19634954084936207);
            gl.glNormal3dv(T1.times(pt).plus(T2.times(pt)).normalized().get(), 0);
            gl.glVertex3dv(to.plus(T1.times(pt)).get(), 0);
            gl.glVertex3dv(from.plus(T1.times(pt)).get(), 0);
            gl.glVertex3dv(from.plus(T2.times(pt)).get(), 0);
            gl.glVertex3dv(to.plus(T2.times(pt)).get(), 0);
            t += 0.19634954084936207;
        }
        gl.glEnd();
        gl.glBegin(6);
        gl.glVertex3dv(to.plus(to.minus(from).times(0.5)).get(), 0);
        t = 0.0;
        while (t <= 6.283285307179586) {
            M4x4 T = M4x4.rotation(axis, t);
            M3d p = T.times(pt).times(2.0);
            gl.glNormal3dv(p.cross(axis).cross(p.minus(axis)).normalized().get(), 0);
            gl.glVertex3dv(to.plus(p).get(), 0);
            t += 0.19634954084936207;
        }
        gl.glEnd();
    }

    M3d intersectPlane(M3d linePtOne, M3d linePtTwo, M3d planePtOne, M3d planePtTwo, M3d planePtThree) {
        M3d D;
        M3d N = planePtTwo.minus(planePtOne).cross(planePtThree.minus(planePtOne)).normalized();
        if (N.dot(D = linePtTwo.minus(linePtOne).normalized()) == 0.0) {
            return null;
        }
        double t = (N.dot(planePtOne) - N.dot(linePtOne)) / N.dot(D);
        return linePtOne.plus(D.times(t));
    }

    private M3d getTick(int i, double t) {
        return new M3d(Math.sin(t) * Math.cos((double)i * Math.PI / 8.0), Math.sin(t) * Math.sin((double)i * Math.PI / 8.0), Math.cos(t));
    }

    public void display(GLAutoDrawable glDrawable) {
        GL gl = glDrawable.getGL();
        double t = (Math.sin((double)this.tick * Math.PI / 500.0 + 1.5707963267948966) + 1.0) * Math.PI / 4.0;
        this.preDisplay(glDrawable);
        M3d A = new M3d(0.0, 0.0, 1.0);
        M3d B = this.getTick(0, t);
        M3d C = this.getTick(2, t);
        gl.glLineWidth(3.0f);
        gl.glDisable(2896);
        gl.glBegin(3);
        gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        double d = 0.0;
        while (d <= 6.283285307179586) {
            gl.glVertex3d(Math.sin(t) * Math.cos(d), Math.sin(t) * Math.sin(d), Math.cos(t));
            d += 0.19634954084936207;
        }
        gl.glEnd();
        gl.glColor4f(0.2f, 0.8f, 0.2f, 1.0f);
        gl.glBegin(1);
        gl.glVertex3dv(A.get(), 0);
        gl.glVertex3dv(B.get(), 0);
        gl.glVertex3dv(A.get(), 0);
        gl.glVertex3dv(C.get(), 0);
        gl.glEnd();
        gl.glBegin(3);
        double u = 0.0;
        while (u < t) {
            gl.glVertex3dv(A.plus(B.minus(A).times(u / t)).normalized().get(), 0);
            u += 0.01;
        }
        gl.glEnd();
        gl.glBegin(3);
        u = 0.0;
        while (u < t) {
            gl.glVertex3dv(A.plus(C.minus(A).times(u / t)).normalized().get(), 0);
            u += 0.01;
        }
        gl.glEnd();
        gl.glEnable(2896);
        gl.glLineWidth(1.0f);
        gl.glColor4f(0.1f, 0.6f, 0.1f, 1.0f);
        gl.glDisable(2884);
        gl.glBegin(4);
        gl.glNormal3dv(B.minus(A).cross(C.minus(A)).normalized().get(), 0);
        gl.glVertex3dv(A.get(), 0);
        gl.glVertex3dv(B.get(), 0);
        gl.glVertex3dv(C.get(), 0);
        gl.glEnd();
        gl.glEnable(2884);
        int i = 0;
        while (i < 8) {
            M3d D = this.getTick(i * 2 + 1, t / 2.0);
            M3d E = D.times(1.5);
            if (i == 0) {
                D = this.intersectPlane(E, D, A, B, C);
            } else if (i == 1) {
                gl.glColor4f(0.2f, 0.2f, 0.8f, 1.0f);
            }
            this.arrow(gl, D, E);
            ++i;
        }
        gl.glColor4f(0.8f, 0.8f, 0.8f, 0.6f);
        gl.glCallList(this.displayListId);
        if (!this.paused) {
            ++this.tick;
        }
        this.postDisplay(glDrawable);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyChar()) {
            case ' ': {
                this.paused = !this.paused;
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }
}

