/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.Vector;

class VoronoiClass
extends Vector<Paintable> {
    public VoronoiClass(int width, int height, int points) {
        if (points > 0) {
            boolean flag = false;
            int x = 30;
            while (x < width) {
                int start_y = (flag ^= true) ? 0 : width / 16;
                int y = 30 + start_y;
                while (y < height) {
                    this.addElement(new MyPoint(x, y));
                    y += height / 2;
                }
                x += width / 8;
            }
        }
        this.checkDegenerate();
    }

    public void checkDegenerate() {
        if (this.size() > 1) {
            MyPoint min;
            MyPoint next = min = (MyPoint)this.elementAt(0);
            int i = 1;
            while (i < this.size()) {
                Object element = this.elementAt(i);
                if (element instanceof MyPoint) {
                    if (((MyPoint)element).x <= min.x) {
                        next = min;
                        min = (MyPoint)element;
                    } else if (((MyPoint)element).x <= min.x) {
                        next = (MyPoint)element;
                    }
                }
                ++i;
            }
            if (min.x == next.x && min != next) {
                min.x -= 1.0;
                System.out.println("Moved point: " + next.x + " -> " + min.x);
            }
        }
    }

    public void paint(Graphics g, boolean flag) {
        int i = 0;
        while (i < this.size()) {
            if (flag || !(this.elementAt(i) instanceof MyLine)) {
                ((Paintable)this.elementAt(i)).paint(g);
            }
            ++i;
        }
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.size()) {
            if (this.elementAt(i) instanceof MyLine) {
                this.removeElementAt(i--);
            }
            ++i;
        }
    }
}

