/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class MyCanvas
extends Canvas
implements MouseListener {
    Graphics offScreenGraphics;
    Image offScreenImage;
    int XPos;
    VoronoiClass Voronoi;
    DelaunayClass Delaunay;
    boolean drawCircles = false;
    boolean drawBeach = true;
    boolean drawVoronoiLines = true;
    boolean drawDelaunay = false;
    EventQueue Events;
    ArcTree Arcs;

    public MyCanvas(int i, int j, int k) {
        this.addMouseListener(this);
        this.Voronoi = new VoronoiClass(i, j, k);
    }

    public synchronized void init() {
        this.offScreenImage = this.createImage(this.getBounds().width, this.getBounds().height);
        this.offScreenGraphics = this.offScreenImage.getGraphics();
        this.XPos = 0;
        this.Arcs = new ArcTree();
        this.Events = new EventQueue();
        this.Voronoi.clear();
        this.Delaunay = new DelaunayClass();
        int i = 0;
        while (i < this.Voronoi.size()) {
            this.Events.insert(new EventPoint((MyPoint)this.Voronoi.elementAt(i)));
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent mouseevent) {
        MyPoint mypoint = new MyPoint(mouseevent.getPoint());
        if (mypoint.x > (double)this.XPos) {
            this.Voronoi.addElement(mypoint);
            this.Voronoi.checkDegenerate();
            this.Events.insert(new EventPoint(mypoint));
            this.repaint();
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        g.setColor(Color.blue);
        this.Voronoi.paint(g, this.drawVoronoiLines);
        g.setColor(Color.red);
        g.drawLine(this.XPos, 0, this.XPos, this.getBounds().height);
        if (this.Events != null && this.Arcs != null) {
            g.setColor(Color.black);
            this.Events.paint(g, this.drawCircles);
            this.Arcs.paint(g, this.XPos, this.drawVoronoiLines, this.drawBeach);
        }
        if (this.drawDelaunay) {
            g.setColor(Color.gray);
            this.Delaunay.paint(g);
        }
    }

    @Override
    public void update(Graphics g) {
        this.offScreenGraphics.setClip(g.getClipBounds());
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, this);
    }

    public synchronized boolean singlestep() {
        if (this.Events.Events == null || (double)this.XPos < this.Events.Events.x) {
            ++this.XPos;
        }
        while (this.Events.Events != null && (double)this.XPos >= this.Events.Events.x) {
            EventPoint eventpoint = this.Events.pop();
            this.XPos = Math.max(this.XPos, (int)eventpoint.x);
            eventpoint.action(this);
            this.Arcs.checkBounds(this, this.XPos);
        }
        if (this.XPos > this.getBounds().width && this.Events.Events == null) {
            this.Arcs.checkBounds(this, this.XPos);
        }
        this.repaint();
        return this.Events.Events != null || this.XPos < 1000 + this.getBounds().width;
    }

    public synchronized void step() {
        EventPoint eventpoint = this.Events.pop();
        if (eventpoint != null) {
            this.XPos = Math.max(this.XPos, (int)eventpoint.x);
            eventpoint.action(this);
        } else if (this.XPos < this.getBounds().width) {
            this.XPos = this.getBounds().width;
        } else {
            this.init();
        }
        this.Arcs.checkBounds(this, this.XPos);
        this.repaint();
    }

    public synchronized void clear() {
        this.Voronoi = new VoronoiClass(this.getBounds().width, this.getBounds().height, 0);
        this.restart();
    }

    public synchronized void restart() {
        this.init();
        this.repaint();
    }
}

