module cache_sorter #(parameter INPUT_WIDTH=1'bX)
(
	input clk,
	input [INPUT_WIDTH-1:0] x0,
	input [INPUT_WIDTH-1:0] x1,
	input [INPUT_WIDTH-1:0] x2,
	input [INPUT_WIDTH-1:0] x3,
	input [1:0] tiebreaker,
	output [1:0] y
);
	
	/*
	tie	0123
	p0	0321
	p1	1032
	p2	2103
	p3	3210
	*/
	wire [1:0] p0=2'd0-tiebreaker;
	wire [1:0] p1=2'd1-tiebreaker;
	wire [1:0] p2=2'd2-tiebreaker;
	wire [1:0] p3=2'd3-tiebreaker;
	
	wire [INPUT_WIDTH+1:0] s0={x0,p0};
	wire [INPUT_WIDTH+1:0] s1={x1,p1};
	
	wire [INPUT_WIDTH+1:0] min01=s0 < s1 ? s0 : s1;
	
	reg [INPUT_WIDTH+1:0] reg01;
	reg [INPUT_WIDTH+1:0] s2;
	reg [INPUT_WIDTH+1:0] s3;
	reg [1:0] regtiebreaker;
	always @(posedge clk)
	begin
		reg01 <= min01;
		s2 <= {x2,p2};
		s3 <= {x3,p3};
		regtiebreaker <= tiebreaker;	
	end

	wire [INPUT_WIDTH+1:0] min012=reg01 < s2 ? reg01 : s2;
	wire [INPUT_WIDTH+1:0] min0123=min012 < s3 ? min012 : s3;
	
	//Work out which item is the smallest one from the tiebreaker value
	wire [1:0] min=min0123[1:0];
	assign y=min+regtiebreaker;
	
endmodule