unsigned short kbhit()
{
	volatile unsigned int *const keyboard = (volatile unsigned int*) 1004;

	unsigned int writeread = *keyboard;
	unsigned short read = writeread & 0xffff;
	unsigned short write = writeread >> 16;
	if( read == write )
		return 0;
	else
		return 1;
}

unsigned short getk()
{
	volatile unsigned short *const keyboard = (volatile unsigned short*) 1006;
	volatile unsigned short *const buffer = (volatile unsigned short*) 1008;

	while( kbhit() == 0 )
		;

	unsigned short read = *keyboard;
	*keyboard = (read + 2) & 0x0f;
	return buffer[read / 2];
}

unsigned short getkori()
{
	volatile unsigned short *const interrupted = (volatile unsigned short*) 996;

	*interrupted = 0;

	while( *interrupted == 0 )
		;

	if( kbhit() == 0 )
		return 0;
	else
		return getk();
}

char getc()
{
	unsigned short key;
	while ( ((key = getk()) & 0x8100) != 0 )
		;

	return key & 0xff;
}
