#include "exception.h"
#include "fakeinit.h"
#include "serial.h"

void __die()
{
	for(;;)
	{ }
}

unsigned char __bootloader_readbyte()
{
	unsigned short c;
	volatile unsigned short *const jtaguartdata = (volatile unsigned short*) 0x10000000;
	while( ((c = *jtaguartdata) & 0x8000) == 0)
		;
	return (unsigned char) c;
}

unsigned int __bootloader_readword()
{
	unsigned char c0 = __bootloader_readbyte();
	unsigned char c1 = __bootloader_readbyte();
	unsigned char c2 = __bootloader_readbyte();
	unsigned char c3 = __bootloader_readbyte();
	return (c0 << 24) | (c1 << 16) | (c2 << 8) | c3;
}

unsigned int __bootloader_senddot()
{
	volatile unsigned short *const jtaguartdata = (volatile unsigned short*) 0x10000000;
	*jtaguartdata = '.';
}

void __bootloader(void)
{
	serialWriteString("\r\n\r\nThis is the MIPS bootloader September 2006\r\n    (subversion details: $LastChangedRevision: 1038 $)\r\n");
	
	serialWriteString("Waiting for host pc...");
	volatile unsigned short *const jtaguartcontrol = (volatile unsigned short*) 0x10000002;
	while( (*jtaguartcontrol & 0x0400) == 0 )
		;
	serialWriteString("              [ DONE ]\r\n");
	
	serialWriteString("Waiting for greeting...");
	char greeting[65]; greeting[64] = '\0';
	unsigned int i;
	for(i = 0; i < 64; ++i)
	{
		greeting[i] = (char) __bootloader_readbyte();
		if( greeting[i] == '\0' )
			break;
	}
	if( i == 64 )
	{
		serialWriteString("             [FAILED]\r\n");
		__die();
	}
	__bootloader_senddot();
	serialWriteString("             [ DONE ]\r\n");
	serialWriteString("Received: HELO ");
	serialWriteString(greeting);
	serialWriteNL();
	
	serialWriteString("Data size = ");
	unsigned int len = __bootloader_readword();
	serialWriteDecimal(len * 4);
	serialWriteString(" bytes\r\n");
	
	serialWriteString("Now receiving data..");
	volatile unsigned int* mem = 0;
	for(i = 0; i < len; ++i)
	{
		*mem++ = __bootloader_readword();
		if( (i % 8192) == 0 )
			serialWriteChar('.');
	}
	serialWriteNL();
	
	// Create the jump in the fakeinit (making it into an init)
	mem = (unsigned int*)(262 * 4);
	*mem = 0x0C000400;
	
	serialWriteString("Now switching to user mode.  Goodbye :)\r\n\r\n");
	asm("li $sp,0x0077FFFC");
	asm("jeret 1024");
}
