/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.server;


import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import t3.hrd.input.KeyboardInput;
import t3.hrd.input.PointInputDeviceState;
import t3.hrd.input.ShapeInputDeviceState;
import t3.hrd.state.Tile;


/**
 * Allows you to customise the RemoteHRD server by specifying callback
 * methods to handle clients joining and leaving, pointinputdevice state changes, 
 * keyboard input, and any other messages received from the client.
 * 
 * @author pjt40
 *
 */
public interface RemoteHRDServerCallBacks {

	public void remoteServerCallBack_receivedOtherMessageFromClientOrInputSource(Object msg);
	public void remoteServerCallBack_clientLeft(int clientId);
	public void remoteServerCallBack_clientJoined(int clientId);
	public int remoteServerCallBack_decideShouldCompressInitial(BufferedImage b);
	public void remoteServerCallBack_repaintUnbackedTile(Tile tile, Rectangle r, BufferedImage update, Graphics2D g);
	public void remoteServerCallBack_keyboardInput(KeyboardInput k);
	public void remoteServerCallBack_pointInputDeviceStateChanged(PointInputDeviceState pids);
	public void remoteServerCallBack_shapeInputDeviceStateChanged(ShapeInputDeviceState sids);
}
