/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.server;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import t3.hrd.util.ThingsPSTimer;

public class BandwidthMeasuringOutputStream extends FilterOutputStream {

    private ThingsPSTimer tpst;
    public BandwidthMeasuringOutputStream(OutputStream out) {
        super(out);
        this.tpst = new ThingsPSTimer("kBps = ", "", 100000000000L, 0.3, 2000, 8000, 0.001);
        // TODO Auto-generated constructor stub
    }

    
    
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        // TODO Auto-generated method stub
        tpst.moreThings(len);
        super.write(b, off, len);
    }



    @Override
    public void write(byte[] b) throws IOException {
        // TODO Auto-generated method stub
        tpst.moreThings(b.length);
        super.write(b);
    }



    @Override
    public void write(int b) throws IOException {
        // TODO Auto-generated method stub
        tpst.moreThings(1);
        super.write(b);
    }



}
