/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios.swing;

import java.util.logging.Logger;

import javax.swing.JInternalFrame;

/**
 * Represents a frame for a SwingFramePortfolio into which you can place swing components. 
 * @author pjt40
 *
 */
public final class FrameForPortfolio extends JInternalFrame {
	
	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.swing");
	
	// MUSTN'T TOUCH LOCATION OR SIZE OR ICONIFY OR ANYTHING LIKE THAT!
	FrameForPortfolio(SwingFramePortfolio p, final int w, final int h) {
    	super("Frame for "+p.toString());
    	        	
    	// we need to do the next but in the awt thread to avoid any nasty deadlock problems.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
				SwingFramePortfolio.setUpOuterFrameIfNotAlready();
				SwingFramePortfolio.outerFrame.outerFrameContent.add(FrameForPortfolio.this);
				FrameForPortfolio.this.setLocation(0,SwingFramePortfolio.nextY);
				SwingFramePortfolio.nextY+=h+100;
				FrameForPortfolio.this.setSize(w,h);
				FrameForPortfolio.this.setResizable(false);
				FrameForPortfolio.this.setClosable(false);
				FrameForPortfolio.this.setMaximizable(false);
				FrameForPortfolio.this.setVisible(true);
				int dx = w - FrameForPortfolio.this.getRootPane().getWidth();
				int dy = h - FrameForPortfolio.this.getRootPane().getHeight();
				FrameForPortfolio.this.setSize(w+dx, h+dy);
				
				FrameForPortfolio.this.requestFocusInWindow();
            }
		});
	}
	
}