/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios.swing;

import java.util.logging.Level;
import java.util.logging.Logger;

public class AWTErrorHandler {

	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.swing");
	public AWTErrorHandler() {
		// called only by awt.
	}

	public void handle(Throwable e) {
		if(logger!=null) {
			logger.log(Level.SEVERE,"Caught exception and about to exit",e);
		}
		e.printStackTrace();
		System.exit(1);
	}
	
	static void setHandler() {
		System.setProperty("sun.awt.exception.handler",AWTErrorHandler.class.getName());
	}
}