/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */

package t3.portfolios;


/**
 * A data structure class representing a single point input device. Two instances with
 * identical field data will return true when compared using the .equals() method.
 * 
 * @author pjt40
 *
 */
public final class PointInputDevice {
	public final Person person;
	public final int pointInputDeviceType;
	public PointInputDevice(Person person, int pointInputDeviceType) {
		this.person = person;
		this.pointInputDeviceType = pointInputDeviceType;
	}
	public boolean equals(Object o) {
		return o instanceof PointInputDevice
		&& ((PointInputDevice) o).person.equals(this.person)
		&& ((PointInputDevice) o).pointInputDeviceType==this.pointInputDeviceType;
	}
	public int hashCode() {
		// toopt
		return (this.person.hashCode()<<8)+this.pointInputDeviceType;
	}
	public String toString() {
		return super.toString() + " person="+this.person+" pidType="+this.pointInputDeviceType;
	}
}