/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;


import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;



/**
 * @author pjt40
 * Just a plain colour.
 */
public class PlainPortfolio extends Portfolio  {

	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios");
	private final Color c; 
	
	
	public PlainPortfolio(
			PortfolioServer t3,
			Portfolio parent,
			PortfolioCommonBehaviour c,
			Color cc,
			int jotterTileFlags
		) {
		super(false, t3, parent, c, true, 1, 1, jotterTileFlags, 0);
		this.c = cc;
	}
	
	
	
	public boolean customProcessEventForThisPortfolioNotChildren(final PortfolioEvent e, boolean bubbled) { 
		return false;
	}
	
	public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
	    g.setColor(this.c);
        g.fillRect(0,0,1,1);
	}

	public void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		
	}
	
	public  void customProcessEndOfFDOPmode(PointInputDevice pen, int button) {
		
	}

	
	
	
}
