/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios;


import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

import t3.hrd.state.JOGLHelper;


/**
 * A jotter portfolio has a tile which contains an image into which you can draw using a Graphics2D.
 * The user can then draw into the tile using a point input device.
 * <p>
 * Call getGraphicsToDrawIntoJotter, then do the drawing, then call triggerRepaint to
 * send the update to the display.
 * 
 * @author pjt40
 *
 */
public class JotterPortfolio extends Portfolio  {

	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios");
	

	private BufferedImage bi;
	
	
	public JotterPortfolio(
			PortfolioServer t3,
			Portfolio parent,
			PortfolioCommonBehaviour c,
			int jotterTileWidth,
			int jotterTileHeight,
			int jotterTileFlags
		) {
		super(false, t3, parent, c, true, jotterTileWidth, jotterTileHeight, jotterTileFlags, 0);
		this.bi = this.createCompatibleBufferedImage(jotterTileWidth, jotterTileHeight);
	}
	
	
	
	public boolean customProcessEventForThisPortfolioNotChildren(final PortfolioEvent e, boolean bubbled) { 
		if(
			e.eventType==e.EVENT_PID_MOVE 
			&& !bubbled
			&& e.oldPositionKnown
			&& e.pointInputDevice.pointInputDeviceType==0 
			&& portfolioServer.isButtonDown(e.pidButtons,0)
			&& e.isOldPointOnTile(this)
		) {
			int tileX = e.getTILEx(this);
			int tileY = e.getTILEy(this);
			int tileXold = e.getTILExOld(this);
			int tileYold = e.getTILEyOld(this);
			if(tileXold>=0 && tileYold>=0 && tileXold<this.getTileWidthInTILE() && tileYold<this.getTileHeightInTILE()) {
				Rectangle r = new Rectangle(
					Math.min(tileX, tileXold),
					Math.min(tileY, tileYold),
					Math.abs(tileX-tileXold)+1,
					Math.abs(tileY-tileYold)+1
				);
				try {
					Graphics2D g = (Graphics2D) bi.createGraphics();
					g.setColor( Color.BLUE );
					g.drawLine(tileXold, tileYold, tileX, tileY);
					this.triggerRepaintTile(r);
				} catch(Exception ee) {
					throw new RuntimeException(ee);
				}
				return true;
			} else {
				// old coord not on tile so don't draw
			}
		}
		return false;
	}
	
	public Graphics2D getGraphicsToDrawIntoJotter() {
		return this.bi.createGraphics();
	}
	
	public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
		JOGLHelper.pastePartOfImageAIntoPartOfImageBWithoutSharing(0,0,r.x,r.y,r.width,r.height,this.bi,update);
	}

	public void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		
	}
	
	public  void customProcessEndOfFDOPmode(PointInputDevice pen, int button) {
		
	}

	
	
	
}
