/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.util;


import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;

import t3.hrd.input.KeyboardInput;
import t3.hrd.input.PointInputDevice;
import t3.hrd.input.PointInputDeviceState;
import t3.hrd.input.ShapeInputDeviceState;
import t3.hrd.renderer.BlendOptions;
import t3.hrd.renderer.HRDRenderer;
import t3.hrd.renderer.HRDRendererCallBacks;
import t3.hrd.renderer.Projector;
import t3.hrd.renderer.ProjectorConfig;
import t3.hrd.renderer.ProjectorTransforms;
import t3.hrd.state.JOGLHelper;
import t3.hrd.state.Tile;
import Jama.Matrix;


/**
 * Routines to calibrate the display and show a test image to check the alignment.
 * Calibration points in the ProjectorConfigs are updated in place.
 * 
 * 
 * @author pjt40
 *
 */
public class Calibrate {

	static HRDRenderer hrd;
	
	/**
	 * @param args
	 */
	
	private static int pointN;
	private static GLU glu = new GLU();
		
	
	private static class MyOtherCallBacksChecker implements HRDRendererCallBacks {
		public void callback_keyboardInput(KeyboardInput k, Object client) {}
		public void callback_pointInputDeviceStateChanged(PointInputDeviceState pids, Object client) {} 	     
        public void callback_shapeInputDeviceStateChanged(ShapeInputDeviceState sids, Object client) {}		
		public void callback_closingBeforeLastOGL() {}
		public void callback_closingAfterWindowsClosed() {}
		public void callback_mouseClicked(MouseEvent e, Projector p){}
	    public void callback_mouseEntered(MouseEvent e, Projector p) {}
	    public void callback_mouseExited(MouseEvent e, Projector p) {}
	    public void callback_mousePressed(MouseEvent e, Projector p) {}
	    public void callback_mouseReleased(MouseEvent e, Projector p) {}
	    public void callback_mouseMoved(MouseEvent e, Projector p) {}
	    public void callback_mouseDragged(MouseEvent e, Projector p) {}	
		public boolean callback_needToRepaintOverlay(Projector p) { return false; }
		public void callback_oglPaintOverlay(GL gl, Projector p) {}
		int frameCount = 0;
		public void callback_oncePerFrame() {
            Color bg = Color.WHITE;
            Color fg = Color.GRAY;
			if(frameCount==0) {
				{
					Tile tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
					BufferedImage b = tt.createCompatibleBufferedImage(128,128);
					Graphics2D g = b.createGraphics();
					g.setColor(bg);
					g.fillRect(0,0,128,128);
					tt.opUpdateContents(0,0,b, 0);
					tt.opSetAff(0,0,1100,1100,0.0);
					tt.opSetVisibility(true);
				}
                {
                    Tile tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(bg);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(1000,0,1100,1100,0.0);
                    tt.opSetVisibility(true);
                }
                {
                    Tile tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(bg);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(0,1000,1100,1100,0.0);
                    tt.opSetVisibility(true);
                }
                {
                    Tile tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(bg);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(1000,1000,1100,1100,0.0);
                    tt.opSetVisibility(true);
                }
				for(int x=0; x<40; x++) {
					for(int y=0; y<50; y++) {
						Tile t = hrd.stateManager.opCreateTileAutogenerateId(32,32,Tile.FLAG_BI_USHORT565RGB_NOT_INTARGB);
						BufferedImage b = t.createCompatibleBufferedImage(32,32);
						Graphics2D g = b.createGraphics();
						g.setColor(fg);
						g.fillRect(0,0,64,64);
						t.opUpdateContents(0,0,b, 0);
						t.opSetAff((y%2)*15.0+x*30.0 ,y*15.0,15.0,15.0,0.0);
						t.opSetVisibility(true);
					}
				}
			} else {
				// do nothing
			}
			frameCount++;
		}
	}
	
	private static class MyOtherCallBacksWhite implements HRDRendererCallBacks {
		public void callback_keyboardInput(KeyboardInput k, Object client) {}
		public void callback_pointInputDeviceStateChanged(PointInputDeviceState pids, Object client) {} 		
		public void callback_shapeInputDeviceStateChanged(ShapeInputDeviceState sids, Object client) {}
		public void callback_closingBeforeLastOGL() {}
		public void callback_closingAfterWindowsClosed() {}
		public void callback_mouseClicked(MouseEvent e, Projector p){}
	    public void callback_mouseEntered(MouseEvent e, Projector p) {}
	    public void callback_mouseExited(MouseEvent e, Projector p) {}
	    public void callback_mousePressed(MouseEvent e, Projector p) {}
	    public void callback_mouseReleased(MouseEvent e, Projector p) {}
	    public void callback_mouseMoved(MouseEvent e, Projector p) {}
	    public void callback_mouseDragged(MouseEvent e, Projector p) {}	
		public boolean callback_needToRepaintOverlay(Projector p) { return false; }
		public void callback_oglPaintOverlay(GL gl, Projector p) {}
		int frameCount = 0;
        Tile tt ;
        int x=0;
		public void callback_oncePerFrame() {
			if(frameCount==0) {
				{
					tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
					BufferedImage b = tt.createCompatibleBufferedImage(128,128);
					Graphics2D g = b.createGraphics();
					g.setColor(Color.GRAY);
					g.fillRect(0,0,128,128);
					tt.opUpdateContents(0,0,b, 0);
					tt.opSetAff(0,0,1100,1100,0.0);
					tt.opSetVisibility(true);
                    
				}
                {
                    tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(Color.GRAY);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(0,1000,1100,1100,0.0);
                    tt.opSetVisibility(true);
                    
                }
                {
                    tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(Color.GRAY);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(1000,0,1100,1100,0.0);
                    tt.opSetVisibility(true);
                    
                }
                {
                    tt = hrd.stateManager.opCreateTileAutogenerateId(128,128,0);
                    BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                    Graphics2D g = b.createGraphics();
                    g.setColor(Color.GRAY);
                    g.fillRect(0,0,128,128);
                    tt.opUpdateContents(0,0,b, 0);
                    tt.opSetAff(1000,1000,1100,1100,0.0);
                    tt.opSetVisibility(true);
                    
                }
                /*} else if(frameCount ==6000 ) {
                BufferedImage b = tt.createCompatibleBufferedImage(128,128);
                Graphics2D g = b.createGraphics();
                g.setColor(Color.WHITE);
                g.fillRect(0,0,128,128);
                tt.opUpdateContents(0,0,b);
			} else if(frameCount % 600 ==0 ) {
                tt.opSetAff(x++,0,2400,2400,0.0);
            */
			} else {
            }
            frameCount++;
		}
	}
	

	private static final double TABLET_XSF = 48.0 * 25.40 / 48000.0;
	private static final double TABLET_YSF = 36.0 * 25.40 / 36000.0;
	
	
	
	public static void showTestChecker(LinkedList<ProjectorConfig> projectorConfigs, LinkedList<PointInputDevice> pids, boolean useMouseAsPid,  BlendOptions bo) throws Exception{
	
		hrd=new HRDRenderer(0, projectorConfigs, new MyOtherCallBacksChecker(), pids, null, false, useMouseAsPid,bo);
		hrd.doItSingleThreaded();
	}
	
	
	
	
	
	public static void showTestWhite(LinkedList<ProjectorConfig> projectorConfigs, LinkedList<PointInputDevice> pids, boolean useMouseAsPid, BlendOptions bo) throws Exception{
	
		hrd=new HRDRenderer(0, projectorConfigs, new MyOtherCallBacksWhite(), pids, null, false, useMouseAsPid, bo);
		hrd.doItSingleThreaded();
	}
	
	
	
	
	
	public static void calibrate(ProjectorConfig projectorConfig, PointInputDevice pid) throws Exception {
				
		
		int nCalibPoints = getmWOGLcalibPointsClockwise().length;
				
		Frame frame = Projector.createOGLWindow(projectorConfig, new MyGLRendererForCalibrate(), null);
		final GLCanvas canvas = (GLCanvas) frame.getComponent(0);
		canvas.addFocusListener( new FocusAdapter() {
			// but this works!
			public void focusGained(FocusEvent e){
				canvas.repaint();
			}
		});

		Thread.currentThread().sleep(2000);
		
		Matrix[] mDESKcalibrationPoints = new Matrix[nCalibPoints];
		
		for(pointN=0; pointN<nCalibPoints; pointN++) {

			canvas.display();
            canvas.swapBuffers();
			// wait until no button pressed
			do {
				pid.updateState();
				canvas.display();
                canvas.swapBuffers();
			} while(pid.state.positionAndButtonsKnown && pid.state.buttons!=0);
			
			//	wait until a button is pressed
			do {
				pid.updateState();
				canvas.display();
                canvas.swapBuffers();
			} while(!pid.state.positionAndButtonsKnown || pid.state.buttons==0);
									
			mDESKcalibrationPoints[pointN] = JOGLHelper.getMFromD(pid.state.DESKx, pid.state.DESKy, 1.0);
			
		}

		frame.dispose();
		
		Matrix mWOGLtoDESK = JOGLHelper.getPlaneToPlaneHomogMatrixFromN2hmPointCorrespondances(getmWOGLcalibPointsClockwise(), mDESKcalibrationPoints,mDESKcalibrationPoints.length);
		
		projectorConfig.mDESKcornersOfProjectorLimitClockwiseInWOGL= 
			JOGLHelper.applyMatrixToSetOfMatrices(
				mWOGLtoDESK,
				ProjectorTransforms.getmWOGLcornersClockwise()
			);
		
	}
	
	
	
	public static void showGrid(List<ProjectorConfig> projectorConfigs) throws Exception {
				
		List<Frame> frames = new LinkedList<Frame>();

		for(ProjectorConfig projectorConfig: projectorConfigs) {
			MyGLRendererForGrid g = new MyGLRendererForGrid();
			Frame frame = Projector.createOGLWindow(projectorConfig, g, null);
			final GLCanvas canvas = (GLCanvas) frame.getComponent(0);
			canvas.addFocusListener( new FocusAdapter() {
				// but this works!
				public void focusGained(FocusEvent e){
					canvas.display();
				}
			});
			g.setWidthAndHeight(frame.getWidth(),frame.getHeight());
			canvas.display();
            canvas.swapBuffers();
			frames.add(frame);
		}
	
		Thread.sleep(60000);
		
		for(Frame frame: frames) {
			frame.dispose();
		}	
		
	}
	
	
	

	private static class MyGLRendererForCalibrate implements GLEventListener {
		
		
		public void init(GLAutoDrawable drawable) {
			// called by our canvas
			GL gl = drawable.getGL();
			gl.setSwapInterval(1);
			gl.glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
			gl.glShadeModel(gl.GL_FLAT);
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
		}
			
		public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
			// called by our canvas
			GL gl = drawable.getGL();
			// no need to call glViewport - it's done automatically			
			gl.glMatrixMode( GL.GL_PROJECTION ); 
			gl.glLoadIdentity();	
			gl.glFrustum(
					ProjectorTransforms.openGlView_left, 
					ProjectorTransforms.openGlView_left+ProjectorTransforms.openGlView_width, 
					ProjectorTransforms.openGlView_bottom, 
					ProjectorTransforms.openGlView_bottom+ProjectorTransforms.openGlView_height, 
					ProjectorTransforms.openGlView_near, 
					ProjectorTransforms.openGlView_far
					);
			gl.glMatrixMode(gl.GL_MODELVIEW);
			gl.glLoadIdentity(); 
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
		}
			
			
		public void display(GLAutoDrawable drawable) {
			// called by our canvas
			// we must now redraw because if we don't then
			// the display will not necessarily be stable because of back buffering
				
			GL gl = drawable.getGL();				

			gl.glColor3f(0.0f,0.0f,0.0f);
			gl.glClear( GL.GL_COLOR_BUFFER_BIT );
			gl.glColor3f(1.0f,1.0f,1.0f);
			
			double[] dTOGLp =
				JOGLHelper.getDFromM(
					ProjectorTransforms.mWOGLtoTOGL.times(
						getmWOGLcalibPointsClockwise()[pointN]
					)
				);
			double d = (ProjectorTransforms.openGlView_width/20.0)/dTOGLp[3];
			
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]+d,dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glEnd();
			
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]-d,dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glEnd();

			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1]+d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();
			
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1]-d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();
			/*
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]+d,dTOGLp[1]+d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();
			
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]+d,dTOGLp[1]-d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();
			
			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]-d,dTOGLp[1]-d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();				

			gl.glBegin(gl.GL_LINES);
			gl.glVertex4d(dTOGLp[0],dTOGLp[1],dTOGLp[2],dTOGLp[3]);
			gl.glVertex4d(dTOGLp[0]-d,dTOGLp[1]+d,dTOGLp[2],dTOGLp[3]);
			gl.glEnd();*/
			
			// todo need to dispose of blend texture if we're closing
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
				
		}
		
		public void displayChanged(GLAutoDrawable drawable,
				boolean modeChanged,
				boolean deviceChanged)
		{
		}
		
	}
	
	
private static class MyGLRendererForGrid implements GLEventListener {
		
		int w=20, h=20;
	
		public void setWidthAndHeight(int w, int h) {
			this.w=w; this.h=h;
		}
		
		public void init(GLAutoDrawable drawable) {
			// called by our canvas
			GL gl = drawable.getGL();
			gl.setSwapInterval(1);
			gl.glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
			gl.glShadeModel(gl.GL_FLAT);
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
		}
			
		public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
			// called by our canvas
			GL gl = drawable.getGL();
			// no need to call glViewport - it's done automatically			
			gl.glMatrixMode( GL.GL_PROJECTION ); 
			gl.glLoadIdentity();	
			gl.glFrustum(
					ProjectorTransforms.openGlView_left, 
					ProjectorTransforms.openGlView_left+ProjectorTransforms.openGlView_width, 
					ProjectorTransforms.openGlView_bottom, 
					ProjectorTransforms.openGlView_bottom+ProjectorTransforms.openGlView_height, 
					ProjectorTransforms.openGlView_near, 
					ProjectorTransforms.openGlView_far
					);
			gl.glMatrixMode(gl.GL_MODELVIEW);
			gl.glLoadIdentity(); 
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
		}
			
			
		public void display(GLAutoDrawable drawable) {
			// called by our canvas
			// we must now redraw because if we don't then
			// the display will not necessarily be stable because of back buffering
			
			GL gl = drawable.getGL();				

			gl.glClear( GL.GL_COLOR_BUFFER_BIT );
			gl.glColor3f(1.0f,1.0f,1.0f);
			//System.out.println(""+w+" "+h);
			for(int x=0; x<this.w; x+=5) {
				if(x % 50 ==0) {
					gl.glLineWidth(3.0f);
				} else {
					gl.glLineWidth(1.0f);
				}
				double oglx = ProjectorTransforms.openGlView_left + (x*ProjectorTransforms.openGlView_width/w);
				gl.glBegin(gl.GL_LINES);
				gl.glVertex4d(oglx,ProjectorTransforms.openGlView_bottom,ProjectorTransforms.openGlView_z,1.0);
				gl.glVertex4d(oglx,ProjectorTransforms.openGlView_bottom+ProjectorTransforms.openGlView_height,ProjectorTransforms.openGlView_z,1.0);
				gl.glEnd();
			}
			
			for(int y=0; y<this.h; y+=5) {
				if(y % 50 ==0) {
					gl.glLineWidth(3.0f);
				} else {
					gl.glLineWidth(1.0f);
				}
				double ogly = ProjectorTransforms.openGlView_bottom + (y*ProjectorTransforms.openGlView_height/h);
				gl.glBegin(gl.GL_LINES);
				gl.glVertex4d(ProjectorTransforms.openGlView_left,ogly,ProjectorTransforms.openGlView_z,1.0);
				gl.glVertex4d(ProjectorTransforms.openGlView_left+ProjectorTransforms.openGlView_width,ogly,ProjectorTransforms.openGlView_z,1.0);
				gl.glEnd();			
			}
			
			JOGLHelper.oglThrowExceptionIfError(gl, glu);
				
		}
		
		public void displayChanged(GLAutoDrawable drawable,
				boolean modeChanged,
				boolean deviceChanged)
		{
		}
		
	}


	public static Matrix[] getmWOGLcalibPointsClockwise() {
		//old 4 point code: return getmWOGLcornersClockwise();
		// 9 point code
		Matrix[] mWOGLcornersClockwise = new Matrix[9];
		double l1=ProjectorTransforms.openGlView_left+ProjectorTransforms.openGlView_width/8.0;
		double l2=l1+ProjectorTransforms.openGlView_width*3.0/8.0;
		double l3=l2+ProjectorTransforms.openGlView_width*3.0/8.0;
		double h1=ProjectorTransforms.openGlView_bottom+ProjectorTransforms.openGlView_height/8.0;
		double h2=h1+ProjectorTransforms.openGlView_height*3.0/8.0;
		double h3=h2+ProjectorTransforms.openGlView_height*3.0/8.0;
		mWOGLcornersClockwise[0] = JOGLHelper.getMFromD(new double[] {l1, h1, 1 });
		mWOGLcornersClockwise[1] = JOGLHelper.getMFromD(new double[] {l2, h1, 1 });
		mWOGLcornersClockwise[2] = JOGLHelper.getMFromD(new double[] {l3, h1, 1 });
		mWOGLcornersClockwise[3] = JOGLHelper.getMFromD(new double[] {l1, h2, 1 });
		mWOGLcornersClockwise[4] = JOGLHelper.getMFromD(new double[] {l2, h2, 1 });
		mWOGLcornersClockwise[5] = JOGLHelper.getMFromD(new double[] {l3, h2, 1 });
		mWOGLcornersClockwise[6] = JOGLHelper.getMFromD(new double[] {l1, h3, 1 });
		mWOGLcornersClockwise[7] = JOGLHelper.getMFromD(new double[] {l2, h3, 1 });
		mWOGLcornersClockwise[8] = JOGLHelper.getMFromD(new double[] {l3, h3, 1 });
		return mWOGLcornersClockwise;
	}
	
	
}
