/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.input;


import java.util.Properties;
import java.util.logging.Logger;

import Jama.Matrix;

/**
 * Simulator input just simulates pointer drawing circles with no buttons.
 * 
 * @author pjt40
 *
 */
public class Sim extends PointInputDevice {

	private static final Logger logger = Logger.getLogger("t3.hrd.input");
	private long timer=0;
	private double theta=0.0;
	
	public Sim(int clientId, int personId, Matrix mINPUTtoDESK, boolean accurate, Properties p, String prefix) throws InputDeviceException { 
		super(clientId, 1, personId, mINPUTtoDESK);
	}
	public boolean updateState()  throws InputDeviceException{
		logger.fine("Updated state");
		if(System.currentTimeMillis()-timer>50) {
			theta+=0.10;
			if(theta>Math.PI*2.0) { theta-=Math.PI*2.0; }
			this.state.positionAndButtonsKnown = true;
			this.state.DESKx = Math.sin(theta)*50.0+500.0;
			this.state.DESKy = Math.cos(theta)*10.0+100.0;
			this.state.buttons = 0;
			this.timer=System.currentTimeMillis();
			return true;
		} else {
			return false;
		}
	}
	public void close()  throws InputDeviceException{
		
	}
	
	

}
