/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.input;

import t3.hrd.state.JOGLHelper;
import Jama.Matrix;



/**
 * Abstract class representing a point input device, ie one that
 * generates 2D coordinates. It stores its state in its state object.
 * Calls to updateState must update the state object and return true iff the
 * state was updated.
 * 
 * @author pjt40
 *
 */
public abstract class PointInputDevice {
	public final PointInputDeviceState state;
    public final Matrix mINPUTtoDESK;
	public PointInputDevice(int clientId, int pointInputType, int personId, Matrix mINPUTtoDESK) {
		this.state = new PointInputDeviceState(clientId, pointInputType, personId);
        this.mINPUTtoDESK = mINPUTtoDESK;
	}
    public void setStateDESKcoordsFromINPUTcoords(double dINPUTx, double dINPUTy) {
        Matrix mINPUT = JOGLHelper.getMFromD(dINPUTx, dINPUTy, 1.0);
        Matrix mDESK = mINPUTtoDESK.times(mINPUT);
        this.state.DESKx = mDESK.get(0,0)/mDESK.get(2,0);
        this.state.DESKy = mDESK.get(1,0)/mDESK.get(2,0);
    }
	public abstract boolean updateState() throws InputDeviceException;
	public abstract void close() throws InputDeviceException;
}
