/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;

import javax.swing.JPanel;

import t3.hrd.state.JOGLHelper;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSLimiter;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.portfolios.swing.SwingFramePortfolio;


public class InteractiveUpdateSwing extends AbstractPTest {
    public InteractiveUpdateSwing() {}

    SwingFramePortfolio p;
    AnimatorThread pat;
    
    public void setupPTest() throws Throwable {
        p = new SwingFramePortfolio(
                ps,
                ps.rootPortfolio,
                c,
                pto.tilew,
                pto.tileh, pto.tflags,  pto.pflags
            );
        p.getFrame().add(new MyComponent());
        this.setPortSizePosnVisAndCHints(p);
    }
    
    public void finishPTest() throws Throwable {
        p.setVisibleWhenParentVisible(false);
        p.destroyThisAndAllDescendants();
    }

	
	
public class MyComponent extends JPanel {
        
        public MyComponent() {
            super();
            this.addMouseMotionListener(
            new MouseMotionListener() {
                public void mouseDragged(MouseEvent e) {
                    MyComponent.this.setXandYandrepaint(e.getX(), e.getY());
                }
                public void mouseMoved(MouseEvent e) {   }
            }
            );
            
        }
        
        int x=0; int y=0;
        public void paintComponent(Graphics g) {
            paintTestTile(g,x,y);             
        }
        
        public void setXandYandrepaint(int x, int y) {
            this.x=x;
            this.y=y;
            this.repaint();
        }
        
    }
    	 

	
}
