/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3examples.twopagedocdemo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

import com.sun.opengl.util.Animator;



import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.state.Tile;
import t3.portfolios.PointInputDevice;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorJobsThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;

public class TwoPageOpenDoc extends Portfolio {
	
	private final double darken;

	private final LinkedList<Portfolio> pagesInOrder;
	private final ThumbnailsPortfolio thumbnailsPortfolio;
	private final ThumbnailMarkerPortfolio thumbnailMarkerPortfolio;
	//private final SameViewPortfolio largerThumbPortfolio;
	private final LinkedList<ThumbnailPortfolio> pageThumbnailsInOrder;
	private final double pagePORTw, pagePORTh;
	private final int thumbW, thumbH;
	private final double thumbsPORTw, thumbsPORTh;
	// page numbers begin at 0
	private int curRightHandPage;
	private int curLeftHandPage;
	private boolean curInThumbMode;
	private final LinkedList<PageEdgePortfolio> edgesLeftBackToFront, edgesRightBackToFront;

	private static final double betweenSpacing = 5;
	private static final double withinSpacing = 2;
	private static final double backgroundSpacing = 5.0;
	private static final double PORTcentreGap=5.0;
	private static final double PORTedgeHGap=2.0;
	private static final double PORTedgeVGap=2.0;
	
	private double pageThumbPORTw, pageThumbPORTh, thumbMarkerPORTw, thumbMarkerPORTh;
	private final LinkedList<ScaRotTraTransformImmutableUniformScale> thumbIdealPosns;
	private final LinkedList<ScaRotTraTransformImmutableUniformScale> thumbMarkerIdealPosns;
	private boolean addedAllChildren;
	
	public TwoPageOpenDoc(
		PortfolioServer portfolioServer, Portfolio parent, PortfolioCommonBehaviour commonBehaviour,
		double pagePORTw, double pagePORTh, int nEdges,
		int thumbW, int thumbH, double thumbsPORTw, double thumbsPORTh,
        double darken
	) {
		super(false, portfolioServer, parent, commonBehaviour, true, 1, 1, 0, 0);
        this.darken = darken;
		this.pagePORTw = pagePORTw;
		this.pagePORTh = pagePORTh;
		this.thumbH = thumbH;
		this.thumbW = thumbW;
		this.thumbsPORTw = thumbsPORTw;
		this.thumbsPORTh = thumbsPORTh;
		
		this.setTileWidthAndHeightInPORT(this.pagePORTw*2.0+this.PORTcentreGap+backgroundSpacing*2.0,this.pagePORTh+backgroundSpacing*2.0);
				
		this.pagesInOrder = new LinkedList<Portfolio>();
		this.pageThumbnailsInOrder = new LinkedList<ThumbnailPortfolio>(); 
		this.curLeftHandPage = -1;
		this.curRightHandPage = -1;
		this.curInThumbMode = false;
		
		this.edgesLeftBackToFront = new LinkedList<PageEdgePortfolio>();
		this.edgesRightBackToFront = new LinkedList<PageEdgePortfolio>();
		this.thumbnailsPortfolio = new ThumbnailsPortfolio(this);
		this.thumbnailMarkerPortfolio = new ThumbnailMarkerPortfolio(this.thumbnailsPortfolio, new Color(255,0,(int)(255*darken),64));
		
		
		//this.largerThumbPortfolio = new SameViewPortfolio(this.thumbnailsPortfolio, this.thumbW, this.thumbH); 
		for(int i=0; i<nEdges; i++) {
			int g = (int)((255-(nEdges-i)*16)*darken);
			this.edgesLeftBackToFront.add( new PageEdgePortfolio(this, new Color(g,g,g)) );
			this.edgesRightBackToFront.add( new PageEdgePortfolio(this, new Color(g,g,g)) );
		}		
		this.addedAllChildren = false;
		this.thumbIdealPosns = new LinkedList<ScaRotTraTransformImmutableUniformScale>();
		this.thumbMarkerIdealPosns = new LinkedList<ScaRotTraTransformImmutableUniformScale>();
	}
	
	public void setChildIsPage(Portfolio page) {
		assert this.childrenTopToBottomReadOnly.contains(page);
		this.pagesInOrder.add(page);	
		page.setTileWidthAndHeightInPORT(this.pagePORTw, this.pagePORTh);
		ThumbnailPortfolio t = new ThumbnailPortfolio(this.thumbnailsPortfolio, page, this.thumbW, this.thumbH);
		t.setVisibleWhenParentVisible(true);
		this.pageThumbnailsInOrder.add( t );
	}
	
	
	
	
	public void addedAllChildren() {
		
		/*
		 * Set thumnail ideal posns, marker ideal posns and also set
		 * tile width and heigh in port for all thumbnails and for marker
		 */
		
		assert !this.addedAllChildren;
		assert this.pagesInOrder.size()>0;
		
		this.curLeftHandPage = -1;
		this.curRightHandPage = 0;
		
		//	calculate ideal width
		int nTwoPages = (this.pagesInOrder.size()/2)+1;
		double twoPageThumbPORTidealArea = this.thumbsPORTh*this.thumbsPORTw/nTwoPages;
		double twoPageApproxAspectRatio = 2.0*this.pagePORTw/this.pagePORTh;
		double twoPageThumbPORTidealWidth = Math.sqrt( twoPageThumbPORTidealArea * twoPageApproxAspectRatio);
		
		int nTwoPageThumbsHoriz = (int)(Math.ceil(this.thumbsPORTw/twoPageThumbPORTidealWidth));
		
		double twoPageThumbPORTrealWidth = this.thumbsPORTw/nTwoPageThumbsHoriz;
		this.pageThumbPORTw = (twoPageThumbPORTrealWidth-betweenSpacing-withinSpacing)/2.0;
		this.pageThumbPORTh = pageThumbPORTw * this.pagePORTh/this.pagePORTw;
		this.thumbMarkerPORTw = (pageThumbPORTw*2.0+withinSpacing)+betweenSpacing/2.0;
		this.thumbMarkerPORTh = pageThumbPORTh+betweenSpacing/2.0;
		
		this.thumbnailMarkerPortfolio.setTileWidthAndHeightInPORT(this.thumbMarkerPORTw, this.thumbMarkerPORTh);
		
		double curPORTy = this.thumbsPORTh/2.0-pageThumbPORTh/2.0;
		ListIterator<ThumbnailPortfolio> l = this.pageThumbnailsInOrder.listIterator();
		while(l.hasNext()) {
			for(int i = 0; i<nTwoPageThumbsHoriz; i++) {
				boolean first = !l.hasPrevious();
				ThumbnailPortfolio left;
				ThumbnailPortfolio right;
				int leftPageN, rightPageN;
				if(l.hasNext()) {
					if(first) {
						left=null;
						leftPageN=-1;
						right=l.next();
						rightPageN=0;
					} else {
						leftPageN = l.nextIndex();
						left = l.next();
						if(l.hasNext()) {
							rightPageN = l.nextIndex();
							right = l.next();
						} else {
							rightPageN=-1;
							right = null;
						}
					}
				} else {
					left = null;
					right = null;
					leftPageN=-1;
					rightPageN=-1;
				}
				
				double markerTx = 
					-this.thumbsPORTw/2.0
					+ i*twoPageThumbPORTrealWidth
					+ betweenSpacing/2.0
					+ pageThumbPORTw
					+ withinSpacing/2.0;
				ScaRotTraTransformImmutableUniformScale markerIdealPos = new ScaRotTraTransformImmutableUniformScale(1.0,0.0,markerTx,curPORTy);
				
				if(left!=null) {
					double tx = -this.thumbsPORTw/2.0
						+ i*twoPageThumbPORTrealWidth
						+ betweenSpacing/2.0
						+ pageThumbPORTw
						- 0.5*pageThumbPORTw; 
					left.setTileWidthAndHeightInPORT(this.pageThumbPORTw, this.pageThumbPORTh);
					this.thumbIdealPosns.add(new ScaRotTraTransformImmutableUniformScale(1.0,0.0,tx,curPORTy));
					this.thumbMarkerIdealPosns.add(markerIdealPos);
					left.setPORTtoPPORT(new ScaRotTraTransformImmutableUniformScale(1.0,0.0,tx,curPORTy));
				} else {
					// nothing
				}
				if(right!=null) {
					double tx = 
						-this.thumbsPORTw/2.0
						+ i*twoPageThumbPORTrealWidth
						+ betweenSpacing/2.0
						+ pageThumbPORTw
						+ withinSpacing
						+ pageThumbPORTw*0.5 
						; 
					right.setTileWidthAndHeightInPORT(this.pageThumbPORTw, this.pageThumbPORTh);
					this.thumbIdealPosns.add(new ScaRotTraTransformImmutableUniformScale(1.0,0.0,tx,curPORTy));
					this.thumbMarkerIdealPosns.add(markerIdealPos);
					right.setPORTtoPPORT(new ScaRotTraTransformImmutableUniformScale(1.0,0.0,tx,curPORTy));
				} else {
					// nothing
				}			
			}
			curPORTy -= pageThumbPORTh+betweenSpacing;
		}
		
		this.addedAllChildren = true;
	}
	
	
	
	
	public static boolean isLeftPage(int pageInd) {
		assert pageInd!=-1;
		return (pageInd % 2 != 0);
	}
	
	public static int getLeftPageIndToShow(int pageInd) {
		assert pageInd!=-1;
		if(pageInd % 2 == 0) {
			return (pageInd == 0) ? -1 : pageInd-1;
		} else {
			return pageInd;
		}
	}
	
	public static int getRightPageIndToShow(int pageInd, int nPages) {
		assert pageInd!=-1;
		if(pageInd % 2 == 0) {
			return pageInd;
		} else {
			return (pageInd == nPages-1) ? -1 : pageInd+1;
		}
	}
	
	public static boolean isThereANextPageAfterThisDoublePage(int pageInd, int nPages) {
		assert pageInd!=-1;
		return (getRightPageIndToShow(pageInd, nPages) < nPages-1);
	}
	
	public static boolean isThereAPrevPageBeforeThisDoublePage(int pageInd) {
		assert pageInd!=-1;
		return (getLeftPageIndToShow(pageInd) >0);
	}
	
	
	
	public void turnToPage(int n) {
		assert n>=0 && n<=this.pagesInOrder.size()-1;	
		this.curInThumbMode = false;
		if(n % 2 == 0) {
			curRightHandPage = n;
			curLeftHandPage = (n == 0) ? -1 : n-1;
		} else {
			curLeftHandPage = n;
			curRightHandPage = (n == this.pagesInOrder.size()-1) ? -1 : n+1;
		}
		this.updatePagesAffAndVis();
	}
	
	public boolean isThereANextPage() {
		return 
			(curRightHandPage != -1) 
			&& (curRightHandPage < this.pagesInOrder.size()-1);
	}
	
	public boolean isThereAPrevPage() {
		return (curLeftHandPage > 0);		
	}
	
	public void turnToNextPage() {
		if(this.isThereANextPage()) {
			turnToPage(curRightHandPage+1);
		}
	}
	
	public void turnToPrevPage() {
		if(this.isThereAPrevPage()) {
			turnToPage(curLeftHandPage-1);
		}
	}
	
	public void enterThumbnailMode() {
		this.curInThumbMode = true;
		this.updatePagesAffAndVis();
		ScaRotTraTransformImmutableUniformScale fin =  this.thumbnailMarkerPortfolio.gettPORTtoPPORT();
		this.thumbnailMarkerPortfolio.setPORTtoPPORT(
				new ScaRotTraTransformImmutableUniformScale((2.0*this.pagePORTw+this.PORTcentreGap)/this.thumbnailMarkerPortfolio.getTileWidthInPORT(),0.0,0.0,0.0)
			);
				
		LinkedList<AnimatorJobsThread.AnimationJob> ajs = new LinkedList<AnimatorJobsThread.AnimationJob>();
		ajs.add(
			new AnimatorJobsThread.AnimationJob(
				this.thumbnailMarkerPortfolio,
				fin
			)
		);
		new AnimatorJobsThread(30, this.portfolioServer, ajs,300,new Runnable() {public void run() {}} ).start();
	}
	
	
	public void exitThumbnailMode(ThumbnailPortfolio t) {
		this.turnToPage(this.pageThumbnailsInOrder.indexOf(t));
	}
	
	public void exitThumbnailModeClickedCurrent() {
		this.turnToPage((this.curLeftHandPage != -1) ? this.curLeftHandPage : this.curRightHandPage);
	}
	
	
	private void updatePagesAffAndVis() {
		if(this.curInThumbMode) {
			
			for(Portfolio page: this.pagesInOrder) {
				page.setVisibleWhenParentVisible(false);
			}
			for(PageEdgePortfolio edge: this.edgesLeftBackToFront) {
				edge.setVisibleWhenParentVisible(false);
			}
			for(PageEdgePortfolio edge: this.edgesRightBackToFront) {
				edge.setVisibleWhenParentVisible(false);
			}
			this.thumbnailsPortfolio.bringChildToFront(this.thumbnailMarkerPortfolio);
			
			int curMarkedPage = (this.curLeftHandPage != -1) ? this.curLeftHandPage : this.curRightHandPage;		
			
			this.thumbnailMarkerPortfolio.setPORTtoPPORT(this.thumbMarkerIdealPosns.get(curMarkedPage));
			
			this.thumbnailMarkerPortfolio.setVisibleWhenParentVisible(true);			
			this.thumbnailsPortfolio.setVisibleWhenParentVisible(true);				
			
		} else {
			this.thumbnailsPortfolio.setVisibleWhenParentVisible(false);
			
			int i=0;
			for(Portfolio page: this.pagesInOrder) {
				if(i==curLeftHandPage || i==curRightHandPage) {
					double tx = 
						(i==curLeftHandPage ? -1.0 : 1.0)
						* (	this.PORTcentreGap/2.0 + this.pagePORTw/2.0 );
					page.setPORTtoPPORT(
						new ScaRotTraTransformImmutableUniformScale(
							1.0,0.0,tx,0.0)
							);
					page.setVisibleWhenParentVisible(true);
				} else {
					page.setVisibleWhenParentVisible(false);
				}
				i++;
			}
			
			int numPageEdgesLeft = curLeftHandPage==-1 ? 0 : ((curLeftHandPage-1)/2);
			int numPageEdgesRight = curRightHandPage==-1 ? 0 : ((this.pagesInOrder.size()-curRightHandPage-1)/2);
			
			i=this.edgesLeftBackToFront.size();
			for(PageEdgePortfolio edge: this.edgesLeftBackToFront) {
				if(numPageEdgesLeft>=i) {
					edge.setTileWidthAndHeightInPORT(this.pagePORTw, this.pagePORTh);
					double tx = -(this.PORTcentreGap/2.0 + this.pagePORTw/2.0 +i*this.PORTedgeHGap);
					double ty = -i*this.PORTedgeVGap;
					edge.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,0.0, tx, ty ));
					edge.setVisibleWhenParentVisible(true);
				} else {
					edge.setVisibleWhenParentVisible(false);
				}
				i--;
			}
			
			i=this.edgesRightBackToFront.size();
			for(PageEdgePortfolio edge: this.edgesRightBackToFront) {
				if(numPageEdgesRight>=i) {
					edge.setTileWidthAndHeightInPORT(this.pagePORTw, this.pagePORTh);
					double tx = (this.PORTcentreGap/2.0 + this.pagePORTw/2.0 +i*this.PORTedgeHGap);
					double ty = -i*this.PORTedgeVGap;
					edge.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,0.0, tx, ty ));
					edge.setVisibleWhenParentVisible(true);
				} else {
					edge.setVisibleWhenParentVisible(false);
				}
				i--;
			}
		}
		
	}
	
	
	
	
	
	

	@Override
	protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		// TODO Auto-generated method stub
		
	}

	@Override
	protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
		g.setColor(new Color(0,0,(int)(255*darken)));
		g.fillRect(r.x,r.y,r.width,r.height);
		
	}
	
	
	private static class PageEdgePortfolio extends Portfolio {
		private Color c;
		PageEdgePortfolio(TwoPageOpenDoc parent, Color c) {
			super(false,parent.portfolioServer, parent, new CannotDragWRTParent(), true, 1,1,0, 0);
			this.c =c ;
		}
		
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		}

		@Override
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			return false;
		}

		@Override
		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {			
		}

		@Override
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
			g.setColor(c);
			g.fillRect(r.x,r.y,r.width,r.height);
		}		
	}
	
	private static class ThumbnailMarkerPortfolio extends Portfolio {
		private Color c;
		ThumbnailMarkerPortfolio(ThumbnailsPortfolio parent, Color c) {
			super(false,parent.portfolioServer, parent, new CannotDragWRTParent(), true, 1,1,Tile.FLAG_TEXTUREALWAYSRESIDENTEVENWHENTILEINVISIBLE, 0);
			this.c =c ;
		}
		
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		}

		@Override
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			if(	e.eventType==e.EVENT_PID_CLICK && e.pidButton==0 && e.pointInputDevice.pointInputDeviceType==0) {
				((TwoPageOpenDoc)(this.getParent().getParent())).exitThumbnailModeClickedCurrent();
				return true;
			} else {
				return false;
			}
		}

		@Override
		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {			
		}

		@Override
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
			g.setColor(c);
			g.fillRect(r.x,r.y,r.width,r.height);
		}		
	}
	
	
	/*
	private static class SameViewPortfolio extends Portfolio {
		private Portfolio sameViewOf;
		
		SameViewPortfolio(ThumbnailsPortfolio parent, int w, int h) {
			super(
					false,
					parent.portfolioServer, 
					parent, 
					new CannotDragWRTParent(), 
					true, 
					w,
					h,
					0, false);
			this.sameViewOf = null;
		}
		
		public void setSameViewOf(Portfolio sameViewOf) {
			assert this.getTileWidthInTILE() == sameViewOf.getTileWidthInTILE();
			assert this.getTileHeightInTILE() == sameViewOf.getTileHeightInTILE();
			this.sameViewOf = sameViewOf;
			this.triggerRepaintTileByCopyingFromOtherPortfoliosTile(
				0,0,0,0,
				this.getTileWidthInTILE(),
				this.getTileHeightInTILE(),
				sameViewOf
			);
		}
		
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {}
		
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {return false;}

		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {			
		}

		@Override
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
			if(this.sameViewOf!=null) {
				int ow = sameViewOf.getTileWidthInTILE();
				int oh = sameViewOf.getTileHeightInTILE();
				int nw = this.getTileWidthInTILE();
				int nh = this.getTileHeightInTILE();
				BufferedImage obi = sameViewOf.createCompatibleBufferedImage(ow, oh);
				sameViewOf.customRepaintTileForThisPortfolioNotChildren(new Rectangle(0,0,ow,oh), obi, obi.createGraphics());
				g.drawImage(obi,0,0,nw-1,nh-1,0,0,ow-1,oh-1,null);
			} else{
				// don't draw anything
			}
		}		
	}	*/
	
	
	
	private static class ThumbnailPortfolio extends Portfolio {
		private Portfolio thumbnailOf;
		
		ThumbnailPortfolio(ThumbnailsPortfolio parent, Portfolio thumbnailOf, int w, int h) {
			super(false,parent.portfolioServer, parent, new CannotDragWRTParent(), true, w,h,Tile.FLAG_TEXTUREALWAYSRESIDENTEVENWHENTILEINVISIBLE, 0);
			assert thumbnailOf.hasTile();
			this.thumbnailOf = thumbnailOf;
		}
		
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		}

		@Override
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			if(	e.eventType==e.EVENT_PID_CLICK && e.pidButton==0 && e.pointInputDevice.pointInputDeviceType==0) {
				((TwoPageOpenDoc)(this.getParent().getParent())).exitThumbnailMode(this);
				return true;
			} else {
				return false;
			}
		}

		@Override
		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {			
		}

		@Override
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
			int ow = thumbnailOf.getTileWidthInTILE();
			int oh = thumbnailOf.getTileHeightInTILE();
			int nw = this.getTileWidthInTILE();
			int nh = this.getTileHeightInTILE();
			BufferedImage obi = thumbnailOf.createCompatibleBufferedImage(ow, oh);
			thumbnailOf.customRepaintTileForThisPortfolioNotChildren(new Rectangle(0,0,ow,oh), obi, obi.createGraphics());
			g.drawImage(obi,0,0,nw-1,nh-1,0,0,ow-1,oh-1,null);
		}		
	}
	
	private static class ThumbnailsPortfolio extends Portfolio {
		ThumbnailsPortfolio(TwoPageOpenDoc parent) {
			super(false,parent.portfolioServer, parent, new CannotDragWRTParent(), false, 0, 0, 0, 0);
		}
		
		protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
		}

		@Override
		protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
			return false;
		}

		@Override
		protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {			
		}

		@Override
		public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
		}		
	}

}
