/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.server;


import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.logging.Logger;

import t3.hrd.state.Cursor;
import t3.hrd.state.Link;
import t3.hrd.state.OrderedElement;
import t3.hrd.state.ScaRotTraTransformImmutable;
import t3.hrd.state.StateListener;
import t3.hrd.state.Tile;
import t3.hrd.state.UnwarpedRect;
import t3.hrd.state.Cursor.CursorShapePolygons;
import t3.remotehrd.protocol.OpCreateCursor;
import t3.remotehrd.protocol.OpCreateLink;
import t3.remotehrd.protocol.OpCreateTile;
import t3.remotehrd.protocol.OpCreateUnwarpedRect;
import t3.remotehrd.protocol.OpCursorPos;
import t3.remotehrd.protocol.OpCursorShape;
import t3.remotehrd.protocol.OpDestroyCursor;
import t3.remotehrd.protocol.OpDestroyLink;
import t3.remotehrd.protocol.OpDestroyTile;
import t3.remotehrd.protocol.OpDestroyUnwarpedRects;
import t3.remotehrd.protocol.OpLogMessage;
import t3.remotehrd.protocol.OpReorderTilesAndLinks;
import t3.remotehrd.protocol.OpSetCursorOptions;
import t3.remotehrd.protocol.OpSetLinkAff;
import t3.remotehrd.protocol.OpSetTileAff;
import t3.remotehrd.protocol.OpSetTileVisibility;
import t3.remotehrd.protocol.OpUpdateTileContents;
import t3.remotehrd.protocol.OpUpdateTileContentsByCopyingFromOtherTile;

class StateListenerForServer implements StateListener {
		
	/* we don't need synchronization here
	 * because everything gets turned all the remoteHRDserver
	 * calls and the remoteHRDserver calls are thread safe
	 */
	
	RemoteHRDServer remoteHRDserver;

	private static final Logger logger = Logger.getLogger("t3.remotehrd.server");
	
	public StateListenerForServer(RemoteHRDServer remoteHRDserver) {
		super();
		this.remoteHRDserver = remoteHRDserver;
	}
	
    public void callback_opLogMessage(String message) {
        remoteHRDserver.addToSendQueue(new OpLogMessage(message));
    }
    
	public void callback_createdUnwarpedRect(Tile tile,UnwarpedRect r) {
		remoteHRDserver.addToSendQueue(new OpCreateUnwarpedRect(tile.elementId,r));		
	}
	/*public void callback_destroyedUnwarpedRect(Tile tile,Rectangle r) {
		remoteHRDserver.addToSendQueue(new OpDestroyUnwarpedRect(tile.elementId,r));	
	}*/
	public void callback_destroyedUnwarpedRectsIntersecting(Tile tile,Rectangle r) {
		remoteHRDserver.addToSendQueue(new OpDestroyUnwarpedRects(tile.elementId,r));			
		
	}
	
	public void callback_updatedTileAff(Tile tile, double DESKcentreX, double DESKcentreY, double DESKwidth, double DESKheight, double thetaClockwise)  {
		// toopt don't bother for tiles that aren't visible!
		remoteHRDserver.addToSendQueue(new OpSetTileAff(tile.elementId, DESKcentreX, DESKcentreY, DESKwidth, DESKheight, thetaClockwise));
	}
	public void callback_updatedTileVisibility(Tile tile, boolean v) {
		remoteHRDserver.addToSendQueue(new OpSetTileVisibility(tile.elementId, v));		
	}
	public void callback_updatedTileContents(Tile tile, int x, int y, BufferedImage i, int compressionHint) {
		remoteHRDserver.addToSendQueue(
				new OpUpdateTileContents(
					tile.elementId, 
					x,
					y,
					i,
					compressionHint
				)
			);		
	}
	
	public void callback_updatedTileContentsByCopyingFromOtherTile(Tile tile, int sx, int sy, int dx, int dy, int w, int h, Tile source) {
		remoteHRDserver.addToSendQueue(
				new OpUpdateTileContentsByCopyingFromOtherTile(
					tile.elementId,
					sx,
					sy,
					dx,
					dy,
					w,
					h,
					source.elementId
				)
			);	
	}
	
	public void callback_createdTile(Tile tile, int w, int h, int flags) {
		remoteHRDserver.addToSendQueue(new OpCreateTile(tile.elementId, w, h, flags));
		
	}
	public void callback_destroyedTile(Tile tile)  {
		remoteHRDserver.addToSendQueue(new OpDestroyTile(tile.elementId));
		
	}
	public void callback_changedTilesAndLinksOrder(List<OrderedElement> elsInOrder) {
		int[] elOrderByElId = new int[elsInOrder.size()];
		int i=0;
		for(OrderedElement t: elsInOrder) {
			elOrderByElId[i++] = t.elementId;
		}
		remoteHRDserver.addToSendQueue(new OpReorderTilesAndLinks(elOrderByElId));
	}


	public void callback_createdCursor(Cursor c) {
		remoteHRDserver.addToSendQueue(new OpCreateCursor(c.getCursorId()));
	}
	
	public void callback_destroyedCursor(Cursor c) {
		remoteHRDserver.addToSendQueue(new OpDestroyCursor(c.getCursorId()));
	}
	
	public void callback_updatedCursorOptions(Cursor c) {
		remoteHRDserver.addToSendQueue(new OpSetCursorOptions(c.getCursorId(),c.getColor(),c.getDisplayType()));
	}
	
	public void callback_cursorPos(Cursor c, double DESKx, double DESKy, boolean visible) {
		remoteHRDserver.addToSendQueue(new OpCursorPos(c.getCursorId(), DESKx, DESKy, visible));
	}
	
	public void callback_cursorShape(Cursor c, CursorShapePolygons polygonsForShapeCursor) {
        remoteHRDserver.addToSendQueue(new OpCursorShape(c.getCursorId(), polygonsForShapeCursor));
	}

	public void callback_repaintUnbackedTile(Tile tile, Rectangle r, BufferedImage update, Graphics2D g) {
		remoteHRDserver.callBacks.remoteServerCallBack_repaintUnbackedTile(tile, r, update, g);
	}

	public void callback_createdLink(Link l, int displayType, Color c, ScaRotTraTransformImmutable tUniformRectToDESKrectA, ScaRotTraTransformImmutable tUniformRectToDESKrectB) {
		remoteHRDserver.addToSendQueue(new OpCreateLink(l.elementId, displayType, c, tUniformRectToDESKrectA.getMatrix2dHomogReadOnly(), tUniformRectToDESKrectB.getMatrix2dHomogReadOnly())); 
	}

	public void callback_destroyedLink(Link l) {
		remoteHRDserver.addToSendQueue(new OpDestroyLink(l.elementId));		
	}

	public void callback_updatedLinkAff(Link l, ScaRotTraTransformImmutable tUniformRectToDESKrectA, ScaRotTraTransformImmutable tUniformRectToDESKrectB) {
		remoteHRDserver.addToSendQueue(new OpSetLinkAff(l.elementId, tUniformRectToDESKrectA.getMatrix2dHomogReadOnly(), tUniformRectToDESKrectB.getMatrix2dHomogReadOnly())); 		
	}
	
	

}
	
