/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.client;


import java.awt.event.MouseEvent;

import javax.media.opengl.GL;

import t3.hrd.input.KeyboardInput;
import t3.hrd.input.PointInputDeviceState;
import t3.hrd.renderer.Projector;

/**
 * Allows you to customise the RemoteHRD client behaviour by specifying callback methods.
 * 
 * @author pjt40
 *
 */
public interface RemoteHRDClientCallBacks {
	public void remoteClientCallBack_receivedMessageFromServer(Object msg);
	public void remoteClientCallBack_oncePerFrame();
	public void remoteClientCallBack_closingAfterWindowsClosed();
	public boolean remoteClientCallBack_keyboardInput(KeyboardInput k);
	public boolean remoteClientCallBack_pointInputDeviceStateChanged(PointInputDeviceState pids);
	public void remoteClientCallBack_mouseClicked(MouseEvent e, Projector p);
    public void remoteClientCallBack_mouseEntered(MouseEvent e, Projector p);
    public void remoteClientCallBack_mouseExited(MouseEvent e, Projector p);
    public void remoteClientCallBack_mousePressed(MouseEvent e, Projector p);
    public void remoteClientCallBack_mouseReleased(MouseEvent e, Projector p);
    public void remoteClientCallBack_mouseMoved(MouseEvent e, Projector p);
    public void remoteClientCallBack_mouseDragged(MouseEvent e, Projector p);
	public boolean remoteClientCallBack_needToRepaintOverlay(Projector p);
	public void remoteClientCallBack_oglPaintOverlay(GL gl, Projector p);
}
