/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.state;

import java.awt.Rectangle;
import java.io.Serializable;


/**
 * Represents an unwarped rectangle.
 * @author pjt40
 *
 */
public class UnwarpedRect implements Serializable {
	/**
     * 
     */
    private static final long serialVersionUID = 1064906393426420520L;
    public final Rectangle r;
	public final int backgroundARGB;
	public final boolean typeLineNotWord;
	public UnwarpedRect(Rectangle r, int backgroundARGB, boolean typeLineNotWord) {
		this.backgroundARGB = backgroundARGB;
		this.r = r;
		this.typeLineNotWord = typeLineNotWord;
	}
}
