/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.input;

import java.io.Serializable;

/**
 * Data structure representing a keyboard event.
 * @author pjt40
 *
 */
public class KeyboardInput implements Serializable {
	/**
     * 
     */
    private static final long serialVersionUID = 363421568635508139L;
    public int awtKeyCode; 
	public int awtKeyModifiers;
	public char awtKeyChar; 
	public int messageType;
	public int personId;
	public int clientId;
	
	public static int MESSAGE_TYPE_PRESSED=1, MESSAGE_TYPE_RELEASED=2, MESSAGE_TYPE_TYPED=3;

	public KeyboardInput(int clientId, int personId, char awtKeyChar, int awtKeyCode, int awtKeyModifiers, int messageType) {
		this.clientId = clientId;
		this.personId = personId;
		this.awtKeyChar = awtKeyChar;
		this.awtKeyCode = awtKeyCode;
		this.awtKeyModifiers = awtKeyModifiers;
		this.messageType = messageType;
	}
	
	public String toString() {
		return super.toString() + " clientId="+this.clientId+" personId="+this.personId+" type="+this.messageType+" awtKeyChar="+this.awtKeyChar+" awtKeyCode="+this.awtKeyCode;
	}
}
