
package t3examples;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.net.ServerSocket;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import net.java.dev.jspreadsheet.CellRange;
import net.java.dev.jspreadsheet.JSpreadsheet;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioLink;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.portfolios.swing.SwingFramePortfolio;

/*
 * This example uses a JSpreadsheet component.
 * 
 */
public class Example5 {

	
	public static PortfolioServer ps;
	
	public static void main(String[] args) throws Exception{
		
		// create a new server
		ps = new PortfolioServer(new ServerSocket(2000),new ServerSocket(2001), false);
		
		final double pxPerMM = 2.4;
		
		try {
		
			// common behaviour allows our portfolio to be dragged
			final PortfolioCommonBehaviour c = new RotateNTranslateWithTranslateOnlyRegion(
					new PointInputDeviceTypeAndButtonSet(
						new PointInputDeviceTypeAndButton(0,1)
					),
					0.3);
            
            SwingFramePortfolio.runLaterFromSwingThreadUsesPortfolios( ps, new Runnable() { public void run() { 
				
									
					final SwingFramePortfolio mySwingPortf = new SwingFramePortfolio(ps, ps.rootPortfolio, c,  300, 300, 0, 0);
					JPanel pane = new JPanel(new GridLayout(0, 1));
					pane.add(new JComboBox(new String[] { "Bird", "Cat", "Dog", "Rabbit", "Pig" }));
					pane.add(new JTextField("Test text field")); 
					pane.add(new JButton("Test button"));
					pane.add(new JRadioButton("Test radio"));
					pane.setBorder(BorderFactory.createEmptyBorder(
					                                30, //top
					                                30, //left
					                                10, //bottom
					                                30) //right
					                                );
					mySwingPortf.getFrame().add(pane);
					mySwingPortf.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
					mySwingPortf.setTileWidthAndHeightInPORT(mySwingPortf.getTileWidthInTILE()/pxPerMM,mySwingPortf.getTileHeightInTILE()/pxPerMM);
					mySwingPortf.setVisibleWhenParentVisible(true);
					
					final SwingFramePortfolio mySwingPortf2 = new SwingFramePortfolio(ps, ps.rootPortfolio, c,  300, 300, 0, 0);
					mySwingPortf2.getFrame().add(new JTextArea("Text1"));
					mySwingPortf2.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
					mySwingPortf2.setTileWidthAndHeightInPORT(mySwingPortf2.getTileWidthInTILE()/pxPerMM,mySwingPortf2.getTileHeightInTILE()/pxPerMM);
					mySwingPortf2.setVisibleWhenParentVisible(true);
					
					final SwingFramePortfolio mySwingPortf3 = new SwingFramePortfolio(ps, ps.rootPortfolio, c,  300, 300, 0, 0);
					mySwingPortf3.getFrame().add(new JTextArea("Text2"));
					mySwingPortf3.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
					mySwingPortf3.setTileWidthAndHeightInPORT(mySwingPortf3.getTileWidthInTILE()/pxPerMM,mySwingPortf3.getTileHeightInTILE()/pxPerMM);
					mySwingPortf3.setVisibleWhenParentVisible(true);
					
					JSpreadsheet mySpreadsheet = new JSpreadsheet(80, 80);
					boolean BIG = false;
					mySpreadsheet.setValueAt("1", 0, 0);
					mySpreadsheet.fill(new CellRange(1, 10, 0, 0), "=A1+1");
					mySpreadsheet.fill(new CellRange(0, 10, 1, 1), "=A1*A1");				
					final SwingFramePortfolio mySwingPortf4 = new SwingFramePortfolio(ps, ps.rootPortfolio, c, BIG? 3000 : 600, BIG? 1000: 600, 0, 0);
					mySwingPortf4.getFrame().setContentPane(mySpreadsheet); 
                    
					mySwingPortf4.setPORTtoPPORT( new ScaRotTraTransformImmutableUniformScale(1.0,1.0, 120,120) );
					mySwingPortf4.setTileWidthAndHeightInPORT(mySwingPortf4.getTileWidthInTILE()/pxPerMM,mySwingPortf4.getTileHeightInTILE()/pxPerMM);
					mySwingPortf4.setVisibleWhenParentVisible(true);
					
					new PortfolioLink(0, Color.GREEN, mySwingPortf, mySwingPortf4, new Rectangle2D.Double(10,10,10,10), new Rectangle2D.Double(10,10,10,10));
					new PortfolioLink(0, Color.BLUE, mySwingPortf, mySwingPortf4);
					
					
			}});
		} catch(Throwable e) {
			ps.fatalError(e);
		}
	}
	
	
}
