/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.remotehrd.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

import t3.hrd.util.ThingsPSTimer;

public class BandwidthMeasuringInputStream extends FilterInputStream {

    private ThingsPSTimer tpst;
    public BandwidthMeasuringInputStream(InputStream in) {
        super(in);
        this.tpst = new ThingsPSTimer("kBps = ", "", 100000000000L, 0.3, 2000, 8000, 0.001);
        assert !in.markSupported();
    }

    @Override
    public int read() throws IOException {
        // TODO Auto-generated method stub
        tpst.moreThings(1);
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        // TODO Auto-generated method stub
        int r= super.read(b, off, len);
        if(r>0) { tpst.moreThings(r); }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        // TODO Auto-generated method stub
        int r= super.read(b);
        if(r>0) { tpst.moreThings(r); }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        // TODO Auto-generated method stub
        long r= super.skip(n);
        if(r>0) { tpst.moreThings(r); }
        return r;
    }

    
    
    
    

}
