/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios.swing;

import java.awt.Component;
import java.awt.event.MouseEvent;

import t3.portfolios.PortfolioEvent;

/**
 * Represents an AWT mouse event caused by a portfolio PID event.
 * @author pjt40
 *
 */
public class SwingFramePortfolioMouseEvent extends MouseEvent {

	public final PortfolioEvent cause;
	
	SwingFramePortfolioMouseEvent(PortfolioEvent cause, Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button) {
		super(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
		this.cause = cause;
	}

	SwingFramePortfolioMouseEvent(PortfolioEvent cause, Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
		super(source, id, when, modifiers, x, y, clickCount, popupTrigger);
		this.cause = cause;
	}

}
