/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.portfolios.commonbehaviours;

import java.util.logging.Logger;

import t3.portfolios.PointInputDevice;
import t3.portfolios.Portfolio;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;

/**
 * This common behaviour does nothing and passes all events and notifications
 * on to the portfolio. See PortfolioServer for more information on the event model.
 * @author pjt40
 *
 */
public class CannotDragWRTParent implements PortfolioCommonBehaviour {
	private static final Logger logger = Logger.getLogger("t3.hrd.portfolios.commonbehaviours");
	
	public boolean customProcessEventForThisPortfolioNotChildren(Portfolio p,
			PortfolioEvent e, boolean bubbled) {
		return false;
	}

	public boolean customProcessFDOPevent(Portfolio p, PortfolioEvent e,
			double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
		return false;
	}

	public boolean customProcessEndOfFDOPmode(Portfolio p,
			PointInputDevice pid, int button) {
		return false;
	}

}
