/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.util;

import java.util.logging.Logger;

public class FPSTimer {
    private final String start;
    private final String end;
    private final double maxFPStoReport, deviation;
    private final long msBetweenChecksForDeviation;
    private final long msBetweenAlwaysReport;
    private long timeOfLastDevCheck = System.currentTimeMillis();
    private long timeOfLastReport = System.currentTimeMillis();
    private int nFramesSinceLastDevCheck = 0;
    private double fpsLastReported = 0;
    private static final Logger logger = Logger.getLogger("t3.hrd.util.FPSTimer");
    
    public FPSTimer(String start, String end, double maxFPStoReport, double deviation, long msBetweenChecksForDeviation, long msBetweenAlwaysReport) {
        this.start = start;
        this.end = end;
        this.maxFPStoReport = maxFPStoReport;
        this.deviation =deviation;
        this.msBetweenChecksForDeviation = msBetweenChecksForDeviation;
        this.msBetweenAlwaysReport = msBetweenAlwaysReport;
    }
    
    public void oneFrame() {
        this.nFramesSinceLastDevCheck++;
        long timeElapsedSinceLastDevCheck = System.currentTimeMillis()-this.timeOfLastDevCheck;
        if(timeElapsedSinceLastDevCheck>this.msBetweenChecksForDeviation) {
            double fps = (double)(nFramesSinceLastDevCheck)/(double)(timeElapsedSinceLastDevCheck)*1000.0;
            long timeSinceLastReport = System.currentTimeMillis()-this.timeOfLastReport;
            if(fps<maxFPStoReport && (timeSinceLastReport>this.msBetweenAlwaysReport || fps>this.fpsLastReported*(1.0+this.deviation) || fps<this.fpsLastReported*(1.0-this.deviation))) {
                this.fpsLastReported = fps;
                logger.info(""+start+ fps+end+" over "+(((double)timeSinceLastReport)/1000.0)+"s");
                this.timeOfLastReport = System.currentTimeMillis();
            }
            this.timeOfLastDevCheck = System.currentTimeMillis();
            this.nFramesSinceLastDevCheck = 0;
        } else {
            // DO NOTHING
        }   
    }
}
