/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.renderer;

class TextureOnProjector {
	
	final int textureName, w, h, extW, extH;
	final double fracRightX, fracTopY, fracLeftX, fracBottomY;
	
	public TextureOnProjector(int textureName, int w, int h, int extW, int extH) {
		this.textureName = textureName;
		this.w = w;
		this.h = h;
		this.extW = extW;
		this.extH = extH;
		this.fracRightX = getTextureXCoordFromTileXCoord(extW-1)/ (double)this.w;
		this.fracLeftX = getTextureXCoordFromTileXCoord(0) / (double)this.w;
		this.fracTopY = getTextureYCoordFromTileYCoord(extH-1) / (double)this.h;
		this.fracBottomY = getTextureYCoordFromTileYCoord(0) / (double)this.h;		
	}
	
		
	public int getTextureXCoordFromTileXCoord(int x) {
		return x;
	}
	
	public int getTextureYCoordFromTileYCoord(int y) {
		return y;
		//return extH-y-1;
	}
	

	public String toString() {
		return super.toString()+" textureName="+this.textureName+" w="+this.w+" h="+this.h;
	}
	
}
