/*
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3.hrd.renderer;


import java.awt.event.MouseEvent;

import javax.media.opengl.GL;

import t3.hrd.input.KeyboardInput;
import t3.hrd.input.PointInputDeviceState;
import t3.hrd.input.ShapeInputDeviceState;


/**
 * This interface allows you to provide callback methods that
 * are called by the HRDRenderer to allow you to customise its 
 * behaviour. 
 * 
 * The methods should be obvious from their names.
 *  
 * @author pjt40
 *
 */

public interface HRDRendererCallBacks {
	public void callback_oncePerFrame();
	public void callback_closingBeforeLastOGL();
	public void callback_closingAfterWindowsClosed();
	public void callback_mouseClicked(MouseEvent e, Projector p);
    public void callback_mouseEntered(MouseEvent e, Projector p);
    public void callback_mouseExited(MouseEvent e, Projector p);
    public void callback_mousePressed(MouseEvent e, Projector p);
    public void callback_mouseReleased(MouseEvent e, Projector p);
    public void callback_mouseMoved(MouseEvent e, Projector p);
    public void callback_mouseDragged(MouseEvent e, Projector p);
	public boolean callback_needToRepaintOverlay(Projector p);
	public void callback_oglPaintOverlay(GL gl, Projector p);
	public void callback_keyboardInput(KeyboardInput k, Object client);
	public void callback_pointInputDeviceStateChanged(PointInputDeviceState pids, Object client);
    public void callback_shapeInputDeviceStateChanged(ShapeInputDeviceState sids, Object client);
}
