/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;

import java.io.Serializable;

public class PTestOptions implements Serializable {
    public final Class ptest;
    
    public final int tilew, tileh;
    public final double deskw, deskh;
    public final int spanning;
    public final double targetfps;
    public final boolean rle;
    public final int ntiles;
    public final int tflags, pflags;
    public PTestOptions(Class ptest, int tilesize, double desksize, double targetfps, int ntiles, boolean rle, int spanning, int pflags, int tflags) {
        // TODO Auto-generated constructor stub
        this.deskh = desksize;
        this.deskw = desksize;
        this.ntiles = ntiles;
        this.ptest = ptest;
        this.rle = rle;
        this.spanning = spanning;
        this.targetfps = targetfps;
        this.tileh = tilesize;
        this.tilew = tilesize;
        this.pflags = pflags;
        this.tflags = tflags;
    }
    public String toString() {
        return "PTO ptest="+ptest.getSimpleName()+" tilew="+tilew+" deskw="+deskw+" deskh="+deskh+" targetfps="+targetfps+" ntiles="+ntiles
        +" rle="+ rle+" spanning="+spanning+" pflags="+pflags+" tflags="+tflags;
    }
    
}
