/**
 * Copyright (c) 2008 Philip Tuddenham
 * 
 * This work is licenced under the 
 * Creative Commons Attribution-NonCommercial-ShareAlike 2.5 License. 
 * To view a copy of this licence, visit 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ or send a letter to 
 * Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.
 */
package t3ptests;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.ServerSocket;

import t3.hrd.state.JOGLHelper;
import t3.hrd.state.ScaRotTraTransformImmutableUniformScale;
import t3.hrd.util.FPSLimiter;
import t3.hrd.util.FPSTimer;
import t3.portfolios.PointInputDevice;
import t3.portfolios.PointInputDeviceTypeAndButton;
import t3.portfolios.PointInputDeviceTypeAndButtonSet;
import t3.portfolios.Portfolio;
import t3.portfolios.AnimatorThread;
import t3.portfolios.PortfolioCommonBehaviour;
import t3.portfolios.PortfolioEvent;
import t3.portfolios.PortfolioServer;
import t3.portfolios.commonbehaviours.CannotDragWRTParent;
import t3.portfolios.commonbehaviours.RotateNTranslate;
import t3.portfolios.commonbehaviours.RotateNTranslateWithTranslateOnlyRegion;
import t3.remotehrd.protocol.OpUpdateTileContents;


public class InteractiveMovement extends AbstractPTest {
    public InteractiveMovement() {}
    
    private PlainPortfForTest pts[][];

    
    public void setupPTest() throws Throwable {
        final double thetaIncrement = 0.5*2*Math.PI/pto.targetfps;
        
        final int nRows = (int)Math.ceil(Math.sqrt(pto.ntiles)*TABLEH/TABLEW);
        final int nCols = (int)Math.ceil(pto.ntiles/(double)nRows);
        
        pts = new PlainPortfForTest[nRows][nCols];
        Portfolio s = new Portfolio(false,ps, ps.rootPortfolio, new RotateNTranslate(new PointInputDeviceTypeAndButton(0,1)), false, 0,0,0,0) {

            @Override
            protected void customProcessEndOfFDOPmode(PointInputDevice pid, int button) {
                // TODO Auto-generated method stub
                
            }

            @Override
            protected boolean customProcessEventForThisPortfolioNotChildren(PortfolioEvent e, boolean bubbled) {
                // TODO Auto-generated method stub
                return false;
            }

            @Override
            protected void customProcessFDOPevent(PortfolioEvent e, double PORTxWhenEnteredFDOPmode, double PORTyWhenEnteredFDOPmode) {
                // TODO Auto-generated method stub
                
            }

            @Override
            public void customRepaintTileForThisPortfolioNotChildren(Rectangle r, BufferedImage update, Graphics2D g) {
                // TODO Auto-generated method stub
                
            }
            
        };
        s.setVisibleWhenParentVisible(true);
        int n=0;
        for(int i=0; i<nRows; i++) {
            for(int j=0; j<nCols; j++) {
                if(n>=pto.ntiles) { 
                    break; 
                }
                n++;
                PlainPortfForTest port = new PlainPortfForTest(s, new CannotDragWRTParent());
                port.setPORTtoDESK( 
                        new ScaRotTraTransformImmutableUniformScale(
                                1.0,
                                0.2,
                                j*TABLEW/nCols,
                                i*TABLEH/nRows
                                ) 
                                );
                pts[i][j] = port;
            }
        }
       
    }
    
    public void finishPTest() throws Throwable {
        while(ps.rootPortfolio.childrenTopToBottomReadOnly.size()>0) {
            ps.rootPortfolio.childrenTopToBottomReadOnly.get(0).setVisibleWhenParentVisible(false);
            ps.rootPortfolio.childrenTopToBottomReadOnly.get(0).destroyThisAndAllDescendants();
            
        }
    }

	
	
    	 

	
}
