#!/bin/bash
# Copyright (c) 2016, Noa Zilberman
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the project, the copyright holder nor the names of its
#  contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#!/bin/bash
SUCCESS_MSG="Test completed successfully"
START_MSG="Started running a latency test"
EMAIL_ADDR="youremail@somewhere.com"
EMAIL_INFO="serveremail@somewhere.com"
export TEST_PATH=/root/latency/
TEST_NUMBER=1
IS_SERVER=0
IS_BYPASS=0
START_SERVER=0
export PIN_PATH=/root/latency/tools/pin/
export CAMIO_PATH=/root/latency/tools/qjump-camio-tools

cd $TEST_PATH
echo "Sending start email"
echo $START_MSG| mail -s "Latency test status report" -r "laency-server<latency.server@somewhere.com>" $EMAIL_ADDR


#App only test
if [ $TEST_NUMBER -eq 1 ]
then
	echo "Running App only test..."
	make -C app_test
fi

#kernel test
if [ $TEST_NUMBER -eq 2 ]
then
	echo "Running min App test..."
	make -C app_test min_run
	echo "Runnning kernel test..."
	make -C kernel_test
fi

#udp test
if [ $TEST_NUMBER -eq 3 ]
then
	if [ $IS_SERVER -eq 0 ]
	then
		echo "Running udp test"
		make -C udp_test
	else
		echo "Running udp server test, press ctrl+break to end"
		make -C udp_test server
	fi
fi

#App-OS test
if [ $TEST_NUMBER -eq 4 ]
then
	echo "Running APP+OS ping test..."
	make -C app_os
	echo "Now comparing to ICMP test..."
	make -C icmp_test test_local
fi

#PCIe test
if [ $TEST_NUMBER -eq 5 ]
then
        echo "Running PCIe test..."
        make -C pcie_test
fi

#VM test
if [ $TEST_NUMBER -eq 6 ] 
then
	echo "Running VM test..."
	make -C vm_test
fi

#Client-Server test
if [ $TEST_NUMBER -eq 7 ]
then
        if [ $IS_SERVER -eq 1 ]
	then
		if [ $IS_BYPASS -eq 0 ]
		then
			echo "Running client-server test as server, press CTRL+C to end"
        		make -C client_server_test server
		else
			echo "Running client-server test as server,, bypass mode, press CTRL+C to end"
                        make -C client_server_test server_bypass
		fi
	else
		if [ $IS_BYPASS -eq 0 ]
		then
			echo "Running client-server test..."
			make -C client_server_test
		else
			echo "Running client-server test, kernell bypass mode"
			make -C client_server_test test_bypass
		fi
	fi
fi

#Exanic test
if [ $TEST_NUMBER -eq 8 ]
then
        echo "Running Exanic test..."
        make -C exanic_test
fi

#Solarflare test
if [ $TEST_NUMBER -eq 9 ]
then
	if [ $IS_SERVER -eq 0 ]
	then
		echo "Running Solarflare test..."
		make -C sfc_test client
	else
		echo "Running Solarflare test..."
                make -C sfc_test server
	fi
fi

#EMU ICMP test
if [ $TEST_NUMBER -eq 10 ]
then
	echo "Running Emu ICMP test..."
	make -C icmp_test
fi

 
#Apache test
if [ $TEST_NUMBER -eq 11 ]
then
        if [ $IS_SERVER -eq 0 ]
	then
		echo "Running Apache test..."
        	make -C motivation_test apache_test
	elif [ $START_SERVER -eq 1 ]
	then
		echo "Running Apache test, starting server..."
		make -C motivation_test apache_server
	else 
		echo "Running Apache test, stopping server.."
		make -C motivation_test apache_server_stop
	fi
fi

#Memcached test

if [ $TEST_NUMBER -eq 12 ]
then
        if [ $IS_SERVER -eq 0 ]
	then
		echo "Running Memcached test..."
        	make -C motivation_test memcached_test
	elif [ $START_SERVER -eq 1 ]
	then
		echo "Running Memcached test, starting server..."
		make -C motivation_test memcached_server
	else 
		echo "Running Memcached test, stopping server..."
		make -C motivation_test memcached_server_stop
	fi
fi

#MySQL test

if [ $TEST_NUMBER -eq 13 ]
then
        if [ $IS_SERVER -eq 0 ]
	then
		echo "Running MySQL test..."
        	make -C motivation_test mysql_test
	elif [ $START_SERVER -eq 1 ]
	then
		echo "Running MySQL test, starting sever..."
		make -C motivation_test mysql_server
	else
		echo "Running MySQL test, stopping server..."
		make -C motivation_test mysql_server_stop
	fi
fi

echo "RUN_STATE=0" > /root/test_state.txt
echo $SUCCESS_MSG| mail -s "Latency test status report" -r "$EMAIL_INFO" $EMAIL_ADDR
