#!/bin/bash
# Copyright (c) 2016, Neelakandan Manihati Bojan
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the project, the copyright holder nor the names of its
#  contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# export the directory and folders

export repo=$HOME/latency
export test_dir=$repo/network_switch_test
export pcap_dir=$test_dir/pcap/
export results_dir=$test_dir/results

# export correct path for camio tools

export camio_base_path=$HOME/qjump-camio-tools


# The following variables are for Tcpreplay.
# Set the interface name and the number of packets to run for
 
interface=eth1
no_of_packets=100

# Giving time for packets to be collected.
 
barrier=5

mkdir results
mkdir results/common_logs


for entry in "$pcap_dir"*
do
  base_name=$(basename $entry)
  xpref=${base_name%.*}
  echo $base_name
  echo $xpref 

  # Creating folders for log files

  mkdir -p results/$xpref
  touch $xpref_ts.txt
  touch $xpref.log
  
  # Starting the DAG capture

  $camio_base_path/dag_capture/bin/dag_capture >> $xpref.dat &
  
  PID=$!
  echo “=== Starting Tcpreplay for ” $base_name  
  # Change the value for --loop to run larger or smaller number of packets.
  
  tcpreplay --topspeed --loop=no_of_packets --intf1=$interface $entry 
  
  sleep $barrier 
  kill $PID
  sleep $barrier
  echo “=== Finished Tcpreplay for ” $base_name
  

  echo “=== Starting the dag_join and dag_analyse scripts for ” $base_name
  
  $camio_base_path/dag_join/bin/dag_join -i dag_cap_A -I dag_cap_B
  $camio_base_path/dag_analyse/bin/dag_analyse -i erf-join.out -o $xpref.log -l 100000
  
  echo “=== Finished the dag_join and dag_analyse scripts for ” $base_name
  
  echo "=== Copying log file to its folder and removing redundant files for " $base_name
  cp dag_cap* results/$xpref
  cp erf-join.out results/$xpref
  cp $xpref.log results/$xpref
  cp $xpref.log results/common_logs
  cp $xpref.dat results/$xpref
  #dag_cap* *.out *.log *.txt
  rm -f dag_cap* *.out *.log *.txt *.dat
  echo "=== Completed test for " $base_name
done

echo "=== ALL TESTS COMPLETED ===" 
