#!/bin/bash
# Copyright (c) 2016, Diana Andreea Popescu
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the project, the copyright holder nor the names of its
#  contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

IP_DST="$1"
NUMBER_OF_RUNS="$2"
ADDED_DELAY_NSEC="$3"
OUTPUT_DIRECTORY="$4"
SLEEP_TIME="$5"
mkdir ${OUTPUT_DIRECTORY}/apache-results
mkdir ${OUTPUT_DIRECTORY}/apache-results/added-delay-${ADDED_DELAY_NSEC}-ns
for i in `seq 1 ${NUMBER_OF_RUNS}`;
do
        echo "Run number" 
	echo $i
        ab -n 1000000 -c 10 -g ${OUTPUT_DIRECTORY}/apache-results/added-delay-${ADDED_DELAY_NSEC}-ns/run-${i}.gnu -e ${OUTPUT_DIRECTORY}/apache-results/added-delay-${ADDED_DELAY_NSEC}-ns/run-${i}.csv http://${IP_DST}/index.html > ${OUTPUT_DIRECTORY}/apache-results/added-delay-${ADDED_DELAY_NSEC}-ns/run-${i}.txt
        sleep $SLEEP_TIME
done
