// Copyright (c) 2015, Matthew Chapman <matthew.chapman@exablaze.com> 
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
//
// * Neither the name of the project, the copyright holder nor the names of its
//  contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#include <unistd.h>
#include <sys/socket.h>
#include <sys/select.h>

static int s1, s2;

static inline void
wait_for_notify(int fd)
{
        fd_set fds;

        FD_ZERO(&fds);
        FD_SET(fd, &fds);
        select(fd+1, &fds, NULL, NULL, NULL);
        read(fd, &fd, 1);
}

static inline void
notify(int fd)
{
        write(fd, &fd, 1);
}

static inline void
pong_thread(void)
{
        while (1)
        {
            wait_for_notify(s2);
            notify(s2);
        }
}

static inline void
ping_thread_init(void)
{
}

static inline void
ping(void)
{
        notify(s1);
        wait_for_notify(s1);
}

static inline void
init(void)
{
        int fds[2];

        socketpair(AF_UNIX, SOCK_DGRAM, 0, fds);
        s1 = fds[0];
        s2 = fds[1];
}

