/*  -*- Mode: C;  -*-
 * File: jroute_util.c
 * Author: James Hall (jch1003@cl.cam.ac.uk)
 * Copyright (C) University of Cambridge Computer Laboratory, 1998
 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ** PACKAGE: 
 **
 ** FUNCTION:
 **
 ** HISTORY:
 ** Created: Tue Aug 11 16:02:56 1998 (jch1003)
 ** Last Edited: Tue Nov  3 15:53:43 1998 By James Hall
 **
    $Log: jroute_util.c,v $
    Revision 1.12  2001/10/24 13:04:49  iap10
    *** empty log message ***

    Revision 1.11  1998/11/11 13:50:28  iap10
    *** empty log message ***

    Revision 1.10  1998/11/11 12:52:52  jch1003
    *** empty log message ***

    Revision 1.9  1998/10/20 22:30:40  iap10
    *** empty log message ***

    Revision 1.7  1998/10/12 10:30:42  iap10
    *** empty log message ***

    Revision 1.6  1998/10/09 14:38:21  iap10
    ..

    Revision 1.5  1998/10/09 12:11:27  jch1003
    *** empty log message ***

    Revision 1.4  1998/09/01 15:41:21  iap10
    *** empty log message ***

    Revision 1.3  1998/08/14 11:46:32  jch1003
    *** empty log message ***

 **~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */


#ifdef linux
#include "linux-tweaks.h"
#endif

#include <stdio.h>

#include <pthread.h>
#include <sys/param.h>
#include <sys/file.h>
				/* concession to AIX */

#include <sys/ioctl.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif
#include <sys/time.h>

#if __STDC__
struct mbuf;
struct rtentry;
#endif

#include <net/if.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <signal.h>

#include <ctype.h>
#include <errno.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <netdb.h>

#include "list.h"
#include "jroute.h"
#include "jroute_threads.h"


FILE *ofile; // = stdout;		/* binary output file */
char *inet_ntoa(struct in_addr addr);

FILE 
*open_ofile(char *fn, int mode)
{
  FILE *f;

  if ((f = fopen(fn, mode == 0 ? "w" : "r")) == NULL)
    error("output file open");
  else
    return f;
}

void 
print_probe_status(FILE *f, int me, probe_res_t *pr, int nprobes)
{
  int i;
  uint32 mask = 0x1;
  char *s;
  uint32 status = pr->status;

  fprintf(f, "#%2d", me);

  for (i = 0; status && i < sizeof(uint32)*8; i++)
    {
      switch ((mask << i) & status)
	{
	case GOT_THERE:        s = " reached-destination "; break;
	case TTL_EXCEEDED:     s = " ttl-exceeded        "; break;
	case TIMED_OUT:        s = " probe-timed-out     "; break;

	case PORT_UNREACH:     s = " port-unreachable    "; break;
	case NET_UNREACH:      s = " net-unreachable     "; break;
	case HOST_UNREACH:     s = " host-unreachable    "; break;
	case PROT_UNREACH:     s = " protocol-unreachable"; break;
	case NEEDFRAG_UNREACH: s = " fragmentation-required"; break;
	case SRCFAIL_UNREACH:  s = " src-route-fail"; break;
	case PROHIB_UNREACH:   s = " access prohibited   "; break;
	case OTHER_UNREACH:    s = " unreachable         "; break;

	case  AGREEMENT:       s = "agreed"; break;
	case  NO_AGREEMENT:    s = "not agreed"; break;

	case RELAXED:          s = "relaxed"; break;
	case BOGUS_ADDR:       s = "bogus"; break;
	default: s = ""; break;
	}
      fprintf(f, "%s", s);
      status ^= mask;
    }
  fprintf(f, " after %d %s\n", nprobes, nprobes > 1 ? "probes" : "probe");
  return;
}

int 
print_train_status(FILE *f, addr_train_t *tr)
{
  int i;
  int printed = 0;
  uint32 mask = 0x1;
  char *s;
  uint32 status = tr->status;

  printed += fprintf(f, " :%d %#x $%s #", tr->nhops, tr->status, 
	  strlen(tr->label) ? tr->label : "");

  /** MAJOR STATUS CODES */

  if (status & GOT_THERE)
      printed += fprintf(f, " OK");
  else if (status & EXPIRED)  
      printed += fprintf(f, " !expired");
  else if (status & UNREACHABLE)
      printed += fprintf(f, " !unreachable");
  else if (status & ERROR)
      printed += fprintf(f, " !error");
  else if (status & GIVEUP)
      printed += fprintf(f, " !giveup");
  else 
     printed +=  fprintf(f, " !XXXXXXXXXX");

  /* MINOR STATUS CODES */
  if (status & NO_AGREEMENT) printed += fprintf(f, " !NO_CONCENSUS_%d", tr->nhops);

  if (status & TIME_OUTS) printed += fprintf(f, " !timeout(s)");

  if (status & INFERRED_DOUBLE) printed += fprintf(f, " !inferred_double"); 

  if (status & POSSIBLE_DOUBLE) printed += fprintf(f, " !possible_double"); 

  if (status & LOOP) printed += fprintf(f, " !loop"); 

  if (status & PORT_UNREACH) printed += fprintf(f, " !port_unreachable");
  if (status & NET_UNREACH) printed += fprintf(f, " !net_unreachable");
  if (status & HOST_UNREACH) printed += fprintf(f, " !host_unreachable");
  if (status & PROT_UNREACH) printed += fprintf(f, " !protocol_unreachable");
  if (status & NEEDFRAG_UNREACH) printed += fprintf(f, " !frag_req");
  if (status & SRCFAIL_UNREACH) printed += fprintf(f, " !src_route_fail");
  if (status & PROHIB_UNREACH) printed += fprintf(f, " !access_prohibited");
  if (status & OTHER_UNREACH) printed += fprintf(f, " !XXX_unreach");

  if (status & RELAXED) printed += fprintf(f, " !icmp_relaxed");
  if (status & BOGUS_ADDR) printed += fprintf(f, " !bogus_addr");
  if (status & DUP_HOPS_SUBST) printed += fprintf(f, " !dup_hops_subst");
  if (status & DUP_HOPS_STRIP) printed += fprintf(f, " !dup_hops_strip");
      
  return printed;
}

#define PRE_SZ 3
#define BIN_DELIM 0xffffffff

void 
print_train(FILE *f, int me, addr_train_t *tr, int lock)
{
  int i;
  int printed = 0;
  int route_indx = 0;

  if (lock)
    write_lock(me);

  printed += fprintf(f, "%-15s: ", inet_ntoa(tr->dest.addrin));
  
  for (i = sort ? 0 : tr->con.ttl_min; i < tr->nhops; i++)
    {
      addr_un_t hop = tr->hops[i];
      if (hop.addrint)
	printed += fprintf(f, "%-15s", inet_ntoa(hop.addrin));
      else
	printed += fprintf(f, "***.***.***.***");
      if (tr->con.route.num)
	{
	  uint32 x = tr->con.route.rt[route_indx].addrint;
	  if (hop.addrint == x)
	    {
	      tr->con.route.num--;
	      if (tr->route_oif.num >= route_indx 
		  && tr->route_oif.rt[route_indx].addrint != x)
		printed += fprintf(f, "/%-15s", inet_ntoa(tr->route_oif.rt[route_indx].addrin));
	      route_indx++;
	    }
	}
      printed += fprintf(f, "|");
    }
  printed += print_train_status(f, tr);
  printed += fprintf(f, "\n");
  
  if (get == get_tnet)
    {
      fflush(f);
      res_sent++;
      res_sentb+= (printed+sizeof(struct tcphdr)+sizeof(struct ip));
    }
  
  if (lock)
    write_unlock(me);
  
  return;
}


void 
pretty_print_trains(FILE *f, addr_train_t *all_addrs, int naddr, int ditto)
{
  int i, j;
  addr_train_t *tr = all_addrs;

  fprintf(f, "%-15s: ", inet_ntoa(tr->dest.addrin));
  for (j = 0; j < tr->nhops; j++)
    {
      fprintf(f, "%-15s|", tr->hops[j].addrint ? 
	      inet_ntoa(tr->hops[j].addrin) : 
	      "***.***.***.***");
    }
  print_train_status(f, tr);
  fprintf(f, "\n");

  for (i = 1; i < naddr; i++)
    {
      addr_train_t *prev = &all_addrs[i-1];
      int prev_nhops = prev->nhops;
      tr = &all_addrs[i];

      fprintf(f, "%-15s: ", inet_ntoa(tr->dest.addrin));
      for (j = 0; j < tr->nhops; j++)
	{
	  fprintf(f, "%-15s|", 
		  tr->hops[j].addrint ? 
		    j <= prev_nhops ?  
		      ( tr->hops[j].addrint == prev->hops[j].addrint &&
			ditto )?
		         "---.---.---.---" : inet_ntoa(tr->hops[j].addrin)
		    : inet_ntoa(tr->hops[j].addrin)
		  : "***.***.***.***"); 
	}
      print_train_status(f, tr);
      fprintf(f, "\n");
    }
  return;
}

int 
cmp_train(const void *key, const void *item)
{
  int i;
  static int cmps = 0;
  addr_train_t *a = (addr_train_t *)key;
  addr_train_t *b = (addr_train_t *)item;
  int ncmps = MAX(a->nhops, b->nhops);

  if (!cmps++%10000)
    fprintf(stderr, ".");

  for (i = 0; i < ncmps; i++)
    {
      if (a->hops[i].addrint < b->hops[i].addrint)
	return -1;
      else if (a->hops[i].addrint > b->hops[i].addrint)
	return 1;
      else
	continue;
    }

  if (a->nhops < b->nhops)
    return -1;
  else if (a->nhops > b->nhops)
    return 1;

  if (a->status < b->status)
    return -1;
  else if (a->status > b->status)
    return 1;

  if (a->dest.addrint < b->dest.addrint)
    return -1;
  else if (a->dest.addrint > b->dest.addrint)
    return 1;

  if (a->port < b->port)
    return -1;
  else if (a->port > b->port)
    return 1;

  return 0;
}

uint32 
comp_addr(addr_un_t *hops, int i, uint32 post)
{
  uint32 pre = i > 0 ? hops[i-1].addrint : 0U;
  uint32 merge = pre^post;
  uint32 folded = (merge & 0xffffff00)^((merge&0xff)<<8);
  return 0x0000007f | folded;
}
  

void 
resolve_duplicates(addr_train_t *tr)
{
  int i;
  int nhops = tr->nhops;
  addr_un_t *hops = tr->hops;
  uint32 last = hops[0].addrint;

  for (i = 1; i < nhops; i++)
    {
      if (last && hops[i].addrint == last)
	{
	  hops[i-1].addrint = comp_addr(hops, i-1, hops[i].addrint);
	}
      last = hops[i].addrint;
    }
  return;
}

/* 
 * The following (with possibly some modification) courtesy of traceroute.c 
 */

/* Not all systems have IFF_LOOPBACK */
#ifdef IFF_LOOPBACK
#define ISLOOPBACK(p) ((p)->ifr_flags & IFF_LOOPBACK)
#else
#define ISLOOPBACK(p) (strcmp((p)->ifr_name, "lo0") == 0)
#endif

#define MAX_IPADDR 32

/*
 * Return the interface list
 */
int
ifaddrlist(register struct ifaddrlist **ipaddrp, register char *errbuf)
{
	register int fd, nipaddr;
#ifdef HAVE_SOCKADDR_SA_LEN
	register int n;
#endif
	register struct ifreq *ifrp, *ifend, *ifnext, *mp;
	register struct sockaddr_in *sin;
	register struct ifaddrlist *al;
	struct ifconf ifc;
	struct ifreq ibuf[MAX_IPADDR], ifr;
	char device[sizeof(ifr.ifr_name) + 1];
	static struct ifaddrlist ifaddrlist[MAX_IPADDR];

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
		(void)sprintf(errbuf, "socket: %s", strerror(errno));
		return (-1);
	}
	ifc.ifc_len = sizeof(ibuf);
	ifc.ifc_buf = (caddr_t)ibuf;

	if (ioctl(fd, SIOCGIFCONF, (char *)&ifc) < 0 ||
	    ifc.ifc_len < sizeof(struct ifreq)) {
		(void)sprintf(errbuf, "SIOCGIFCONF: %s", strerror(errno));
		(void)close(fd);
		return (-1);
	}
	ifrp = ibuf;
	ifend = (struct ifreq *)((char *)ibuf + ifc.ifc_len);

	al = ifaddrlist;
	mp = NULL;
	nipaddr = 0;
	for (; ifrp < ifend; ifrp = ifnext) {
#ifdef HAVE_SOCKADDR_SA_LEN
		n = ifrp->ifr_addr.sa_len + sizeof(ifrp->ifr_name);
		if (n < sizeof(*ifrp))
			ifnext = ifrp + 1;
		else
			ifnext = (struct ifreq *)((char *)ifrp + n);
		if (ifrp->ifr_addr.sa_family != AF_INET)
			continue;
#else
		ifnext = ifrp + 1;
#endif
		/*
		 * Need a template to preserve address info that is
		 * used below to locate the next entry.  (Otherwise,
		 * SIOCGIFFLAGS stomps over it because the requests
		 * are returned in a union.)
		 */
		strncpy(ifr.ifr_name, ifrp->ifr_name, sizeof(ifr.ifr_name));
		if (ioctl(fd, SIOCGIFFLAGS, (char *)&ifr) < 0) {
			if (errno == ENXIO)
				continue;
			(void)sprintf(errbuf, "SIOCGIFFLAGS: %.*s: %s",
			    (int)sizeof(ifr.ifr_name), ifr.ifr_name,
			    strerror(errno));
			(void)close(fd);
			return (-1);
		}

		/* Must be up and not the loopback */
		if ((ifr.ifr_flags & IFF_UP) == 0 || ISLOOPBACK(&ifr))
			continue;

		(void)strncpy(device, ifr.ifr_name, sizeof(ifr.ifr_name));
		device[sizeof(device) - 1] = '\0';
		if (ioctl(fd, SIOCGIFADDR, (char *)&ifr) < 0) {
			(void)sprintf(errbuf, "SIOCGIFADDR: %s: %s",
			    device, strerror(errno));
			(void)close(fd);
			return (-1);
		}

		sin = (struct sockaddr_in *)&ifr.ifr_addr;
		al->addr = sin->sin_addr.s_addr;
		al->device = strdup(device);
		++al;
		++nipaddr;
	}
	(void)close(fd);

	*ipaddrp = ifaddrlist;
	return (nipaddr);
}

void
setsin(register struct sockaddr_in *sin, register uint32 addr)
{
  
  memset(sin, 0, sizeof(*sin));
#ifdef HAVE_SOCKADDR_SA_LEN
  sin->sin_len = sizeof(*sin);
#endif
  sin->sin_family = AF_INET;
  sin->sin_addr.s_addr = addr;
}

/*
 * Subtract 2 timeval structs:  out = out - in.
 * Out is assumed to be >= in.
 */
void
tvsub(register struct timeval *out, register struct timeval *in)
{
  
  if ((out->tv_usec -= in->tv_usec) < 0)   
    {
      --out->tv_sec;
      out->tv_usec += 1000000;
    }
  out->tv_sec -= in->tv_sec;
  if (out->tv_sec < 0)
    out->tv_sec = 0;
}

struct hostinfo *
gethostinfo(register char *hostname)
{
  int n;
  struct hostent *hp;
  struct hostinfo *hi;
  char **p;
  uint32 addr, *ap;
  
  hi = calloc(1, sizeof(*hi));
  if (hi == NULL)
    error("gethostinfo calloc");
  addr = inet_addr(hostname);
  if ((uint32)addr != -1) 
    {
      hi->name = /*savestr*/strdup(hostname);
      hi->n = 1;
      hi->addrs = calloc(1, sizeof(hi->addrs[0]));
      if (hi->addrs == NULL)
	error("gethostinfo calloc");
      hi->addrs[0] = addr;
      return (hi);
    }
  
  hp = gethostbyname(hostname);
  if (hp == NULL)
    return NULL;
  if (hp->h_addrtype != AF_INET || hp->h_length != 4) 
    {
      fprintf(stderr, "%s: bad host %s\n", prog, hostname);
      exit(1);
    }
  hi->name = strdup(hp->h_name);
  for (n = 0, p = hp->h_addr_list; *p != NULL; ++n, ++p)
    continue;
  hi->n = n;
  hi->addrs = calloc(n, sizeof(hi->addrs[0]));
  if (hi->addrs == NULL)
    error("gethostinfo calloc");
  for (ap = hi->addrs, p = hp->h_addr_list; *p != NULL; ++ap, ++p)
    memcpy(ap, *p, sizeof(*ap));

  return (hi);
}

void
freehostinfo(register struct hostinfo *hi)
{
  if (hi->name != NULL) 
    {
      free(hi->name);
      hi->name = NULL;
    }
  free((char *)hi->addrs);
  free((char *)hi);
}

void
getaddr(uint32 *ap, char *hostname)
{
  struct hostinfo *hi;
  
  hi = gethostinfo(hostname);
  if (hi == NULL)
    error2("can't identify host", hostname);
  *ap = hi->addrs[0];
  freehostinfo(hi);
}

int 
parseroute( src_route_t * route, char * list)
{
  char buf[128], *s, *e;
  struct hostinfo *hi;
  int last = 0, i;
  
  route->num = 0;
  
  /* a bit og arg securitry checking... */
  strncpy( buf, list, 128 ); 
  buf[127] = 0;
  
  /* skip any leading spaces etc */
  for( s=buf; *s && ( *s == ' ' || *s == '\t' ) ; s++ );
  do
    {
      for( e=s; ; e++ )
	{
	  
	  if( *e == 0 || *e == ' ' || *e == '\t' || *e == '\n' )
	    { 
	      last = 1; 
	      break; 
	    }
	  
	  if( *e == '+' ) break;
	  
	}
      
      *e = 0;
      
      hi = gethostinfo(s);
      
      if (hi == NULL)
	{
	  fprintf(stderr, "# can't resolve host \"%s\"\n", s);
	  return 0;
	}
      else
	{
	  route->rt[route->num++].addrint = hi->addrs[0];
	  freehostinfo(hi);
	}
      s = e + 1;
    }
  while( !last );
#define ZTRC
#ifdef ZTRC
  if (route->num > 1)
    {	 
      fprintf(stderr, "SRC-Route via: ");
      for(i=0;i<route->num;i++) 
	fprintf(stderr, "%s ", 
	    inet_ntoa(route->rt[i].addrin));
      fprintf(stderr, "\n");
    }
#endif  
  return 1;
}

/*
 * A faster replacement for inet_ntoa().
 */
char *
intoa(uint32 addr)
{
  char *cp;
  u_int byte;
  int n;
  static char buf[sizeof(".xxx.xxx.xxx.xxx")];
  
//  NTOHL(addr);
  addr = ntohl(addr);
  cp = &buf[sizeof buf];
  *--cp = '\0';
  
  n = 4;
  do 
    {
      byte = addr & 0xff;
      *--cp = byte % 10 + '0';
      byte /= 10;
      if (byte > 0) 
	{
	  *--cp = byte % 10 + '0';
	  byte /= 10;
	  if (byte > 0)
	    *--cp = byte + '0';
	}
      *--cp = '.';
      addr >>= 8;
    } while (--n > 0);
  
  return cp + 1;
}
 
/*
 * "gethname" is written in this atrocious way to make sure we don't
 * wait forever while trying to get hostnames from yp.
 */
#include <setjmp.h>

jmp_buf getname_env;

static void
nohostname(unused)
int unused;
{
  longjmp(getname_env, 1);
} 

/*
 * Return a name for the IP address pointed to by ap.  This address
 * is assumed to be in network byte order.
 *
 * S'be already aligned
 */
char *
get_hname(char *ap)
{
  static char hnm[1024];
  if (!setjmp(getname_env)) 
    {
      struct hostent *hp;
      (void)signal(SIGALRM, nohostname);
      (void)alarm(20);
      hp = gethostbyaddr(ap, 4, AF_INET);
      (void)alarm(0);
      if (hp) 
	{
	  strcpy(hnm, hp->h_name);
	  return hnm;
	}
    }

  strcpy(hnm, intoa(*(uint32 *)ap));
  return hnm;
}



  

  
