/*
 *	ntsc/ix86/khead.S
 *	-----------------
 *
 * Copyright (c) 1996 University of Cambridge Computer Laboratory.
 * This is part of Nemesis; consult your contract for terms and conditions.
 *
 * $Id: khead.S 1.1 Thu, 18 Feb 1999 15:09:39 +0000 dr10009 $
 *
 * This code contains the startup code for Nemesis.
 */

/* startup_32 will be located at physical/virtual address 0x100000
 * The 16-bit setup code will be loaded at 0x90000, and will have set
 * up a temporary GDT somewhere around there. CS will be 0x10 (kernel
 * code segment); it is up to us to set DS and do other initialisation.
 */

#define STAT_TABLE_SIZE 0x4000
	
#include "segment.h"
#include <context.h>
#include <dcb.off.h>
#include <pip.h>	
#include <kernel_st.h>
	
/* ------------------------------------------------------------ */

/* Align to multiple of 16 bytes, fill space with 0x90 (nop) */
#define ALIGN		.align 4,0x90

/* ------------------------------------------------------------ */

#define KERNEL_STACK_END	0x8fff0
/* The kernel stack won't get very large; maybe we should just reserve
 * one or two pages for it. */

/* If we were loaded by a MultiBoot-compliant loader we are entered here
   with %eax==0x2badb002 and %ebx containing the address of the
   multiboot_info structure. The segment registers all contain valid
   values (although the GDT isn't valid)

   If we were loaded by anything else then the segment registers may not
   contain valid values, but we have a valid (temporary) GDT. */

.text
	.globl	_start
	.globl	startup_32
_start:	
startup_32:
	cli
	cld
	/* At this point possibly only CS is valid. Switch to our GDT
	   and load segment registers first */
	lgdt	gdt_desc
	movl	$(KERNEL_DS), %edx
	movw	%dx, %ds
	movw	%dx, %ss
	movw	%dx, %es /* es is used in some instructions generated by gcc */
	xorl	%edx, %edx
	movw	%dx, %fs
	movw	%dx, %gs
	
	/* Setup stack */
	movl	$(KERNEL_STACK_END), %edx
	movl	%edx, %esp
	pushl	$0
	pushl	%ebx	/* multiboot_info */
	pushl	%eax	/* multiboot_magic */

	/* permute tss entry (bytes 0,1,7 are ok already)
	    remember this is an intel, alignment doesnt matter, duh. */
	movl	$gdt, %edi
	movw	10(%edi), %ax
	movl	12(%edi), %edx
	movl	%edx, 10(%edi)
	movw	%ax, 13(%edi)
	movl	$(KERNEL_TS), %eax
	ltr	%ax	/* Load task register */

	/* Reload CS using new GDT */
	pushl	$(KERNEL_CS)
	pushl	$.L1
	lret
.L1:
	call	init_idt
	call	init_fpu
	call	k_init	/* Uses multiboot_magic and multiboot_info pushed
			   earlier */

	ALIGN
multiboot_info:
	.long	0x1badb002	/* Magic MultiBoot number */
	.long	0x10002		/* Flags: require memory information */
	.long	0		/* Checksum (filled in later) */
	.long	multiboot_info	/* Header address */
	.long	0x100000	/* Load address */
	.long	0		/* Load end address (filled in later) */
	.long	0		/* BSS end address (filled in later) */
	.long	0x100000	/* Entry address */

	.globl	init_cache
init_cache:
	wbinvd	/* Flush cache */
	movl	%cr0, %eax
	andl	$0x9fffffff, %eax  /* Clear cache disable bits */
	movl	%eax, %cr0
	ret

	.globl  init_pmctr
init_pmctr:
	movl	$0xc1,%ecx	/* pmctr0 */
	xorl	%eax, %eax	
	xorl	%edx, %edx
	wrmsr 
	movl	$0xc2, %ecx	/* pmctr1 */
	wrmsr 
	movl	$0x187, %ecx	/* evsel1 */
	movl	$0x30048, %eax	/* DCU wait cycles */
	wrmsr
	movl	$0x186, %ecx	/* evsel0 */
	movl	$0x4300C0, %eax	/* Insts retired + EN + OS + USR  */
	wrmsr
	ret
	
init_fpu:
	clts
	fninit	/* Clear floating point state */
	movl	%cr0, %eax
	/* We want to set bits 5 and 1 and clear bit 2 */
	andl	$~CR0_EM, %eax
	orl	$CR0_NE|CR0_MP, %eax
	movl	%eax, %cr0
	ret

	.globl processor_cpuid_available
processor_cpuid_available:
	/* Perform a simple check of the processor type */
	/* Return the result in eax */
	pushfl
	pushl	%ecx
	pushfl
	popl	%eax
	movl	%eax, %ecx
	/* Try flipping the ID bit in EFLAGS */
	xorl	$0x200000, %eax
	pushl	%eax
	popfl
	/* See if it worked */
	pushfl
	popl	%eax
	xorl	%eax, %ecx
	je	1f
	/* If we get here the cpuid instruction is available */
	movl	$1, %eax
	popl	%ecx
	popfl
	ret
1:
	/* If we get here there is no cpuid instruction */
	xorl	%eax, %eax
	popl	%ecx
	popfl
	ret

	.globl	read_cpuid
read_cpuid:
	pushl	%ebp
	movl	%esp, %ebp
	pushl	%ebx
	pushl	%ecx
	pushl	%edx
	pushl	%edi
	movl	8(%ebp), %eax
	movl	12(%ebp), %edi
	cpuid
	movl	%eax, (%edi)
	movl	%ebx, 4(%edi)
	movl	%ecx, 8(%edi)
	movl	%edx, 12(%edi)
	popl	%edi
	popl	%edx
	popl	%ecx
	popl	%ebx
	popl	%ebp
	ret

	.globl	k_set_debug_registers
k_set_debug_registers:
	/* We are passed the address of a block of memory in eax */
	movl	0x0(%eax), %ebx
	movl	%ebx, %dr0
	movl	0x4(%eax), %ebx
	movl	%ebx, %dr1
	movl	0x8(%eax), %ebx
	movl	%ebx, %dr2
	movl	0xc(%eax), %ebx
	movl	%ebx, %dr3
	movl	0x10(%eax), %ebx
	movl	%ebx, %dr7
	movl	$0x0, %ebx
	movl	%ebx, %dr6
	ret

	/* void k_enable_paging(void) */
	.globl	k_enable_paging
k_enable_paging:
	movl	%cr0, %eax
	orl	$0x80000000, %eax	/* Set PG bit */
	movl	%eax, %cr0
	jmp	1f	/* Flush pipeline */
1:
	ret

	/* void k_disable_paging(void) */
	.globl	k_disable_paging
k_disable_paging:
	movl	%cr0, %eax
	andl	$0x7fffffff, %eax
	movl	%eax, %cr0
	jmp 1f
1:
	ret
	

	.globl	chain_relocator
	.globl	chain_relocator_end
	ALIGN
chain_relocator:
	lgdt	0x80000
	movl	0x90200, %ebx	/* base address of image */
	movl	0x90204, %ecx	/* length of image in words */
	movl	$0x100000, %edx	/* destination address */
1:	movl	(%ebx), %eax	/* load word of image */
	movl	%eax, (%edx)	/* store word of image */
	addl	$4, %ebx
	addl	$4, %edx
	decl	%ecx
	jnz	1b
	movl	$0x100000, %edx
	jmp	*%edx
chain_relocator_end:

.text
	/* NORETURN k_idle(void) */
	.globl  k_idle
k_idle:
	movl	$KERNEL_STACK_END, %eax
	movl	%eax, %esp
	pushl	%eax
	movl	$k_st, %eax
	xorl	%ebx, %ebx
	movl	%ebx, KST_DCB(%eax)
1:	
	sti
/*	hlt	stops the cycle counter so we leave it out for now */
	jmp	1b


/* NORETURN k_activ_go(context_t *cx, uint32_t cs, uint32_t ds) */
/* When we activate, we don't need to restore floating point or pervasives
   registers. This routine is therefore a shorter version of k_resume */
	.globl	k_activ_go
k_activ_go:
	fninit
	movl	4(%esp), %edi
	movl	8(%esp), %ecx
	movl	12(%esp), %edx
	pushl	%edx
	movl	CX_ESP*4(%edi), %eax
	pushl	%eax
	movl	CX_EFLAG*4(%edi), %eax
	pushl	%eax
	pushl	%ecx
	movl	CX_EIP*4(%edi), %eax
	pushl	%eax
	xorl	%ebp,%ebp
	movw	%dx, %ds
	movw	%dx, %es
	iret
	

/* NORETURN k_presume(context_t *cx, uint32_t cs, uint32_t ds) */
/* This is a special function to enter NemesisPrimal; there is no
   DCB at this point, so we can't restore a pervasives pointer */
	.globl	k_presume
k_presume:
	movl	4(%esp), %edi
	jmp	cx_restore_fp

/* NORETURN k_resume(context_t *cx, uint32_t cs, uint32_t ds) */
	.globl	k_resume
k_resume:
	movl	4(%esp), %edi
	movl    INFO_PAGE_ADDRESS+PIP_PVSPTR,%eax
	movl	CX_PVS*4(%edi), %ebx
	movl	%ebx, (%eax)
/* XXX falls through to cx_restore */

/* cx_restore: expects %edi to point to a context_t */
cx_restore:
#ifdef NTSC_PROFILE
	/* Before we restore the context, calculate how much time we spent
	   in the kernel */
	movl	k_st+KST_STAT_TABLE, %ecx
	testl	%ecx, %ecx
	jz	2f  /* ...if it's null */
	rdtsc
	movl	k_st+KST_KTIME, %ebx
	subl	%ebx, %eax
	/* If it's way out of range reduce it to the maximum */
	cmpl	$STAT_TABLE_SIZE, %eax
	jna	1f
	movl	$STAT_TABLE_SIZE-1, %eax
1:
	/* Now store the difference in the stats table */
	incl	(%ecx, %eax, 4)

2:	/* Now back to our regular context restore */
#endif /* NTSC_PROFILE */
cx_restore_fp:
	/* Floating point regs */
	frstor	CX_FPREG*4(%edi)
cx_restore_nfp:
	/* Segment registers */
	movl	8(%esp), %ecx  /* CS */
	movl	12(%esp), %edx /* DS */
	/* SS3 */
	pushl	%edx
	/* ESP3 */
	movl	CX_ESP*4(%edi), %eax
	pushl	%eax
	/* Flags */
	movl	CX_EFLAG*4(%edi), %eax
	pushl	%eax
	/* User code segment */
	pushl	%ecx
	/* EIP */
	movl	CX_EIP*4(%edi), %eax
	pushl	%eax
	/* Everything else */
	movl	CX_EDX*4(%edi), %eax
	pushl	%eax /* ultimately edx */
	movl	CX_EAX*4(%edi), %eax
	movl	CX_EBX*4(%edi), %ebx
	movl	CX_ECX*4(%edi), %ecx
	movl	CX_ESI*4(%edi), %esi
	movl	CX_EBP*4(%edi), %ebp
	movl	CX_EDI*4(%edi), %edi
	/* Switch over to user DS */
	movw	%dx, %ds
	movw	%dx, %es /* some instructions generated by gcc use this */
	popl	%edx
	/* Return to user mode */
	iret

/* ------------------------------------------------------------ */
/* Some support code - how to reboot a PC. This works by
 * generating an interrupt which generates an exception because the
 * access to the interrupt table fails, which in turn raises an
 * double-exception because the access to the interrupt table for
 * handling the exception fails. This in turn generates a triple
 * exception exception which causes the chip to reset.
 */
	
	.globl	re_enter_rom
re_enter_rom:
	lidt	idt_crash_desc
	int	$0

.section	.rodata
idt_crash_desc:
	.word	0
	.long	0

	.globl	gdt_desc
	.globl	tss_end
gdt_desc:
	.word	8*8	/* 8 entries */
	.long	gdt

gdt:
	.word	0,0,0,0		/* reserved first entry */

	/* TSS - permuted in init_gdt - selector 0x08 */
	.word	tss_end - tss - 1
	.word	0xc089		/* XXX what does this mean? */
	.long	tss

	/* Kernel code descriptor - selector 0x10 */
	.word	0xffff		/* Bits 0--15 of limit */
	.word	0x0000		/* Bits 0--15 of base */
	.word	0x9a00	/* Present, appl, type=a, priv=0, base 16--23 */
	.word	0x00cf	/* Base 24--31, page gran, big seg, limit 16--19 */

	/* Kernel data descriptor - selector 0x18 */
	.word	0xffff		/* Bits 0--15 of limit */
	.word	0x0000		/* Bits 0--15 of base */
	.word	0x9200	/* Present, appl, type=2, priv=0, base 16--23 */
	.word	0x00cf	/* Base 24--31, page gran, big seg, limit 16--19 */

	/* User code descriptor - selector 0x23 */
	.word	0xffff		/* Bits 0--15 of limit */
	.word	0x0000		/* Bits 0--15 of base */
	.word	0xfa00	/* Present, appl, type=a, priv=3, base 16--23 */
	.word	0x00cf	/* Base 24--31, page gran, big seg, limit 16--19 */

	/* User data descriptor - selector 0x2b */
	.word	0xffff		/* Bits 0--15 of limit */
	.word	0x0000		/* Bits 0--15 of base */
	.word	0xf200	/* Present, appl, type=2, priv=3, base 16--23 */
	.word	0x00cf	/* Base 24--31, page gran, big seg, limit 16--19 */

	/* Privileged code descriptor - selector 0x32 */
	.word	0xffff
	.word	0x0000
	.word	0xda00
	.word	0x00cf
	
	/* Privileged data descriptor - selector 0x3a */
	.word	0xffff
	.word	0x0000
	.word	0xd200
	.word	0x00cf

tss:
	.word	0, 0	/* "any user may set NT and execute IRET"! */
	.long	KERNEL_STACK_END	/* XXX wild guess... */
	.word	KERNEL_DS, 0
	.long	0, 0
	.long	0, 0
	.long	0		/* XXX CR3 - don't think we need this (?) */
	/* registers */
	.long	0,0		/* XXX Am I giving anything away here? */
	.long	0,0,0,0,0,0,0,0
	/* segments */
	.word	USER_DS, 0
	.word	USER_CS, 0
	.word	USER_DS, 0
	.word	USER_DS, 0
	.word	USER_DS, 0
	.word	USER_DS, 0
	.word	0, 0
	.word	0, 0x66		/* iobitmap starts immediately */
	/* add nothing here... */
tss_end:

/* End of ntsc/ix86/khead.S */
