/*
 * fore_msg.h: interface file for the data types and xdr routines
 * generated by rpcgen (fore_xdr.h, fore_xdr.c)
 */

#ifndef _FORE_MSG_H
#define _FORE_MSG_H

#if defined(RCSID) && !defined(lint)
static char _fore_msg_h_rcsid[] = "@(#)$Id: fore_msg.h 1.1 Thu, 29 Apr 1999 09:53:48 +0100 dr10009 $ FSI";
#endif /* RCSID && !lint */

/*
 * Fore product release number.
 *
 * Format: 0xxyyzz
 *	xx = Major release
 *	yy = Minor release
 * 	zz = Engineering release
 *
 * Extracted from Makefile.
 */
#define FORE_RELEASE		FORE_RELEASE_HEX
#define FORE_RELEASE_MAJOR	(0xff & (FORE_RELEASE >> 16))
#define FORE_RELEASE_MINOR	(0xff & (FORE_RELEASE >> 8))
#define FORE_RELEASE_ENG	(0xff & (FORE_RELEASE))

#ifndef	FORE
#define	FORE(name)	name
#endif	/* FORE */

#define ADR_SIZE  8	/* 8 bytes for an address in an ATM network */

#define CLS_PDU_SIZE 4096 /* up to 4096 bytes in a connectionless message */

#define FORE_SIG_VPI 0x0	/* VPI for signaling to neighbors */
#define FORE_Q2931_SIG_VCI 0x5	/* VCI for Q.2931 signaling */
#define FORE_SIG_VCI 0xF	/* VCI for signaling to neighbors */
#define FORE_CLS_VCI 0xE	/* VCI for connectionless service */

#include "fore_xdr.h"

#ifndef MACRO_BEGIN
#define MACRO_BEGIN do {

#ifndef lint
#define MACRO_END       } while (0)
#else   /* lint */
#define MACRO_END       } while (__never__)
extern int __never__;
#endif  /* lint */

#endif /* MACRO_BEGIN */

/* these should be in atm.h */
#define VPI_BITS	8
#define VCI_BITS	16
#define VPI_MASK	((1 << VPI_BITS) - 1)
#define VCI_MASK	((1 << VCI_BITS) - 1)

/* vpi and vci encoding and decoding */
#define MKVPVC(vp,vc) \
			((Vpvc) (((vp) & VPI_MASK) << VCI_BITS) | ((vc) & VCI_MASK))
#define VP_ID(vpvc)	(((vpvc) >> VCI_BITS) & VPI_MASK)
#define VC_ID(vpvc)	((vpvc) & VCI_MASK)


/* top 3 bits of the address */
#define SPANS_RESERVED_CLASS	0x00	/* 0 << 5, for excape to level 3 */
#define SPANS_ANYCAST_CLASS	0x20	/* 1 << 5 */
#define SPANS_HVC_CLASS		0x40	/* 2 << 5 */
#define SPANS_GROUP_CLASS	0x60	/* 3 << 5 */


#define IS_CLASS_ADDR(aa)  ((aa).addr[0] & 0x80)  /* CLASS ADDR have MSB set */

#define CLASS_ID(aa) (((aa).addr[0]) & 0x60)   /* top 3 bits */

/*
 * a non-unicast address has the msb set
 */       

#define IS_ANYCAST_ADDR(aa) 	(CLASS_ID(aa) == SPANS_ANYCAST_CLASS)
#define IS_ANYCAST(gid)		((gid).type[0] == SPANS_ANYCAST_CLASS)
#define IS_GROUP_ADDR(aa)  (CLASS_ID(aa) == SPANS_GROUP_CLASS)
#define IS_HVC_ADDR(aa)  (CLASS_ID(aa) == SPANS_HVC_CLASS)


                           
/* address encoding and decoding */

#define SET_VPI(aa, vpi) MACRO_BEGIN  \
                           (aa).addr [0] = (((vpi) >> 4) & 0x7F) ;     \
                           (aa).addr [1] = ((((vpi) & 0x0F) << 4) |    \
                                              ((aa).addr[1] & 0x0F));  \
                         MACRO_END

#define SET_PORT(aa, port) MACRO_BEGIN \
                           (aa).addr [1] = ((((port) >> 16) & 0x0F) |  \
                                              ((aa).addr[1] & 0xF0));  \
			   (aa).addr [2] = ((port) >> 8) & 0xFF; \
			   (aa).addr [3] = ((port) & 0xFF); \
                           MACRO_END

#define SET_SWITCH(aa, sw) MACRO_BEGIN \
			   (aa).addr [7] = ((sw) & 0xFF); \
			   (aa).addr [6] = ((sw) >> 8) & 0xFF; \
			   (aa).addr [5] = ((sw) >> 16) & 0xFF; \
			   (aa).addr [4] = ((sw) >> 24) & 0xFF; \
                           MACRO_END

#define SET_ADDR(addr, sw, port, vpi) MACRO_BEGIN \
			   SET_SWITCH ((addr), (sw)); \
			   SET_PORT ((addr), (port)); \
                           SET_VPI ((addr), (vpi));   \
                           MACRO_END


#define SET_GROUP(aa, group) \
		MACRO_BEGIN \
		(aa).addr[3] = ((group) & 0xFF); \
		(aa).addr[2] = ((group) >> 8) & 0xFF; \
		(aa).addr[1] = ((group) >> 16) & 0xFF; \
		(aa).addr[0] = ((aa).addr[0] & 0xF0) | ((group) >> 24) & 0xF; \
		MACRO_END

#define SET_CLASS(aa, class) \
		MACRO_BEGIN \
		(aa).addr[0] = ((aa).addr[0] & 0xF) | 0x80 | \
							((class) & 0x7) << 4; \
		MACRO_END

#define SET_MCAST_GROUP(_addr, _class, _group, _switch) \
		MACRO_BEGIN \
		SET_SWITCH(_addr, _switch); \
		SET_GROUP(_addr, _group); \
		SET_CLASS(_addr, _class); \
		MACRO_END

#define GROUP_IP	6


/*type 
 *  these routines are for the switch, which treats the
 *  31 bit class+group fields as 1 "full" group field
 */
#define SET_FULL_GROUP(aa, group) \
        		MACRO_BEGIN \
	        	(aa).addr[3] = ((group) & 0xFF); \
		        (aa).addr[2] = ((group) >>  8) & 0xFF; \
        		(aa).addr[1] = ((group) >> 16) & 0xFF; \
	        	(aa).addr[0] = ((group) >> 24) & 0x1F; \
		        MACRO_END


#define SET_FULL_ANYCAST_ADDR(addr, sw, gid) \
			MACRO_BEGIN \
			SET_SWITCH ((addr), (gid.addr)); \
			(addr).addr[0] = SPANS_ANYCAST_CLASS; \
			(addr).addr[1] = 0; \
			(addr).addr[2] = ((sw) >> 8) & 0xFF; \
			(addr).addr[3] = (sw) & 0xFF; \
			MACRO_END
		
#define SET_FULL_GROUP_ADDR(addr, sw, gid) \
			MACRO_BEGIN \
                        SET_SWITCH ((addr), (sw)); \
                        SET_FULL_GROUP  ((addr), (gid.addr)); \
                	(addr).addr[0] |= SPANS_GROUP_CLASS; \
                        (addr).addr[0] |= 0x80; \
                        MACRO_END


#define SET_HVC_ADDR(_addr,  _hvcid, _switch) \
		MACRO_BEGIN \
		SET_SWITCH(_addr, _switch); \
		SET_GROUP(_addr, (_hvcid) & 0xffff); \
		(_addr).addr[0] |= 0xc0; \
		MACRO_END

#define HVC_ID(aa) (BYTE_V ((aa), 3) + BYTE_VS ((aa), 2, 8))
		   


/* *********************** NOTICE: **********************************
 * switch_id() may become obsolete if the type of Switch_addr changes
 * to be more than 4 bytes long.
 * However, the macros "get_switch", "ass_switch" will be retained even
 * if the type of Switch_addr changes. */
/* for symmetry, if switch_id disappears, port_id will also be removed */

#define BYTE_V(aa,n) (((unsigned int) (aa).addr [n]) & 0xFF)
#define BYTE_VS(aa,n,s) ((((unsigned int) (aa).addr [n]) & 0xFF) << (s))
#define BYTE_CP(t,f,n) ((t).addr [n] = (f).addr [n])

#define SWITCH_ID(aa) (BYTE_V ((aa), 7) + BYTE_VS ((aa), 6, 8) +	\
		       BYTE_VS ((aa), 5, 16) + BYTE_VS ((aa), 4, 24))

#define PORT_ID(aa) (BYTE_V ((aa), 3) + BYTE_VS ((aa), 2, 8) + \
		     (BYTE_VS ((aa), 1, 16) & 0x000f0000))

#define PATH_ID(aa) ( (BYTE_VS ((aa), 0, 4)) + (BYTE_V((aa), 1) >> 4) )

#define GROUP_ID(aa) (BYTE_V ((aa), 3) + BYTE_VS ((aa), 2, 8) +	\
		       BYTE_VS ((aa), 1, 16) + BYTE_VS ((aa), 0, 24))

/* the following macros should replace switch_id and port_id, and provide
 * additional facilities (assignment and comparison) should the switch type
 * change
 */
typedef unsigned int Switch_addr;
typedef unsigned int Port_addr;
#define GET_SWITCH(sw, addr) (sw) = SWITCH_ID (addr)
#define GET_PORT(port, addr) ( port) = PORT_ID (addr)
#define GET_VPI(vpi, addr)   (vpi) = PATH_ID(addr)
#define EQ_SWITCH(sw1, sw2) ((sw1) == (sw2))
#define EQ_PORT(p1, p2) ((p1) == (p2))
#define LESS_SWITCH(sw1, sw2) ((sw1) < (sw2))
#define LESS_PORT(p1, p2) ((p1) < (p2))
#define ASS_SWITCH(to, from) (to) = (from)
#define LOGPORT_GET_PORT(port, logport)  (port) = (((logport) >> 16) & 0xffff)
#define LOGPORT_GET_VPI(vpi, logport)    (vpi)  = ((logport) & 0xffff)
#define LOGPORT_SET_PORT(logport, port)  (logport) |= ((port & 0xffff) << 16 )
#define LOGPORT_SET_VPI(logport, vpi)    (logport) |= (vpi & 0xffff)


#define ASS_ADDR(t,f) MACRO_BEGIN \
		      BYTE_CP((t),(f),0); BYTE_CP((t),(f),1);	\
		      BYTE_CP((t),(f),2); BYTE_CP((t),(f),3);	\
		      BYTE_CP((t),(f),4); BYTE_CP((t),(f),5);	\
		      BYTE_CP((t),(f),6); BYTE_CP((t),(f),7);   \
		      MACRO_END

#define EQ_ADDR(a1,a2) ((SWITCH_ID (a1) == SWITCH_ID (a2)) &&   \
		        (PORT_ID (a1) == PORT_ID (a2))     &&   \
                        (PATH_ID (a1) == PATH_ID (a2)))

#define LESS_ADDR(a1,a2) ((SWITCH_ID (a1) < SWITCH_ID (a2)) ||  \
			  ((SWITCH_ID (a1) == SWITCH_ID (a2)) &&  \
		           (PORT_ID (a1) < PORT_ID (a2)))   ||    \
                          ((SWITCH_ID (a1) == SWITCH_ID (a2)) &&  \
                           (PORT_ID (a1) == PORT_ID (a2))     &&  \
                           (PATH_ID(a1)  < PATH_ID (a2) )))

/* access macros for the types defined in message.x */
#define SPANS_TYPE	value.type

#define OPEN_R		value.Msg_contents_u.open_req.conn
#define OPEN_R_AAL	value.Msg_contents_u.open_req.aal
#define OPEN_R_QOS	value.Msg_contents_u.open_req.qos
#define OPEN_R_MIN	value.Msg_contents_u.open_req.min
#define OPEN_R_PREF	value.Msg_contents_u.open_req.pref

#define OPEN_I		value.Msg_contents_u.open_ind.conn
#define OPEN_I_AAL	value.Msg_contents_u.open_ind.aal
#define OPEN_I_QOS	value.Msg_contents_u.open_ind.qos
#define OPEN_I_MIN	value.Msg_contents_u.open_ind.min
#define OPEN_I_PREF	value.Msg_contents_u.open_ind.pref

#define OPEN_S		value.Msg_contents_u.open_rsp.conn
#define OPEN_S_RESULT	value.Msg_contents_u.open_rsp.result
#define OPEN_S_VPVC	value.Msg_contents_u.open_rsp.vpvc
#define OPEN_S_QOS	value.Msg_contents_u.open_rsp.qos

#define OPEN_C		value.Msg_contents_u.open_cnf.conn
#define OPEN_C_RESULT	value.Msg_contents_u.open_cnf.result
#define OPEN_C_VPVC	value.Msg_contents_u.open_cnf.vpvc
#define OPEN_C_QOS	value.Msg_contents_u.open_cnf.qos

#define MULTI_R		value.Msg_contents_u.multi_req.conn
#define MULTI_R_AAL	value.Msg_contents_u.multi_req.aal
#define MULTI_R_QOS	value.Msg_contents_u.multi_req.qos
#define MULTI_R_MIN	value.Msg_contents_u.multi_req.min
#define MULTI_R_PREF	value.Msg_contents_u.multi_req.pref

#define MULTI_I		value.Msg_contents_u.multi_ind.conn
#define MULTI_I_AAL	value.Msg_contents_u.multi_ind.aal
#define MULTI_I_QOS	value.Msg_contents_u.multi_ind.qos
#define MULTI_I_MIN	value.Msg_contents_u.multi_ind.min
#define MULTI_I_PREF	value.Msg_contents_u.multi_ind.pref

#define MULTI_S		value.Msg_contents_u.multi_rsp.conn
#define MULTI_S_RESULT	value.Msg_contents_u.multi_rsp.result
#define MULTI_S_VPVC	value.Msg_contents_u.multi_rsp.vpvc
#define MULTI_S_QOS	value.Msg_contents_u.multi_rsp.qos

#define MULTI_C		value.Msg_contents_u.multi_cnf.conn
#define MULTI_C_RESULT	value.Msg_contents_u.multi_cnf.result
#define MULTI_C_VPVC	value.Msg_contents_u.multi_cnf.vpvc
#define MULTI_C_QOS	value.Msg_contents_u.multi_cnf.qos

#define ADD_R		value.Msg_contents_u.add_req.conn
#define ADD_R_OLD	value.Msg_contents_u.add_req.old

#define ADD_I		value.Msg_contents_u.add_ind.conn
#define ADD_I_OLD	value.Msg_contents_u.add_ind.old

#define ADD_S		value.Msg_contents_u.add_rsp.conn
#define ADD_S_RESULT	value.Msg_contents_u.add_rsp.result
#define ADD_S_QOS	value.Msg_contents_u.add_rsp.qos

#define ADD_C		value.Msg_contents_u.add_cnf.conn
#define ADD_C_RESULT	value.Msg_contents_u.add_cnf.result
#define ADD_C_QOS	value.Msg_contents_u.add_cnf.qos


#define JOIN_R_GRP      value.Msg_contents_u.join_req.group

#define JOIN_C_GRP      value.Msg_contents_u.join_cnf.group
#define JOIN_C_RESULT   value.Msg_contents_u.join_cnf.result

#define LEAVE_R_GRP     value.Msg_contents_u.leave_req.group

#define LEAVE_C_GRP     value.Msg_contents_u.leave_cnf.group
#define LEAVE_C_RESULT  value.Msg_contents_u.leave_cnf.result

#define MPP_R		value.Msg_contents_u.mpp_req.pseudo
#define MPP_R_CONN	value.Msg_contents_u.mpp_req.conn
#define MPP_R_AAL	value.Msg_contents_u.mpp_req.aal
#define MPP_R_QOS	value.Msg_contents_u.mpp_req.qos
#define MPP_R_MIN	value.Msg_contents_u.mpp_req.min
#define MPP_R_PREF	value.Msg_contents_u.mpp_req.pref

#define MPP_S		value.Msg_contents_u.mpp_rsp.conn
#define MPP_S_RESULT	value.Msg_contents_u.mpp_rsp.result
#define MPP_S_VPVC	value.Msg_contents_u.mpp_rsp.vpvc
#define MPP_S_QOS	value.Msg_contents_u.mpp_rsp.qos

#define SETUP_R		value.Msg_contents_u.setup_req.conn
#define SETUP_R_QOS	value.Msg_contents_u.setup_req.qos
#define SETUP_R_MIN	value.Msg_contents_u.setup_req.min
#define SETUP_R_PREF	value.Msg_contents_u.setup_req.pref
/* #define SETUP_R_ROUTE	value.Msg_contents_u.setup_req.route */
#define SETUP_R_RLEN	value.Msg_contents_u.setup_req.route.num_hops
#define SETUP_R_RFIRST	value.Msg_contents_u.setup_req.route.first_hop
#define SETUP_R_RHOP	value.Msg_contents_u.setup_req.route.route
#define SETUP_R_NVCI	value.Msg_contents_u.setup_req.num_vci
#define SETUP_R_MVCI	value.Msg_contents_u.setup_req.min_vci

#define SETUP_S		value.Msg_contents_u.setup_rsp.conn
#define SETUP_S_RESULT	value.Msg_contents_u.setup_rsp.result
#define SETUP_S_QOS	value.Msg_contents_u.setup_rsp.qos
/* #define SETUP_S_ROUTE	value.Msg_contents_u.setup_rsp.route */
#define SETUP_S_RLEN	value.Msg_contents_u.setup_rsp.route.num_hops
#define SETUP_S_RFIRST	value.Msg_contents_u.setup_rsp.route.first_hop
#define SETUP_S_RHOP	value.Msg_contents_u.setup_rsp.route.route
#define SETUP_S_FVCI	value.Msg_contents_u.setup_rsp.first_vpvc
#define SETUP_S_LVCI	value.Msg_contents_u.setup_rsp.last_vpvc

#define CLOSE_R		value.Msg_contents_u.close_req.conn

#define CLOSE_I		value.Msg_contents_u.close_ind.conn

#define CLOSE_S		value.Msg_contents_u.close_rsp.conn
#define CLOSE_S_RESULT	value.Msg_contents_u.close_rsp.result

#define CLOSE_C		value.Msg_contents_u.close_cnf.conn
#define CLOSE_C_RESULT	value.Msg_contents_u.close_cnf.result

#define RCLOSE_R	value.Msg_contents_u.close_req.conn

#define RCLOSE_I	value.Msg_contents_u.close_ind.conn

#define RCLOSE_S	value.Msg_contents_u.close_rsp.conn
#define RCLOSE_S_RESULT	value.Msg_contents_u.close_rsp.result

#define RCLOSE_C	value.Msg_contents_u.close_cnf.conn
#define RCLOSE_C_RESULT	value.Msg_contents_u.close_cnf.result

#define CHANGE_R	value.Msg_contents_u.change_req.conn
#define CHANGE_R_QOS	value.Msg_contents_u.change_req.qos
#define CHANGE_R_MIN	value.Msg_contents_u.change_req.min
#define CHANGE_R_NVCI	value.Msg_contents_u.change_req.num_vci
#define CHANGE_R_MVCI	value.Msg_contents_u.change_req.min_vci

#define CHANGE_S	value.Msg_contents_u.change_rsp.conn
#define CHANGE_S_RESULT	value.Msg_contents_u.change_rsp.result
#define CHANGE_S_QOS	value.Msg_contents_u.change_rsp.qos
#define CHANGE_S_FVCI	value.Msg_contents_u.change_rsp.first_vpvc
#define CHANGE_S_LVCI	value.Msg_contents_u.change_rsp.last_vpvc

#define RELOCATE_R	value.Msg_contents_u.relocate_req.conn
#define RELOCATE_R_NEWP	value.Msg_contents_u.relocate_req.new_path
#define RELOCATE_R_PREF	value.Msg_contents_u.relocate_req.pref

#define RELOCATE_S	value.Msg_contents_u.relocate_rsp.conn
#define RELOCATE_S_RESULT	value.Msg_contents_u.relocate_rsp.result
#define RELOCATE_S_VCI	value.Msg_contents_u.relocate_rsp.new_vci

#define STATUS_R_EPOCH	value.Msg_contents_u.status_req.host_epoch

#define STATUS_I_EPOCH	value.Msg_contents_u.status_ind.switch_epoch
#define STATUS_I_HOST	value.Msg_contents_u.status_ind.host_addr
#define STATUS_I_SWITCH	value.Msg_contents_u.status_ind.switch_addr

#define STATUS_S_EPOCH	value.Msg_contents_u.status_rsp.host_epoch
#define STATUS_S_HOST	value.Msg_contents_u.status_rsp.host_addr

#define MAP_I_NUM	value.Msg_contents_u.map_ind.num_links
#define MAP_I_LINK	value.Msg_contents_u.map_ind.links

#define NSAP_I_NUM	value.Msg_contents_u.nsap_ind.num_links
#define NSAP_I_LINK	value.Msg_contents_u.nsap_ind.links

#define HELLO_LOGNODE    value.Msg_contents_u.hello_ind.lognode
#define HELLO_LOGPORT    value.Msg_contents_u.hello_ind.logport
#define HELLO_COST       value.Msg_contents_u.hello_ind.cost
#define HELLO_UBR_VCS    value.Msg_contents_u.hello_ind.ubr_vcs
#define HELLO_CBR_CAP    value.Msg_contents_u.hello_ind.cbr_cap
#define HELLO_CBR_FIFO   value.Msg_contents_u.hello_ind.cbr_fifo
#define HELLO_VBR_CAP    value.Msg_contents_u.hello_ind.vbr_cap
#define HELLO_VBR_FIFO   value.Msg_contents_u.hello_ind.vbr_fifo
#define HELLO_CAPSET     value.Msg_contents_u.hello_ind.capset


#define QUERY_R_CONN	value.Msg_contents_u.query_req.conn
#define QUERY_R_ACTION	value.Msg_contents_u.query_req.type

#define QUERY_S_CONN	value.Msg_contents_u.query_rsp.conn
#define QUERY_S_STATE	value.Msg_contents_u.query_rsp.state
#define QUERY_S_ACTION	value.Msg_contents_u.query_rsp.type
#define QUERY_S_DATA	value.Msg_contents_u.query_rsp.data


#endif /* !_FORE_MSG_H */
