#! /usr/bin/env python

# Provides a set of python classes that, when instantiated and annotated
# by a GUI description, will generate code for generating a simple CRend
# based user interface for python

import pwd, socket, time, os


print 'Gui compiler version 1'
instructions = """

To use this compiler, write a python file that starts:

from guicompiler import *

then, instantiate a Gui object like this:

gui = Gui()

At the end of the file, write:

gui.go()


Then, you may use the following annotations to effect the generated GUI code:

gui.fork_events_thread = 1  to add code to the init function to fork a thread to
handle all events (default)

gui.fork_events_thread = 0  to disable the event thread fork


"""

NoPrefixForGui = "NoPrefixForGui"

def gendetails():
    (uid,_,_,_,gcos,_,_) = pwd.getpwuid(os.getuid())
    return ' by '+uid+'('+gcos+')' + ' on '+socket.gethostname() + ' at '+time.ctime( time.time() )

class Gui:
    def __init__(self):
	self.prefix = None
	self.windows = []
	self.fork_events_thread = 1
    
    def new_window(self, win):
	self.windows.append(win)

    def go(self):
	if not self.prefix:
	    raise NoPrefixForGui
	co = open(self.prefix+'_gui.c', 'w')
	ho = open(self.prefix+'_gui.h', 'w')
	co.write('/* autogenerated with  guicompiler.py '+gendetails()+' */\n')
	ho.write('/* autogenerated with  guicompiler.py '+gendetails()+' */\n')
	co.write('/* DO NOT EDIT; hack guicompiler instead */\n')
	ho.write('/* DO NOT EDIT; hack guicompiler instead */\n')
	ho.write("""
#include <nemesis.h>
#include <CRend.ih>
#include <CRendDisplay.ih>
#include <CRendDisplayMod.ih>
#include <CRendPixmap.ih>
#include <IDCMacros.h>
typedef struct {
  CRendDisplay_clp display;
  WS_Buttons oldbuttons, newbuttons;
  void *data;
  WS_clp ws;
""")
        for win in self.windows:
	    win.writehline(ho)
	ho.write(""" 
} """+self.prefix+"""_gui_st;

void """+self.prefix+"""_init(void *data, """+self.prefix + '_gui_st'+""" *st);
bool_t """+self.prefix+"""_handle_event("""+self.prefix + '_gui_st'+""" *st, WS_Event *ev);
void  """+self.prefix+"""_handle_events("""+self.prefix + '_gui_st'+""" *st);
void """+self.prefix+"""_handle_events_thread("""+self.prefix + '_gui_st'+""" *st);

"""
)

        co.write('#include "'+self.prefix+'_gui.h"\n')
	co.write("""
#include <stdio.h>
void """+self.prefix+"""_init(void *data, """+self.prefix + '_gui_st'+""" *st) {
  CRendDisplayMod_clp displaymod;

  displaymod =NAME_FIND("modules>CRendDisplayMod", CRendDisplayMod_clp);
  st->data = data;
  st->display = CRendDisplayMod$OpenDisplay(displaymod, "");
  st->ws = CRendDisplay$GetWS(st->display);
""")
	for win in self.windows:
	    win.writeinitcode(co)
	
	if self.fork_events_thread:
	    co.write("""
  /* forking thread to handle crend events */
  Threads$Fork(Pvs(thds), """+self.prefix+"""_handle_events_thread, st, 0);
""")
	co.write("""
}

/* attempt to deal with an event */
/* return true if the event was handled */
bool_t """+self.prefix+"""_handle_event("""+self.prefix + '_gui_st'+""" *st,
    WS_Event *ev) {
    if (ev->d.tag ==  WS_EventType_Mouse) {
      st->oldbuttons = st->newbuttons;
      st->newbuttons = ev->d.u.Mouse.buttons;
   }

""")
	for win in self.windows:
	    win.writehandlecode(co, ho)
	co.write("""

  return 0;
}

/* handle all pending events */
void """+self.prefix+"""_handle_events("""+self.prefix + '_gui_st'+""" *st) {

    
  while (CRendDisplay$EventsPending(st->display)) {
    WS_Event ev;
    CRendDisplay$NextEvent(st->display, &ev);

    """+self.prefix+"""_handle_event(st, &ev);
  }
}

/* event handling thread */
void """+self.prefix+"""_handle_events_thread("""+self.prefix + '_gui_st'+""" *st) {
    
  while (1) {
    WS_Event ev;
    CRendDisplay$NextEvent(st->display, &ev);

    """+self.prefix+"""_handle_event(st, &ev);
  }
}


/* end of autogenerated file */
""")  

	co.close()
	ho.write('/* end of autogenerated file */')

	ho.close()



class Window:
    def __init__(self, gui):
	self.gui = gui
	self.gui.new_window(self)
	self.handlers = { 'mouse_click' : []}
    def writehline(self, o):
	o.write('  CRend_clp '+self.name+';\n')
	o.write('  WS_WindowID '+self.name+'id;\n')

class FixedWindow(Window):
    def __init__(self, gui):
	Window.__init__(self, gui)
	self.background_ppm = None
	self.title = None
    def writeinitcode(self, o):
	o.write("""
  st->"""+self.name+""" = CRendDisplay$CreateWindow(st->display, """+
		`self.pos[0]`+','+`self.pos[1]`+','+
		`self.size[0]`+','+`self.size[1]`+""");
  st->"""+self.name+"""id = CRend$GetID(st->"""+self.name+""");
""")
	if self.background_ppm:
	    o.write("""
  {
    FILE *f;
    CRend_clp ppmcrend;
    int width, height, stride;
    void *data;
    
    f=fopen("""+'"'+self.background_ppm+'","r")'+""";

    ppmcrend = CRendPixmap$NewPPM(NAME_FIND("modules>CRendPixmap", CRendPixmap_clp), f->rd);
    fclose(f);
    data = (void*) CRend$GetPixelData(ppmcrend, &stride);
    width = CRend$GetWidth(ppmcrend); height = CRend$GetHeight(ppmcrend);
    CRend$DrawPixmap(st->"""+self.name+""", 0,0, data, width, height, stride);
    CRend$Close(ppmcrend);
  }

""")  
        if type(self.title) == type(''):
	    o.write('  WS$SetTitle(st->ws, st->'+self.name+'id, "'+self.title+'");\n')
        o.write("""
  CRend$Map(st->"""+self.name+""");
""")
  
    def writehandlecode(self, o, ho):
	o.write("""
  if (ev->d.tag == WS_EventType_Expose) {
    if (ev->w == st->"""+self.name+"""id) {
      CRend$ExposeRectangle(st->"""+self.name+""", 
      ev->d.u.Expose.x1, ev->d.u.Expose.y1,
      ev->d.u.Expose.x2 - ev->d.u.Expose.x1,
      ev->d.u.Expose.y2 - ev->d.u.Expose.y1);
      CRend$Flush(st->"""+self.name+""");
      return 1;
    }
  }

""")
        for (button, pos, size, operation) in self.handlers['mouse_click']:
	    o.write("""
  if (ev->d.tag == WS_EventType_Mouse)
    if (ev->w == st->"""+self.name+"""id && 
    ev->d.u.Mouse.x >= """ + `pos[0]`+ """ && ev->d.u.Mouse.x <= """ + `(pos[0]+size[0])`+""" &&
    ev->d.u.Mouse.y >= """ + `pos[1]`+ """ && ev->d.u.Mouse.y <= """ + `(pos[1]+size[1])`+""") {
    if (SET_IN(st->newbuttons, WS_Button_"""+button+""") &&
        !SET_IN(st->oldbuttons, WS_Button_"""+button+""")) {
	"""+operation+"""(st->data, ev);
    }
  }
""")
            ho.write('void '+operation+'(void *data, WS_Event *ev);\n')


	

