#! /usr/bin/env python
import blueprint, string
db = blueprint.db

o = open('standard.rc.d', 'w')
o.write('standard.rc : '+string.join(blueprint.deps, ' ')+'\n')
o.close()

import string

def remove_postfixes(str):
    if type(str) == type('') and str[-1] in ['k', 'K']: return `eval(str[:-1])*1024`
    if type(str) == type('') and str[-1] in ['m', 'M']: return `eval(str[:-1])*1024`
    return `eval(str)`

print """
# This file is autogenerated by boot/initscripts/standard.rc.py
# This file is included by init.rc as soon as it has its hands on an
# initial filesystem. The network may or may not be configured, depending
# on whether the initial filesystem is NFS.


pvs>out$PutStr["Executing standard.rc\\n"]
"""
#pvs>out$PutStr["Mounting dev>hda partition 2 as local\n"]
#mounts>local=modules>ext2fs$SimpleMount[dev>hda,2]

for item in db.values():
    if item.get_class() == 'module':
        binobjname = item.get_binary_object_name()
        if item['value'] == 2 and not(item.options.has_key('donotload') and item.options['donotload']):
            print 'pvs>out$PutStr["Loading '+binobjname+'\\n"]'
            print 'l$Load["'+binobjname+'"]'

print 'svc>program_environments = <| |>'
for item in db.values():
    binobjname = item.get_binary_object_name()
    if not binobjname: continue
    contextstuff = {}    
    if item.options.has_key('qos'):
        for (new, old) in [ ('p', 'period'), ('s', 'slice'), ('l', 'latency')]:
            oldval = item['qos'][old]
            # hack; get rid of trails of zero values
            if len(oldval) == 3 and oldval[0] == '0' and oldval[2] == 's':
                oldval = '0'
            contextstuff['qos>cpu>'+new] = oldval
        contextstuff['qos>cpu>x'] = item['qos']['extra'] and 'true' or 'false'
    if item.options.has_key('env'):
        env = item.options['env']
        for (old, new) in [('defstack', 'b_env>defStackWords'),('heap', 'b_env>pHeapWords')]:
            if env.has_key(old):
                contextstuff[new] = remove_postfixes(env[old])
        if env.has_key('kernel'):
            contextstuff['qos>cpu>k'] = item['env']['kernel'] and 'true' or 'false'
        for key in ['actheap', 'sysheap']:
            if env.has_key(key):
                contextstuff['qos>aHeapWords'] = remove_postfixes(env[key])
        for key in env.keys():
            tgtname = key
            if not tgtname in ['defstack', 'heap', 'sysheap', 'actheap']:
                if type(env[key]) == type(''):
                    contextstuff[tgtname] = env[key]
                else:
                    contextstuff[tgtname] = `env[key]`
            
    if len(contextstuff.keys()) > 0:
        context_entries = []
        for key in contextstuff.keys():
            context_entries.append ( key + '=' + contextstuff[key] )
        context = string.join(context_entries, ', ')
        print 'svc>program_environments>'+binobjname+' = <| '+context+' |>'
         
print """
pvs>out$PutStr["Starting second serial driver\\n"]
# Start the serial driver for the second port
dev>serial1=modules>SerialMod$New["serial1",0x2f8,3,false]

pvs>out$PutStr["Starting serial mouse driver\\n"]
# Run the serial mouse driver
modules>SerialMouse$Apply[]

# XXX hack: put the default directory in the namespace
pvs>out$PutStr["Performing home directory hack\\n"]

RootC>initfs = nfs

# Fire up a nash (which will create a _new_ instance of Clanger, and
# read profile.nash from the current directory)
n = modules>NashMod$New[]

# Source autoexec.nash, which will fire up nashes that the user will
# interact with.
n$ExecuteString["source autoexec.nash"]

# When we fall off the end here, we return to init.rc. It will probably
# open dev>serial0>rd and wait for the user.
"""




