#! /usr/bin/env python
import blueprint, string
db = blueprint.db

o = open('init.rc.d', 'w')
o.write('init.rc : '+string.join(blueprint.deps, ' ')+'\n')
o.close()

print """
# This file is autogenerated; edit init.rc.py instead
# system startup script
# modified by SDE for released loader binary:
#  mount an ext2fs filesystem from the partition specified on the commandline
"""


if db.has_key('vgaconsole') and db['vgaconsole']['value'] == 3: print """
# Sort out local console display
c=modules>VGAConsole$New[753664,25,80,25,80,0,0,modules>Beep]
c$PutStr["Starting Local console\\n "]
c$PutStr[proc>k_ident]
# Display banner - stored as a blob
cl=modules>RdWrMod$NewJoin[pvs>heap,256,modules>RdWrMod$GetBlobRd[blob>banner,pvs>heap],c,false]
cl$Apply[]
rm cl

dev>local_console=modules>ShmTransport$Offer[c,modules>NullIDCCallback,pvs>heap,pvs>gkpr,pvs>entry]

ConsoleControl$AddWr[c,false]
"""

if db.has_key('ns16550_serial') and db['ns16550_serial']['value'] == 3: print """
# Sort out serial output
envserial=<| qos>cpu>k=true |>
pvs>out$PutStr["Starting Serial Driver for line 0\\n "]
dev>serial0=modules>SerialMod$New["serial0", 0x3f8, 4, true]
# dev>serial1 is created from standard.rc

pvs>objs$Import[dev>serial0>wr, s]
s$PutStr["\\nSerial console: "]
s$PutStr[proc>k_ident]
s$PutStr["\\n"]
rm s

ConsoleControl$AddOffer[dev>serial0>wr,false]
"""

print """
pvs>out$PutStr["Nemesis: init.rc  "]
pvs>out$PutStr[proc>k_ident]
pvs>out$PutStr["\\n"]

"""
# We only configure the network here if the init FS is NFS
if db['initmount_nfs']['value']:
	print """

###################################
# Network configuration for network filesystems:

# Run a plausable driver

# try this if you want full duplex on your 100Mbit de500:
#progs>ethde4x5>priv_root>args="de4x5-0:fdx"
# XXX it won't work if you have the rc domain outside nemesis - it will
# cause a fault
# can also say "de4x5-0:autosense=BNC" to give hints on media type
# barehands is 10Mb
# blaster is 100Mb
# grenade is 100Mb
"""

	if db.has_key('cs8900') and db['cs8900']['value'] == 3: print """
pvs>out$PutStr["Starting eth_cs8900\\n"]
spawn(progs>cs8900>cs8900$Apply[],progs>cs8900,"cs8900")
"""

	if db.has_key('ethde4x5') and db['ethde4x5']['value'] == 3: print """
pvs>out$PutStr["Starting ethde4x5\\n"]
spawn(progs>ethde4x5>ethde4x5$Apply[],"de4x5",progs>ethde4x5)
"""

	if db.has_key('eth3c509') and db['eth3c509']['value'] == 3: print """
pvs>out$PutStr["Starting eth3c509\\n"]
spawn(progs>eth3c509>eth3c509$Apply[],"3c509",progs>eth3c509)
"""

	if db.has_key('ethlance') and db['ethlance']['value'] == 3: print """
pvs>out$PutStr["Starting ethlance\\n"]
spawn(progs>ethlance>ethlance$Apply[],"lance",progs>ethlance)
"""

if db['initmount_nfs']['value'] or db['initmount_tmpfs']['value']: print """
pvs>out$PutStr["Starting IP configuration\\n"]

# create the IP configuration / flowmanager domain
envip>qos>cpu = <| p = 2ms, s=10us, l=2ms, x=true, k=false, neps=256 |>
envip>qos>aHeapWords=8192
envip>b_env>pHeapWords=32768

spawn(modules>IPConfMod$Apply[],"flowman",envip)
pvs>objs$Import[svc>net>IPConf, ip]

# Capture the first ethernet interface to be probed and bootp on it
# XXX this is a hack!
card = ip$OpenCard["de4x5-0,3c509-0,eth0"]

[timedout, ipaddr, netmask, gateway] = ip$bootp[card, 60]

# bind its IP address to it
intf = ip$NewInterface[card, "eth0", ipaddr, netmask]

# Create a default IP host, and export it to the world
iphost = ip$NewIPHost["iphost-default"]

# Add the interface to it
ip$AddInterface[iphost, intf]

# to do bootp on a second card, use something like:
#card2 = ip$OpenCard["de4x5-1"]
#[timedout, ipaddr, netmask, gateway] = ip$bootp[card2, 60]
#intf2 = ip$NewInterface[card2, "eth1", ipaddr, netmask]
#ip$AddInterface[iphost, intf2]

# routes: (order is important!)
# our default route out of the subnet is via gateway
ip$AddRoute[iphost, "0.0.0.0", "0.0.0.0", intf, gateway]
# and the route to the local subnet is via intf, with no gateway required
ip$AddRoute[iphost, ipaddr, netmask, intf, "0.0.0.0"]
"""

print """
###################################
# Filesystem configuration:
"""
initialfs = None

if db['initmount_nfs']['value']:
	initialfs = 'nfs'
	print """
# NFS filesystem selected as init
pvs>out$PutStr["Starting NFS\\n"]
nfs             = <| |>
nfs>mounter      = modules>NFS
nfs>local        = false
nfs>host         = modules>StringUtil$LongCardToIP[pvs>heap, svc>net>eth0>swapserver]
nfs>mountpoint   = "/"
nfs>pwd_string   = modules>StringUtil$Cat[pvs>heap, svc>net>eth0>bootfile, ".nfs"]
nfs>client_offer = nfs>mounter$SimpleMount[nfs>host, nfs>mountpoint]

mounts>init = nfs>client_offer
env>fs_cert>init = nfs>pwd_string
"""
 
if db['initmount_tmpfs']['value']:
	initialfs = 'tmpfs'
	print """
pvs>out$PutStr["Starting tmpfs\\n"]
tmpfs             = <| |>
tmpfs>mounter      = modules>NFS
tmpfs>local        = false
tmpfs>host         = modules>StringUtil$LongCardToIP[pvs>heap, svc>net>eth0>swapserver]
tmpfs>mountpoint   = "/tmp/syscore"
tmpfs>pwd_string   = "smh22"
tmpfs>client_offer = tmpfs>mounter$SimpleMount[tmpfs>host, tmpfs>mountpoint]
# store the writable network file system in svc
svc>tmpfs          = tmpfs
"""


if db.has_key('ide') and db['ide']['value']:
	print """
pvs>out$PutStr["Starting ide\\n"]
spawn(progs>ide>ide$Apply[],"ide",progs>ide)
#while (pvs>root$Get[ "dev>hda", dummy ] == false) pause 100ms
"""

if db['initmount_ext2fs_ide']['value']:
	initialfs = 'lfs'
	print """
# Warning: Check the partition before enabling this code.
#          Change the pwd as well.
pvs>out$PutStr["Starting ext2fs\\n "]
lfs             = <| |>
lfs>mounter      = modules>ext2fs
lfs>local        = true
foo=modules>StringUtil$Cat[pvs>heap,"MergeC>dev>",proc>cmdline>rootd]
FrontC$Get[foo,drive]
rm foo
lfs>drive        = drive
lfs>partition    = modules>StringUtil$StringToCardinal[proc>cmdline>rootp]
lfs>pwd_string   = proc>cmdline>dir
lfs>client_offer = lfs>mounter$SimpleMount[lfs>drive, lfs>partition]

mounts>init = lfs>client_offer
env>fs_cert>init = lfs>pwd_string
"""

if db['initmount_swapfs_ide']['value']:
	initialfs = 'swapfs'
	print """
# Warning: Check the partition before enabling this code.
#          Change the pwd as well.
pvs>out$PutStr["Starting SWAPFS (IDE)\\n"]
swapfs          = <| |>
swapfs>mounter      = modules>swapfs
swapfs>local        = true
swapfs>ide          = true
swapfs>drive        = dev>hda
swapfs>partition    = 1
swapfs>pwd_string   = "UNUSED"
swapfs>client_offer = swapfs>mounter$New[swapfs>drive, swapfs>partition]

# store the swap file system in svc
svc>swapfs          = swapfs
"""

if db.has_key('ncr') and db['ncr']['value']: print """
pvs>out$PutStr["Starting NCR SCSI driver\\n"]
run progs>ncr>ncr progs>ncr
while (pvs>root$Get[ "dev>sda", dummy ] == false) pause 100ms
"""


if db['initmount_swapfs_scsi']['value']:
	initialfs = 'swapfs'
	print """
# Warning: Check the partition before enabling this code.
#          Change the pwd as well.
pvs>out$PutStr["Starting SWAPFS SCSI\\n"]
swapfs          = <| |>
swapfs>mounter      = modules>swapfs
swapfs>local        = true
swapfs>ide          = false
swapfs>drive        = dev>sda
swapfs>partition    = 2
swapfs>pwd_string   = "UNUSED"
swapfs>client_offer = swapfs>mounter$New[swapfs>drive, swapfs>partition]

# store the swap file system in svc
svc>swapfs          = swapfs
"""

if db['initmount_ext2fs_scsi']['value']:
	initialfs = 'sfs'
	print """
pvs>out$PutStr["Starting EXT2FS SCSI\\n"]
sfs             = <| |>
sfs>mounter      = modules>ext2fs
sfs>local        = true
sfs>drive        = dev>sda
sfs>partition    = 2
sfs>pwd_string   = "local/scratch/nemesis-root"
sfs>client_offer = sfs>mounter$SimpleMount[sfs>drive, sfs>partition]

mounts>init = sfs>client_offer
env>fs_cert>init = sfs>pwd_string
"""

if initialfs: print 'initialfs='+initialfs+'\n'
if db['bootloader']['value']: print """
pvs>out$PutStr["\\n-- Nemesis boot loader started\\n\\n"]
penv>nash = <| qos>cpu = <| k=true, x=true |> |>
penv>nash>b_env>fs_cert>init = env>fs_cert>init
spawn(modules>PS2$Apply[],"ps2",penv>nash)
#run modules>UDPnash penv>nash
run modules>Serialnash penv>nash
run modules>TTYnash penv>nash
#pvs>out=modules>NullWr
#pvs>err=modules>NullWr
#nash = modules>NashMod$New[]
#nash$ExecuteString["source autoexec.bootloader.nash"]
"""
else: print """



pvs>out$PutStr["Reading standard.rc\\n"]

l = modules>CExec

standardrc = l$Open["standard.rc"]
include standardrc
rm standardrc

#pvs>out$PutStr["End of init.rc - reading from serial0\\n"]
include dev>serial0>rd
"""
