/* PIC 14 Instruction Set from MicroChip, encoded for Mixerton ISS 
 *
 * This file $ID: $
 *
 * CBG Lambda Lambdem - PIC MicroChip version
 * Microcontroller emulator and model checker
 *
 * (C) 1998-2006 DJ Greaves, Mixerton ST.
 *
 */
#ifndef PIC14ISS_H
#define PIC14ISS_H


/* PIC 14 Instruction Set from MicroChip, encoded for Mixerton ISS */

P14(0x2800, 0x3800, "GOTO",  11,  "Goto address k",      SETPCK11, PHI, "");
P14(0x1000, 0x3c00, "BCF",   0xFB,  "Bit clear f",        MOV(L_AND(FF14R, L_NEG((BIT(BB14)))), FF14W), PHI, "");
P14(0x1400, 0x3c00, "BSF",   0xFB,  "Bit set f",          MOV(L_OR(FF14R,BIT(BB14)), FF14W), PHI, ""); P14(0x0080, 0x3F80, "MOVWF",  0xFF, "Move W to f",       MOVz8(W8, FF14W), PHI, "z");
 
P14(0x3000, 0x3F00, "MOVLW", 8,  "Load immediate",       MOV(K8, W8), PHI, "");

#if 1


P14(0x0700, 0x3F00, "ADDWF",  0xFD, "Add W and f",        MOV14zc8(L_ADD(FF14R,W8)), PHI, "c,dc,z"); 


P14(0x0500, 0x3F00, "ANDWF",  0xFD, "AND W and f",        MOV14z8(L_AND(W8,FF14R)), PHI, "z");
P14(0x0180, 0x3F00, "CLRF",  0xFF,  "Clear f",            MOV(L_ZERO, FF14W), PHI, "z");


P14(0x0100, 0x3FFF, "CLRW",  0,  "Clear W",               MOV(L_ZERO, W8), PHI, "z");
P14(0x0900, 0x3F00, "COMF",   0xFD, "Complement f",       MOV14z8(L_NEG(FF14R)), PHI, "z");
P14(0x0300, 0x3F00, "DECF",   0xFD, "Decrement f",        MOV14z8(L_DEC(FF14R)), PHI, "z");
P14(0x0b00, 0x3F00, "DECFSZ", 0xFD, "Decrement f, skipz", MOV14SKIPZ(L_DEC(FF14R)), PHI, "");
P14(0x0A00, 0x3F00, "INCF",   0xFD, "Increment f",        MOV14z8(L_INC(FF14R)), PHI, "z");
P14(0x0F00, 0x3F00, "INCFSZ", 0xFD, "Increment f, skipz", MOV14SKIPZ(L_INC(FF14R)), PHI, "");
P14(0x0400, 0x3F00, "IORWF",  0xFD, "OR W and f",         MOV14z8(L_OR(W8,FF14R)), PHI, "z");
P14(0x0800, 0x3F00, "MOVF",   0xFD, "Move f to d",       MOV14(FF14R), PHI, "");
/*  D=1 means store back to  file instead of updating W8 */
P14(0x0800, 0x3F80, "MOVFW",  0xFF, "Load f to W",        MOV(FF14R, W8), PHI, ""); 





P14(0x0000, 0x3FFF, "NOP",   0,  "No operation",         PHI, PHI, "");  
P14(0x0D00, 0x3F00, "RLF",   0xFD, "Rotate left",        MOV14z8(L_OR(L_LSHIFT(CC,L_ONE),CC)), MOV(L_RSHIFT(FF14R,L_INT(7)), CC), "z");
P14(0x0C00, 0x3F00, "RRF",    0xFD, "Rotate right",       MOV14(L_OR(L_RSHIFT(FF14R,L_ONE),L_LSHIFT(CC,L_INT(7)))), MOV(FF14R, CC), "");
P14(0x0200, 0x3F00, "SUBWF",  0xFD, "Subtract W from f",  MOV14zc8(L_SUB(FF14R,W8)), PHI, "c,dc,z"); 
P14(0x0E00, 0x3F00, "SWAPF",  0xFD, "Swap halves f",      MOV14(L_OR(L_RSHIFT(FF14R, L_INT(4)), L_LSHIFT(FF14R , L_INT(4)))), PHI, "")
P14(0x0600, 0x3F00, "XORWF",  0xFD, "Xor W and f",        MOV14z8(L_XOR(W8,FF14R)), PHI, "z");




P14(0x1800, 0x3c00, "BTFSC", 0xFB,  "Bit test, skipc",    L_COND(FB14, INCINC_PC, L_SKIP), PHI, "");
P14(0x1c00, 0x3c00, "BTFSS", 0xFB,  "Bit test, skips",    L_COND(FB14, L_SKIP, INCINC_PC), PHI, "");  



P14(0x3E00, 0x3F00, "ADDLW", 8,  "Add immediate",        MOVz8(L_ADD(K8,W8), W8), PHI, "z");
P14(0x3900, 0x3F00, "ANDLW", 8,  "AND immediate",        MOVz8(L_AND(K8,W8), W8), PHI, "z");
P14(0x2000, 0x3800, "CALL",  11,  "Call subroutine",     PUSHPC, SETPCK11, ""); 
P14(0x0064, 0x3FFF, "CLRWDT",0,  "Clear watchdog timer", MOV(L_ZERO,WDT), MOV(L_ZERO,PRESCALE), "");

P14(0x3800, 0x3F00, "IORLW", 8,  "OR immediate",         MOVz8(L_OR(K8,W8), W8), PHI, "z");




P14(0x0009, 0x3FFF, "RETFIE",0,  "Return from int",      POPPC, MOV(L_ONE, GIE), "");
P14(0x0008, 0x3FFF, "RETURN",0,  "Return",               POPPC, PHI,  "");
P14(0x3400, 0x3F00, "RETLW", 8,  "Return with literal",  MOV(K8, W8), POPPC, "");
P14(0x0063, 0x3FFF, "SLEEP", 0,  "Standby Mode",         MOV(L_INT(0), WDT), MOV(L_INT(0), PD), "");
P14(0x3C00, 0x3F00, "SUBLW", 8,  "Sub immediate",        MOVz8(L_SUB(K8,W8), W8), PHI, "z");
P14(0x3A00, 0x3F00, "XORLW", 8,  "XOR immediate",        MOVz8(L_XOR(K8,W8), W8), PHI, "z");
#endif    
#endif    
// eof cbg
