//
// ESL Modelling : Test application or device driver fragment: illustrating c-preprocessor calls to implement direct calling of behavioural model of a device.
// The device in this case is a co-processor for Ethernet CRC generation.
//

// Compile this with -DCRC_DIRECT_BEVMODEL when running with direct calls.

#include <stdio.h>
#include <stdint.h>
#include "../ethercrc_memmap.h"

#ifdef CRC_DIRECT_BEVMODEL
#include "../ethercrc_bev_core.h"
#endif

 
// Test application: canned Ethernet test data.
uint8_t test_data[] = 
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
    0x00, 0x20, 0xaf, 0xb7, 0x80, 0xB8, 
    0x08, 0x06, 

    0x00, 0x01, 0x08, 0x00, 
    0x06, 0x04, 0x00, 0x01, 
    0x00, 0x20, 0xaf, 0xb7, 
    0x80,  0xB8, 0x80, 0xE8, 
    0x0f, 0x94, 0x00, 0x00, 
    0x00,  0x00, 0x00, 0x00, 
    0x80,  0xE8, 0x0f, 0xDe, 

    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde,

    0x9e, 0xd2,  0xc2, 0xaf 
};



#ifdef CRC_DIRECT_BEVMODEL
#define CRC_RESET_OPERATION(BASE)      ((ethercrc_bev_core *)BASE)->reset_operation();
#define CRC_PROCESS_BYTE(BASE, DATA)   ((ethercrc_bev_core *)BASE)->process_byte(DATA);
#define CRC_PROCESS_32BE(BASE, DATA)   ((ethercrc_bev_core *)BASE)->process_word32_be(DATA);
#define CRC_READ_CRC(BASE)             ((ethercrc_bev_core *)BASE)->read_crc()
#define CRC_READ_CONTROL(BASE)         ((ethercrc_bev_core *)BASE)->read_control()
#else
#define CRC_RESET_OPERATION(BASE)      ((volatile int *)BASE)[CRC_RESET_REG] = 1;
#define CRC_PROCESS_BYTE(BASE, DATA)   ((volatile int *)BASE)[CRC_DATA_8_PROCESS_REG] = DATA;
#define CRC_PROCESS_32BE(BASE, DATA)   ((volatile int *)BASE)[CRC_DATA_32_PROCESS_BE_REG] = DATA;
#define CRC_READ_CRC(BASE)             (((volatile int *)BASE)[CRC_READ_REG])
#define CRC_READ_CONTROL(BASE)         (((volatile int *)BASE)[CRC_CONTROL_REG])
#endif


//
// A test application that may be run on the OR1K or on the native workstation.
//
int main()
{
#ifdef CRC_DIRECT_BEVMODEL
  ethercrc_bev_core *crc_unit0 = new ethercrc_bev_core();
#else
  const int crc_unit0 = 0xE0001000; // Or whatever - base address of device in memory map.
#endif
  CRC_RESET_OPERATION(crc_unit0);
  int i;
  int repeat;
  for (repeat=0;repeat<1000;repeat++)
    {
      for (i=0;i<64; i++)
	{
	  uint8_t dd = test_data[i];
	  CRC_PROCESS_BYTE(crc_unit0, dd);
	  //printf("%02X, %02X   %08X\n", i, dd, CRC_READ_CRC(crc_unit0));
	}
    }
  printf("CRC final %x\n", CRC_READ_CRC(crc_unit0));
  return 0;
}


void _isr_routine()
{
  // unused
}
// eof
