/***************************************************************************//**
* \file cyip_flashc_v2.h
*
* \brief
* FLASHC IP definitions
*
* \note
* Generator version: 1.5.0.1286
*
********************************************************************************
* \copyright
* Copyright 2016-2019 Cypress Semiconductor Corporation
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#ifndef _CYIP_FLASHC_V2_H_
#define _CYIP_FLASHC_V2_H_

#include "cyip_headers.h"

/*******************************************************************************
*                                    FLASHC
*******************************************************************************/

#define FLASHC_FM_CTL_V2_SECTION_SIZE           0x00001000UL
#define FLASHC_V2_SECTION_SIZE                  0x00010000UL

/**
  * \brief Flash Macro Registers (FLASHC_FM_CTL)
  */
typedef struct {
  __IOM uint32_t FM_CTL;                        /*!< 0x00000000 Flash macro control */
   __IM uint32_t STATUS;                        /*!< 0x00000004 Status */
  __IOM uint32_t FM_ADDR;                       /*!< 0x00000008 Flash macro address */
  __IOM uint32_t BOOKMARK;                      /*!< 0x0000000C Bookmark register - keeps the current FW HV seq */
   __IM uint32_t GEOMETRY;                      /*!< 0x00000010 Regular flash geometry */
   __IM uint32_t GEOMETRY_SUPERVISORY;          /*!< 0x00000014 Supervisory flash geometry */
  __IOM uint32_t ANA_CTL0;                      /*!< 0x00000018 Analog control 0 */
  __IOM uint32_t ANA_CTL1;                      /*!< 0x0000001C Analog control 1 */
   __IM uint32_t RESERVED[2];
  __IOM uint32_t WAIT_CTL;                      /*!< 0x00000028 Wait State control */
   __IM uint32_t RESERVED1[2];
  __IOM uint32_t TIMER_CLK_CTL;                 /*!< 0x00000034 Timer prescaler (clk_t to timer clock frequency divider) */
  __IOM uint32_t TIMER_CTL;                     /*!< 0x00000038 Timer control */
   __OM uint32_t ACLK_CTL;                      /*!< 0x0000003C MPCON clock */
  __IOM uint32_t INTR;                          /*!< 0x00000040 Interrupt */
  __IOM uint32_t INTR_SET;                      /*!< 0x00000044 Interrupt set */
  __IOM uint32_t INTR_MASK;                     /*!< 0x00000048 Interrupt mask */
   __IM uint32_t INTR_MASKED;                   /*!< 0x0000004C Interrupt masked */
  __IOM uint32_t CAL_CTL0;                      /*!< 0x00000050 Cal control BG LO trim bits */
  __IOM uint32_t CAL_CTL1;                      /*!< 0x00000054 Cal control BG HI trim bits */
  __IOM uint32_t CAL_CTL2;                      /*!< 0x00000058 Cal control BG LO&HI trim bits */
  __IOM uint32_t CAL_CTL3;                      /*!< 0x0000005C Cal control osc trim bits, idac, sdac, itim */
  __IOM uint32_t CAL_CTL4;                      /*!< 0x00000060 Cal Control Vlim, SA, fdiv, reg_act */
  __IOM uint32_t CAL_CTL5;                      /*!< 0x00000064 Cal control */
  __IOM uint32_t CAL_CTL6;                      /*!< 0x00000068 SA trim LP/ULP */
  __IOM uint32_t CAL_CTL7;                      /*!< 0x0000006C Cal control */
   __IM uint32_t RESERVED2[4];
  __IOM uint32_t RED_CTL01;                     /*!< 0x00000080 Redundancy Control normal sectors 0,1 */
  __IOM uint32_t RED_CTL23;                     /*!< 0x00000084 Redundancy Control normal sectors 2,3 */
  __IOM uint32_t RED_CTL45;                     /*!< 0x00000088 Redundancy Control normal sectors 4,5 */
  __IOM uint32_t RED_CTL67;                     /*!< 0x0000008C Redundancy Control normal sectors 6,7 */
  __IOM uint32_t RED_CTL_SM01;                  /*!< 0x00000090 Redundancy Control special sectors 0,1 */
   __IM uint32_t RESERVED3;
  __IOM uint32_t RGRANT_DELAY_PRG;              /*!< 0x00000098 R-grant delay for program */
   __IM uint32_t RESERVED4;
  __IOM uint32_t PW_SEQ12;                      /*!< 0x000000A0 HV Pulse Delay for seq 1&2 pre */
  __IOM uint32_t PW_SEQ23;                      /*!< 0x000000A4 HV Pulse Delay for seq2 post & seq3 */
  __IOM uint32_t RGRANT_SCALE_ERS;              /*!< 0x000000A8 R-grant delay scale for erase */
  __IOM uint32_t RGRANT_DELAY_ERS;              /*!< 0x000000AC R-grant delay for erase */
   __IM uint32_t RESERVED5[467];
  __IOM uint32_t FM_PL_WRDATA_ALL;              /*!< 0x000007FC Flash macro write page latches all */
  __IOM uint32_t FM_PL_DATA[256];               /*!< 0x00000800 Flash macro Page Latches data */
   __IM uint32_t FM_MEM_DATA[256];              /*!< 0x00000C00 Flash macro memory sense amplifier and column decoder data */
} FLASHC_FM_CTL_V2_Type;                        /*!< Size = 4096 (0x1000) */

/**
  * \brief Flash controller (FLASHC)
  */
typedef struct {
  __IOM uint32_t FLASH_CTL;                     /*!< 0x00000000 Control */
  __IOM uint32_t FLASH_PWR_CTL;                 /*!< 0x00000004 Flash power control */
  __IOM uint32_t FLASH_CMD;                     /*!< 0x00000008 Command */
   __IM uint32_t RESERVED[165];
  __IOM uint32_t ECC_CTL;                       /*!< 0x000002A0 ECC control */
   __IM uint32_t RESERVED1[3];
  __IOM uint32_t FM_SRAM_ECC_CTL0;              /*!< 0x000002B0 eCT Flash SRAM ECC control 0 */
  __IOM uint32_t FM_SRAM_ECC_CTL1;              /*!< 0x000002B4 eCT Flash SRAM ECC control 1 */
   __IM uint32_t FM_SRAM_ECC_CTL2;              /*!< 0x000002B8 eCT Flash SRAM ECC control 2 */
  __IOM uint32_t FM_SRAM_ECC_CTL3;              /*!< 0x000002BC eCT Flash SRAM ECC control 3 */
   __IM uint32_t RESERVED2[80];
  __IOM uint32_t CM0_CA_CTL0;                   /*!< 0x00000400 CM0+ cache control */
  __IOM uint32_t CM0_CA_CTL1;                   /*!< 0x00000404 CM0+ cache control */
  __IOM uint32_t CM0_CA_CTL2;                   /*!< 0x00000408 CM0+ cache control */
   __IM uint32_t RESERVED3[13];
   __IM uint32_t CM0_CA_STATUS0;                /*!< 0x00000440 CM0+ cache status 0 */
   __IM uint32_t CM0_CA_STATUS1;                /*!< 0x00000444 CM0+ cache status 1 */
   __IM uint32_t CM0_CA_STATUS2;                /*!< 0x00000448 CM0+ cache status 2 */
   __IM uint32_t RESERVED4[5];
  __IOM uint32_t CM0_STATUS;                    /*!< 0x00000460 CM0+ interface status */
   __IM uint32_t RESERVED5[7];
  __IOM uint32_t CM4_CA_CTL0;                   /*!< 0x00000480 CM4 cache control */
  __IOM uint32_t CM4_CA_CTL1;                   /*!< 0x00000484 CM4 cache control */
  __IOM uint32_t CM4_CA_CTL2;                   /*!< 0x00000488 CM4 cache control */
   __IM uint32_t RESERVED6[13];
   __IM uint32_t CM4_CA_STATUS0;                /*!< 0x000004C0 CM4 cache status 0 */
   __IM uint32_t CM4_CA_STATUS1;                /*!< 0x000004C4 CM4 cache status 1 */
   __IM uint32_t CM4_CA_STATUS2;                /*!< 0x000004C8 CM4 cache status 2 */
   __IM uint32_t RESERVED7[5];
  __IOM uint32_t CM4_STATUS;                    /*!< 0x000004E0 CM4 interface status */
   __IM uint32_t RESERVED8[7];
  __IOM uint32_t CRYPTO_BUFF_CTL;               /*!< 0x00000500 Cryptography buffer control */
   __IM uint32_t RESERVED9[31];
  __IOM uint32_t DW0_BUFF_CTL;                  /*!< 0x00000580 Datawire 0 buffer control */
   __IM uint32_t RESERVED10[31];
  __IOM uint32_t DW1_BUFF_CTL;                  /*!< 0x00000600 Datawire 1 buffer control */
   __IM uint32_t RESERVED11[31];
  __IOM uint32_t DMAC_BUFF_CTL;                 /*!< 0x00000680 DMA controller buffer control */
   __IM uint32_t RESERVED12[31];
  __IOM uint32_t EXT_MS0_BUFF_CTL;              /*!< 0x00000700 External master 0 buffer control */
   __IM uint32_t RESERVED13[31];
  __IOM uint32_t EXT_MS1_BUFF_CTL;              /*!< 0x00000780 External master 1 buffer control */
   __IM uint32_t RESERVED14[14879];
        FLASHC_FM_CTL_V2_Type FM_CTL;           /*!< 0x0000F000 Flash Macro Registers */
} FLASHC_V2_Type;                               /*!< Size = 65536 (0x10000) */


/* FLASHC_FM_CTL.FM_CTL */
#define FLASHC_FM_CTL_V2_FM_CTL_FM_MODE_Pos     0UL
#define FLASHC_FM_CTL_V2_FM_CTL_FM_MODE_Msk     0xFUL
#define FLASHC_FM_CTL_V2_FM_CTL_FM_SEQ_Pos      8UL
#define FLASHC_FM_CTL_V2_FM_CTL_FM_SEQ_Msk      0x300UL
#define FLASHC_FM_CTL_V2_FM_CTL_DAA_MUX_SEL_Pos 16UL
#define FLASHC_FM_CTL_V2_FM_CTL_DAA_MUX_SEL_Msk 0x7F0000UL
#define FLASHC_FM_CTL_V2_FM_CTL_IF_SEL_Pos      24UL
#define FLASHC_FM_CTL_V2_FM_CTL_IF_SEL_Msk      0x1000000UL
#define FLASHC_FM_CTL_V2_FM_CTL_WR_EN_Pos       25UL
#define FLASHC_FM_CTL_V2_FM_CTL_WR_EN_Msk       0x2000000UL
/* FLASHC_FM_CTL.STATUS */
#define FLASHC_FM_CTL_V2_STATUS_TIMER_ENABLED_Pos 0UL
#define FLASHC_FM_CTL_V2_STATUS_TIMER_ENABLED_Msk 0x1UL
#define FLASHC_FM_CTL_V2_STATUS_HV_REGS_ISOLATED_Pos 1UL
#define FLASHC_FM_CTL_V2_STATUS_HV_REGS_ISOLATED_Msk 0x2UL
#define FLASHC_FM_CTL_V2_STATUS_ILLEGAL_HVOP_Pos 2UL
#define FLASHC_FM_CTL_V2_STATUS_ILLEGAL_HVOP_Msk 0x4UL
#define FLASHC_FM_CTL_V2_STATUS_TURBO_N_Pos     3UL
#define FLASHC_FM_CTL_V2_STATUS_TURBO_N_Msk     0x8UL
#define FLASHC_FM_CTL_V2_STATUS_WR_EN_MON_Pos   4UL
#define FLASHC_FM_CTL_V2_STATUS_WR_EN_MON_Msk   0x10UL
#define FLASHC_FM_CTL_V2_STATUS_IF_SEL_MON_Pos  5UL
#define FLASHC_FM_CTL_V2_STATUS_IF_SEL_MON_Msk  0x20UL
#define FLASHC_FM_CTL_V2_STATUS_TIMER_STATUS_Pos 6UL
#define FLASHC_FM_CTL_V2_STATUS_TIMER_STATUS_Msk 0x40UL
#define FLASHC_FM_CTL_V2_STATUS_R_GRANT_DELAY_STATUS_Pos 7UL
#define FLASHC_FM_CTL_V2_STATUS_R_GRANT_DELAY_STATUS_Msk 0x80UL
#define FLASHC_FM_CTL_V2_STATUS_FM_BUSY_Pos     8UL
#define FLASHC_FM_CTL_V2_STATUS_FM_BUSY_Msk     0x100UL
#define FLASHC_FM_CTL_V2_STATUS_FM_READY_Pos    9UL
#define FLASHC_FM_CTL_V2_STATUS_FM_READY_Msk    0x200UL
#define FLASHC_FM_CTL_V2_STATUS_POS_PUMP_VLO_Pos 10UL
#define FLASHC_FM_CTL_V2_STATUS_POS_PUMP_VLO_Msk 0x400UL
#define FLASHC_FM_CTL_V2_STATUS_NEG_PUMP_VHI_Pos 11UL
#define FLASHC_FM_CTL_V2_STATUS_NEG_PUMP_VHI_Msk 0x800UL
#define FLASHC_FM_CTL_V2_STATUS_RWW_Pos         12UL
#define FLASHC_FM_CTL_V2_STATUS_RWW_Msk         0x1000UL
#define FLASHC_FM_CTL_V2_STATUS_MAX_DOUT_WIDTH_Pos 13UL
#define FLASHC_FM_CTL_V2_STATUS_MAX_DOUT_WIDTH_Msk 0x2000UL
#define FLASHC_FM_CTL_V2_STATUS_SECTOR0_SR_Pos  14UL
#define FLASHC_FM_CTL_V2_STATUS_SECTOR0_SR_Msk  0x4000UL
#define FLASHC_FM_CTL_V2_STATUS_RESET_MM_Pos    15UL
#define FLASHC_FM_CTL_V2_STATUS_RESET_MM_Msk    0x8000UL
#define FLASHC_FM_CTL_V2_STATUS_ROW_ODD_Pos     16UL
#define FLASHC_FM_CTL_V2_STATUS_ROW_ODD_Msk     0x10000UL
#define FLASHC_FM_CTL_V2_STATUS_ROW_EVEN_Pos    17UL
#define FLASHC_FM_CTL_V2_STATUS_ROW_EVEN_Msk    0x20000UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_SUB_SECTOR_N_Pos 18UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_SUB_SECTOR_N_Msk 0x40000UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_SECTOR_Pos 19UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_SECTOR_Msk 0x80000UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_BULK_ALL_Pos 20UL
#define FLASHC_FM_CTL_V2_STATUS_HVOP_BULK_ALL_Msk 0x100000UL
#define FLASHC_FM_CTL_V2_STATUS_CBUS_RA_MATCH_Pos 21UL
#define FLASHC_FM_CTL_V2_STATUS_CBUS_RA_MATCH_Msk 0x200000UL
#define FLASHC_FM_CTL_V2_STATUS_CBUS_RED_ROW_EN_Pos 22UL
#define FLASHC_FM_CTL_V2_STATUS_CBUS_RED_ROW_EN_Msk 0x400000UL
#define FLASHC_FM_CTL_V2_STATUS_RQ_ERROR_Pos    23UL
#define FLASHC_FM_CTL_V2_STATUS_RQ_ERROR_Msk    0x800000UL
#define FLASHC_FM_CTL_V2_STATUS_PUMP_PDAC_Pos   24UL
#define FLASHC_FM_CTL_V2_STATUS_PUMP_PDAC_Msk   0xF000000UL
#define FLASHC_FM_CTL_V2_STATUS_PUMP_NDAC_Pos   28UL
#define FLASHC_FM_CTL_V2_STATUS_PUMP_NDAC_Msk   0xF0000000UL
/* FLASHC_FM_CTL.FM_ADDR */
#define FLASHC_FM_CTL_V2_FM_ADDR_RA_Pos         0UL
#define FLASHC_FM_CTL_V2_FM_ADDR_RA_Msk         0xFFFFUL
#define FLASHC_FM_CTL_V2_FM_ADDR_BA_Pos         16UL
#define FLASHC_FM_CTL_V2_FM_ADDR_BA_Msk         0xFF0000UL
#define FLASHC_FM_CTL_V2_FM_ADDR_AXA_Pos        24UL
#define FLASHC_FM_CTL_V2_FM_ADDR_AXA_Msk        0x1000000UL
/* FLASHC_FM_CTL.BOOKMARK */
#define FLASHC_FM_CTL_V2_BOOKMARK_BOOKMARK_Pos  0UL
#define FLASHC_FM_CTL_V2_BOOKMARK_BOOKMARK_Msk  0xFFFFFFFFUL
/* FLASHC_FM_CTL.GEOMETRY */
#define FLASHC_FM_CTL_V2_GEOMETRY_ROW_COUNT_Pos 0UL
#define FLASHC_FM_CTL_V2_GEOMETRY_ROW_COUNT_Msk 0xFFFFUL
#define FLASHC_FM_CTL_V2_GEOMETRY_BANK_COUNT_Pos 16UL
#define FLASHC_FM_CTL_V2_GEOMETRY_BANK_COUNT_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_GEOMETRY_WORD_SIZE_LOG2_Pos 24UL
#define FLASHC_FM_CTL_V2_GEOMETRY_WORD_SIZE_LOG2_Msk 0xF000000UL
#define FLASHC_FM_CTL_V2_GEOMETRY_PAGE_SIZE_LOG2_Pos 28UL
#define FLASHC_FM_CTL_V2_GEOMETRY_PAGE_SIZE_LOG2_Msk 0xF0000000UL
/* FLASHC_FM_CTL.GEOMETRY_SUPERVISORY */
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_ROW_COUNT_Pos 0UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_ROW_COUNT_Msk 0xFFFFUL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_BANK_COUNT_Pos 16UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_BANK_COUNT_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_WORD_SIZE_LOG2_Pos 24UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_WORD_SIZE_LOG2_Msk 0xF000000UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_PAGE_SIZE_LOG2_Pos 28UL
#define FLASHC_FM_CTL_V2_GEOMETRY_SUPERVISORY_PAGE_SIZE_LOG2_Msk 0xF0000000UL
/* FLASHC_FM_CTL.ANA_CTL0 */
#define FLASHC_FM_CTL_V2_ANA_CTL0_MDAC_Pos      0UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_MDAC_Msk      0xFFUL
#define FLASHC_FM_CTL_V2_ANA_CTL0_CSLDAC_Pos    8UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_CSLDAC_Msk    0x700UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_FLIP_AMUXBUS_AB_Pos 11UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_FLIP_AMUXBUS_AB_Msk 0x800UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_NDAC_MIN_Pos  12UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_NDAC_MIN_Msk  0xF000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_PDAC_MIN_Pos  16UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_PDAC_MIN_Msk  0xF0000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ01_Pos 20UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ01_Msk 0x300000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ12_Pos 22UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ12_Msk 0xC00000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ23_Pos 24UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_SEQ23_Msk 0x3000000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_SEQ30_Pos 26UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_SEQ30_Msk 0xC000000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_PEON_Pos 28UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_PEON_Msk 0x30000000UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_PEOFF_Pos 30UL
#define FLASHC_FM_CTL_V2_ANA_CTL0_SCALE_PRG_PEOFF_Msk 0xC0000000UL
/* FLASHC_FM_CTL.ANA_CTL1 */
#define FLASHC_FM_CTL_V2_ANA_CTL1_NDAC_MAX_Pos  0UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NDAC_MAX_Msk  0xFUL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NDAC_STEP_Pos 4UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NDAC_STEP_Msk 0xF0UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_PDAC_MAX_Pos  8UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_PDAC_MAX_Msk  0xF00UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_PDAC_STEP_Pos 12UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_PDAC_STEP_Msk 0xF000UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NPDAC_STEP_TIME_Pos 16UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NPDAC_STEP_TIME_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NPDAC_ZERO_TIME_Pos 24UL
#define FLASHC_FM_CTL_V2_ANA_CTL1_NPDAC_ZERO_TIME_Msk 0xFF000000UL
/* FLASHC_FM_CTL.WAIT_CTL */
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_MEM_RD_Pos 0UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_MEM_RD_Msk 0xFUL
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_HV_RD_Pos 8UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_HV_RD_Msk 0xF00UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_HV_WR_Pos 16UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_WAIT_FM_HV_WR_Msk 0x70000UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_FM_RWW_MODE_Pos 24UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_FM_RWW_MODE_Msk 0x3000000UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_LV_SPARE_1_Pos 26UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_LV_SPARE_1_Msk 0x4000000UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_DRMM_Pos      27UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_DRMM_Msk      0x8000000UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_MBA_Pos       28UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_MBA_Msk       0x10000000UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_PL_SOFT_SET_EN_Pos 29UL
#define FLASHC_FM_CTL_V2_WAIT_CTL_PL_SOFT_SET_EN_Msk 0x20000000UL
/* FLASHC_FM_CTL.TIMER_CLK_CTL */
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_TIMER_CLOCK_FREQ_Pos 0UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_TIMER_CLOCK_FREQ_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_PEON_Pos 8UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_PEON_Msk 0xFF00UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_PEOFF_Pos 16UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_PEOFF_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_SEQ01_Pos 24UL
#define FLASHC_FM_CTL_V2_TIMER_CLK_CTL_RGRANT_DELAY_PRG_SEQ01_Msk 0xFF000000UL
/* FLASHC_FM_CTL.TIMER_CTL */
#define FLASHC_FM_CTL_V2_TIMER_CTL_PERIOD_Pos   0UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PERIOD_Msk   0x7FFFUL
#define FLASHC_FM_CTL_V2_TIMER_CTL_SCALE_Pos    15UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_SCALE_Msk    0x8000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_AUTO_SEQUENCE_Pos 24UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_AUTO_SEQUENCE_Msk 0x1000000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PRE_PROG_Pos 25UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PRE_PROG_Msk 0x2000000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PRE_PROG_CSL_Pos 26UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PRE_PROG_CSL_Msk 0x4000000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PUMP_EN_Pos  29UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_PUMP_EN_Msk  0x20000000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_ACLK_EN_Pos  30UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_ACLK_EN_Msk  0x40000000UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_TIMER_EN_Pos 31UL
#define FLASHC_FM_CTL_V2_TIMER_CTL_TIMER_EN_Msk 0x80000000UL
/* FLASHC_FM_CTL.ACLK_CTL */
#define FLASHC_FM_CTL_V2_ACLK_CTL_ACLK_GEN_Pos  0UL
#define FLASHC_FM_CTL_V2_ACLK_CTL_ACLK_GEN_Msk  0x1UL
/* FLASHC_FM_CTL.INTR */
#define FLASHC_FM_CTL_V2_INTR_TIMER_EXPIRED_Pos 0UL
#define FLASHC_FM_CTL_V2_INTR_TIMER_EXPIRED_Msk 0x1UL
/* FLASHC_FM_CTL.INTR_SET */
#define FLASHC_FM_CTL_V2_INTR_SET_TIMER_EXPIRED_Pos 0UL
#define FLASHC_FM_CTL_V2_INTR_SET_TIMER_EXPIRED_Msk 0x1UL
/* FLASHC_FM_CTL.INTR_MASK */
#define FLASHC_FM_CTL_V2_INTR_MASK_TIMER_EXPIRED_Pos 0UL
#define FLASHC_FM_CTL_V2_INTR_MASK_TIMER_EXPIRED_Msk 0x1UL
/* FLASHC_FM_CTL.INTR_MASKED */
#define FLASHC_FM_CTL_V2_INTR_MASKED_TIMER_EXPIRED_Pos 0UL
#define FLASHC_FM_CTL_V2_INTR_MASKED_TIMER_EXPIRED_Msk 0x1UL
/* FLASHC_FM_CTL.CAL_CTL0 */
#define FLASHC_FM_CTL_V2_CAL_CTL0_VCT_TRIM_LO_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_VCT_TRIM_LO_HV_Msk 0x1FUL
#define FLASHC_FM_CTL_V2_CAL_CTL0_CDAC_LO_HV_Pos 5UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_CDAC_LO_HV_Msk 0xE0UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_VBG_TRIM_LO_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_VBG_TRIM_LO_HV_Msk 0x1F00UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_VBG_TC_TRIM_LO_HV_Pos 13UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_VBG_TC_TRIM_LO_HV_Msk 0xE000UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_ICREF_TC_TRIM_LO_HV_Pos 16UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_ICREF_TC_TRIM_LO_HV_Msk 0x70000UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_IPREF_TRIMA_LO_HV_Pos 19UL
#define FLASHC_FM_CTL_V2_CAL_CTL0_IPREF_TRIMA_LO_HV_Msk 0x80000UL
/* FLASHC_FM_CTL.CAL_CTL1 */
#define FLASHC_FM_CTL_V2_CAL_CTL1_VCT_TRIM_HI_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_VCT_TRIM_HI_HV_Msk 0x1FUL
#define FLASHC_FM_CTL_V2_CAL_CTL1_CDAC_HI_HV_Pos 5UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_CDAC_HI_HV_Msk 0xE0UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_VBG_TRIM_HI_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_VBG_TRIM_HI_HV_Msk 0x1F00UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_VBG_TC_TRIM_HI_HV_Pos 13UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_VBG_TC_TRIM_HI_HV_Msk 0xE000UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_ICREF_TC_TRIM_HI_HV_Pos 16UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_ICREF_TC_TRIM_HI_HV_Msk 0x70000UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_IPREF_TRIMA_HI_HV_Pos 19UL
#define FLASHC_FM_CTL_V2_CAL_CTL1_IPREF_TRIMA_HI_HV_Msk 0x80000UL
/* FLASHC_FM_CTL.CAL_CTL2 */
#define FLASHC_FM_CTL_V2_CAL_CTL2_ICREF_TRIM_LO_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_ICREF_TRIM_LO_HV_Msk 0x1FUL
#define FLASHC_FM_CTL_V2_CAL_CTL2_ICREF_TRIM_HI_HV_Pos 5UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_ICREF_TRIM_HI_HV_Msk 0x3E0UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_IPREF_TRIM_LO_HV_Pos 10UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_IPREF_TRIM_LO_HV_Msk 0x7C00UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_IPREF_TRIM_HI_HV_Pos 15UL
#define FLASHC_FM_CTL_V2_CAL_CTL2_IPREF_TRIM_HI_HV_Msk 0xF8000UL
/* FLASHC_FM_CTL.CAL_CTL3 */
#define FLASHC_FM_CTL_V2_CAL_CTL3_OSC_TRIM_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_OSC_TRIM_HV_Msk 0xFUL
#define FLASHC_FM_CTL_V2_CAL_CTL3_OSC_RANGE_TRIM_HV_Pos 4UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_OSC_RANGE_TRIM_HV_Msk 0x10UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VPROT_ACT_HV_Pos 5UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VPROT_ACT_HV_Msk 0x20UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_IPREF_TC_HV_Pos 6UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_IPREF_TC_HV_Msk 0x40UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VREF_SEL_HV_Pos 7UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VREF_SEL_HV_Msk 0x80UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_IREF_SEL_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_IREF_SEL_HV_Msk 0x100UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_REG_ACT_HV_Pos 9UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_REG_ACT_HV_Msk 0x200UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_FDIV_TRIM_HV_Pos 10UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_FDIV_TRIM_HV_Msk 0xC00UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VDDHI_HV_Pos  12UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_VDDHI_HV_Msk  0x1000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_TURBO_PULSEW_HV_Pos 13UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_TURBO_PULSEW_HV_Msk 0x6000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_BGLO_EN_HV_Pos 15UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_BGLO_EN_HV_Msk 0x8000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_BGHI_EN_HV_Pos 16UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_BGHI_EN_HV_Msk 0x10000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_CL_ISO_DIS_HV_Pos 17UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_CL_ISO_DIS_HV_Msk 0x20000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_R_GRANT_EN_HV_Pos 18UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_R_GRANT_EN_HV_Msk 0x40000UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_LP_ULP_SW_HV_Pos 19UL
#define FLASHC_FM_CTL_V2_CAL_CTL3_LP_ULP_SW_HV_Msk 0x80000UL
/* FLASHC_FM_CTL.CAL_CTL4 */
#define FLASHC_FM_CTL_V2_CAL_CTL4_VLIM_TRIM_ULP_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_VLIM_TRIM_ULP_HV_Msk 0x3UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_IDAC_ULP_HV_Pos 2UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_IDAC_ULP_HV_Msk 0x3CUL
#define FLASHC_FM_CTL_V2_CAL_CTL4_SDAC_ULP_HV_Pos 6UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_SDAC_ULP_HV_Msk 0xC0UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_ITIM_ULP_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_ITIM_ULP_HV_Msk 0x1F00UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_FM_READY_DEL_ULP_HV_Pos 13UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_FM_READY_DEL_ULP_HV_Msk 0x6000UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_SPARE451_ULP_HV_Pos 15UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_SPARE451_ULP_HV_Msk 0x8000UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_READY_RESTART_N_HV_Pos 16UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_READY_RESTART_N_HV_Msk 0x10000UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_VBST_S_DIS_HV_Pos 17UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_VBST_S_DIS_HV_Msk 0x20000UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_AUTO_HVPULSE_HV_Pos 18UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_AUTO_HVPULSE_HV_Msk 0x40000UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_UGB_EN_HV_Pos 19UL
#define FLASHC_FM_CTL_V2_CAL_CTL4_UGB_EN_HV_Msk 0x80000UL
/* FLASHC_FM_CTL.CAL_CTL5 */
#define FLASHC_FM_CTL_V2_CAL_CTL5_VLIM_TRIM_LP_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_VLIM_TRIM_LP_HV_Msk 0x3UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_IDAC_LP_HV_Pos 2UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_IDAC_LP_HV_Msk 0x3CUL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SDAC_LP_HV_Pos 6UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SDAC_LP_HV_Msk 0xC0UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_ITIM_LP_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_ITIM_LP_HV_Msk 0x1F00UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_FM_READY_DEL_LP_HV_Pos 13UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_FM_READY_DEL_LP_HV_Msk 0x6000UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SPARE451_LP_HV_Pos 15UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SPARE451_LP_HV_Msk 0x8000UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SPARE52_HV_Pos 16UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_SPARE52_HV_Msk 0x30000UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_AMUX_SEL_HV_Pos 18UL
#define FLASHC_FM_CTL_V2_CAL_CTL5_AMUX_SEL_HV_Msk 0xC0000UL
/* FLASHC_FM_CTL.CAL_CTL6 */
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T1_ULP_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T1_ULP_HV_Msk 0x1UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T4_ULP_HV_Pos 1UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T4_ULP_HV_Msk 0xEUL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T5_ULP_HV_Pos 4UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T5_ULP_HV_Msk 0x70UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T6_ULP_HV_Pos 7UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T6_ULP_HV_Msk 0x180UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T8_ULP_HV_Pos 9UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T8_ULP_HV_Msk 0x200UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T1_LP_HV_Pos 10UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T1_LP_HV_Msk 0x400UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T4_LP_HV_Pos 11UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T4_LP_HV_Msk 0x3800UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T5_LP_HV_Pos 14UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T5_LP_HV_Msk 0x1C000UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T6_LP_HV_Pos 17UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T6_LP_HV_Msk 0x60000UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T8_LP_HV_Pos 19UL
#define FLASHC_FM_CTL_V2_CAL_CTL6_SA_CTL_TRIM_T8_LP_HV_Msk 0x80000UL
/* FLASHC_FM_CTL.CAL_CTL7 */
#define FLASHC_FM_CTL_V2_CAL_CTL7_ERSX8_CLK_SEL_HV_Pos 0UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_ERSX8_CLK_SEL_HV_Msk 0x3UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_FM_ACTIVE_HV_Pos 2UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_FM_ACTIVE_HV_Msk 0x4UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_TURBO_EXT_HV_Pos 3UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_TURBO_EXT_HV_Msk 0x8UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_NPDAC_HWCTL_DIS_HV_Pos 4UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_NPDAC_HWCTL_DIS_HV_Msk 0x10UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_FM_READY_DIS_HV_Pos 5UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_FM_READY_DIS_HV_Msk 0x20UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_ERSX8_EN_ALL_HV_Pos 6UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_ERSX8_EN_ALL_HV_Msk 0x40UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_DISABLE_LOAD_ONCE_HV_Pos 7UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_DISABLE_LOAD_ONCE_HV_Msk 0x80UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_HV_Pos 8UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_HV_Msk 0x300UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_ULP_HV_Pos 10UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_ULP_HV_Msk 0x7C00UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_LP_HV_Pos 15UL
#define FLASHC_FM_CTL_V2_CAL_CTL7_SPARE7_LP_HV_Msk 0xF8000UL
/* FLASHC_FM_CTL.RED_CTL01 */
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_ADDR_0_Pos 0UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_ADDR_0_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_EN_0_Pos 8UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_EN_0_Msk 0x100UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_ADDR_1_Pos 16UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_ADDR_1_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_EN_1_Pos 24UL
#define FLASHC_FM_CTL_V2_RED_CTL01_RED_EN_1_Msk 0x1000000UL
/* FLASHC_FM_CTL.RED_CTL23 */
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_ADDR_2_Pos 0UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_ADDR_2_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_EN_2_Pos 8UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_EN_2_Msk 0x100UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_ADDR_3_Pos 16UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_ADDR_3_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_EN_3_Pos 24UL
#define FLASHC_FM_CTL_V2_RED_CTL23_RED_EN_3_Msk 0x1000000UL
/* FLASHC_FM_CTL.RED_CTL45 */
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_ADDR_4_Pos 0UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_ADDR_4_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_EN_4_Pos 8UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_EN_4_Msk 0x100UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_ADDR_5_Pos 16UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_ADDR_5_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_EN_5_Pos 24UL
#define FLASHC_FM_CTL_V2_RED_CTL45_RED_EN_5_Msk 0x1000000UL
/* FLASHC_FM_CTL.RED_CTL67 */
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_ADDR_6_Pos 0UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_ADDR_6_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_EN_6_Pos 8UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_EN_6_Msk 0x100UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_ADDR_7_Pos 16UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_ADDR_7_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_EN_7_Pos 24UL
#define FLASHC_FM_CTL_V2_RED_CTL67_RED_EN_7_Msk 0x1000000UL
/* FLASHC_FM_CTL.RED_CTL_SM01 */
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_ADDR_SM0_Pos 0UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_ADDR_SM0_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_EN_SM0_Pos 8UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_EN_SM0_Msk 0x100UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_ADDR_SM1_Pos 16UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_ADDR_SM1_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_EN_SM1_Pos 24UL
#define FLASHC_FM_CTL_V2_RED_CTL_SM01_RED_EN_SM1_Msk 0x1000000UL
/* FLASHC_FM_CTL.RGRANT_DELAY_PRG */
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_PRG_SEQ12_Pos 0UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_PRG_SEQ12_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_PRG_SEQ23_Pos 8UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_PRG_SEQ23_Msk 0xFF00UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_SEQ30_Pos 16UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_SEQ30_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_CLK_Pos 24UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_RGRANT_DELAY_CLK_Msk 0xF000000UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_HV_PARAMS_LOADED_Pos 31UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_PRG_HV_PARAMS_LOADED_Msk 0x80000000UL
/* FLASHC_FM_CTL.PW_SEQ12 */
#define FLASHC_FM_CTL_V2_PW_SEQ12_PW_SEQ1_Pos   0UL
#define FLASHC_FM_CTL_V2_PW_SEQ12_PW_SEQ1_Msk   0xFFFFUL
#define FLASHC_FM_CTL_V2_PW_SEQ12_PW_SEQ2_PRE_Pos 16UL
#define FLASHC_FM_CTL_V2_PW_SEQ12_PW_SEQ2_PRE_Msk 0xFFFF0000UL
/* FLASHC_FM_CTL.PW_SEQ23 */
#define FLASHC_FM_CTL_V2_PW_SEQ23_PW_SEQ2_POST_Pos 0UL
#define FLASHC_FM_CTL_V2_PW_SEQ23_PW_SEQ2_POST_Msk 0xFFFFUL
#define FLASHC_FM_CTL_V2_PW_SEQ23_PW_SEQ3_Pos   16UL
#define FLASHC_FM_CTL_V2_PW_SEQ23_PW_SEQ3_Msk   0xFFFF0000UL
/* FLASHC_FM_CTL.RGRANT_SCALE_ERS */
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ01_Pos 0UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ01_Msk 0x3UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ12_Pos 2UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ12_Msk 0xCUL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ23_Pos 4UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_SEQ23_Msk 0x30UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_PEON_Pos 6UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_PEON_Msk 0xC0UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_PEOFF_Pos 8UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_SCALE_ERS_PEOFF_Msk 0x300UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_RGRANT_DELAY_ERS_PEON_Pos 16UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_RGRANT_DELAY_ERS_PEON_Msk 0xFF0000UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_RGRANT_DELAY_ERS_PEOFF_Pos 24UL
#define FLASHC_FM_CTL_V2_RGRANT_SCALE_ERS_RGRANT_DELAY_ERS_PEOFF_Msk 0xFF000000UL
/* FLASHC_FM_CTL.RGRANT_DELAY_ERS */
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ01_Pos 0UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ01_Msk 0xFFUL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ12_Pos 8UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ12_Msk 0xFF00UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ23_Pos 16UL
#define FLASHC_FM_CTL_V2_RGRANT_DELAY_ERS_RGRANT_DELAY_ERS_SEQ23_Msk 0xFF0000UL
/* FLASHC_FM_CTL.FM_PL_WRDATA_ALL */
#define FLASHC_FM_CTL_V2_FM_PL_WRDATA_ALL_DATA32_Pos 0UL
#define FLASHC_FM_CTL_V2_FM_PL_WRDATA_ALL_DATA32_Msk 0xFFFFFFFFUL
/* FLASHC_FM_CTL.FM_PL_DATA */
#define FLASHC_FM_CTL_V2_FM_PL_DATA_DATA32_Pos  0UL
#define FLASHC_FM_CTL_V2_FM_PL_DATA_DATA32_Msk  0xFFFFFFFFUL
/* FLASHC_FM_CTL.FM_MEM_DATA */
#define FLASHC_FM_CTL_V2_FM_MEM_DATA_DATA32_Pos 0UL
#define FLASHC_FM_CTL_V2_FM_MEM_DATA_DATA32_Msk 0xFFFFFFFFUL


/* FLASHC.FLASH_CTL */
#define FLASHC_V2_FLASH_CTL_MAIN_WS_Pos         0UL
#define FLASHC_V2_FLASH_CTL_MAIN_WS_Msk         0xFUL
#define FLASHC_V2_FLASH_CTL_MAIN_MAP_Pos        8UL
#define FLASHC_V2_FLASH_CTL_MAIN_MAP_Msk        0x100UL
#define FLASHC_V2_FLASH_CTL_WORK_MAP_Pos        9UL
#define FLASHC_V2_FLASH_CTL_WORK_MAP_Msk        0x200UL
#define FLASHC_V2_FLASH_CTL_MAIN_BANK_MODE_Pos  12UL
#define FLASHC_V2_FLASH_CTL_MAIN_BANK_MODE_Msk  0x1000UL
#define FLASHC_V2_FLASH_CTL_WORK_BANK_MODE_Pos  13UL
#define FLASHC_V2_FLASH_CTL_WORK_BANK_MODE_Msk  0x2000UL
#define FLASHC_V2_FLASH_CTL_MAIN_ECC_EN_Pos     16UL
#define FLASHC_V2_FLASH_CTL_MAIN_ECC_EN_Msk     0x10000UL
#define FLASHC_V2_FLASH_CTL_MAIN_ECC_INJ_EN_Pos 17UL
#define FLASHC_V2_FLASH_CTL_MAIN_ECC_INJ_EN_Msk 0x20000UL
#define FLASHC_V2_FLASH_CTL_MAIN_ERR_SILENT_Pos 18UL
#define FLASHC_V2_FLASH_CTL_MAIN_ERR_SILENT_Msk 0x40000UL
#define FLASHC_V2_FLASH_CTL_WORK_ECC_EN_Pos     20UL
#define FLASHC_V2_FLASH_CTL_WORK_ECC_EN_Msk     0x100000UL
#define FLASHC_V2_FLASH_CTL_WORK_ECC_INJ_EN_Pos 21UL
#define FLASHC_V2_FLASH_CTL_WORK_ECC_INJ_EN_Msk 0x200000UL
#define FLASHC_V2_FLASH_CTL_WORK_ERR_SILENT_Pos 22UL
#define FLASHC_V2_FLASH_CTL_WORK_ERR_SILENT_Msk 0x400000UL
/* FLASHC.FLASH_PWR_CTL */
#define FLASHC_V2_FLASH_PWR_CTL_ENABLE_Pos      0UL
#define FLASHC_V2_FLASH_PWR_CTL_ENABLE_Msk      0x1UL
#define FLASHC_V2_FLASH_PWR_CTL_ENABLE_HV_Pos   1UL
#define FLASHC_V2_FLASH_PWR_CTL_ENABLE_HV_Msk   0x2UL
/* FLASHC.FLASH_CMD */
#define FLASHC_V2_FLASH_CMD_INV_Pos             0UL
#define FLASHC_V2_FLASH_CMD_INV_Msk             0x1UL
#define FLASHC_V2_FLASH_CMD_BUFF_INV_Pos        1UL
#define FLASHC_V2_FLASH_CMD_BUFF_INV_Msk        0x2UL
/* FLASHC.ECC_CTL */
#define FLASHC_V2_ECC_CTL_WORD_ADDR_Pos         0UL
#define FLASHC_V2_ECC_CTL_WORD_ADDR_Msk         0xFFFFFFUL
#define FLASHC_V2_ECC_CTL_PARITY_Pos            24UL
#define FLASHC_V2_ECC_CTL_PARITY_Msk            0xFF000000UL
/* FLASHC.FM_SRAM_ECC_CTL0 */
#define FLASHC_V2_FM_SRAM_ECC_CTL0_ECC_INJ_DATA_Pos 0UL
#define FLASHC_V2_FM_SRAM_ECC_CTL0_ECC_INJ_DATA_Msk 0xFFFFFFFFUL
/* FLASHC.FM_SRAM_ECC_CTL1 */
#define FLASHC_V2_FM_SRAM_ECC_CTL1_ECC_INJ_PARITY_Pos 0UL
#define FLASHC_V2_FM_SRAM_ECC_CTL1_ECC_INJ_PARITY_Msk 0x7FUL
/* FLASHC.FM_SRAM_ECC_CTL2 */
#define FLASHC_V2_FM_SRAM_ECC_CTL2_CORRECTED_DATA_Pos 0UL
#define FLASHC_V2_FM_SRAM_ECC_CTL2_CORRECTED_DATA_Msk 0xFFFFFFFFUL
/* FLASHC.FM_SRAM_ECC_CTL3 */
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_ENABLE_Pos 0UL
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_ENABLE_Msk 0x1UL
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_INJ_EN_Pos 4UL
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_INJ_EN_Msk 0x10UL
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_TEST_FAIL_Pos 8UL
#define FLASHC_V2_FM_SRAM_ECC_CTL3_ECC_TEST_FAIL_Msk 0x100UL
/* FLASHC.CM0_CA_CTL0 */
#define FLASHC_V2_CM0_CA_CTL0_RAM_ECC_EN_Pos    0UL
#define FLASHC_V2_CM0_CA_CTL0_RAM_ECC_EN_Msk    0x1UL
#define FLASHC_V2_CM0_CA_CTL0_RAM_ECC_INJ_EN_Pos 1UL
#define FLASHC_V2_CM0_CA_CTL0_RAM_ECC_INJ_EN_Msk 0x2UL
#define FLASHC_V2_CM0_CA_CTL0_WAY_Pos           16UL
#define FLASHC_V2_CM0_CA_CTL0_WAY_Msk           0x30000UL
#define FLASHC_V2_CM0_CA_CTL0_SET_ADDR_Pos      24UL
#define FLASHC_V2_CM0_CA_CTL0_SET_ADDR_Msk      0x7000000UL
#define FLASHC_V2_CM0_CA_CTL0_PREF_EN_Pos       30UL
#define FLASHC_V2_CM0_CA_CTL0_PREF_EN_Msk       0x40000000UL
#define FLASHC_V2_CM0_CA_CTL0_CA_EN_Pos         31UL
#define FLASHC_V2_CM0_CA_CTL0_CA_EN_Msk         0x80000000UL
/* FLASHC.CM0_CA_CTL1 */
#define FLASHC_V2_CM0_CA_CTL1_PWR_MODE_Pos      0UL
#define FLASHC_V2_CM0_CA_CTL1_PWR_MODE_Msk      0x3UL
#define FLASHC_V2_CM0_CA_CTL1_VECTKEYSTAT_Pos   16UL
#define FLASHC_V2_CM0_CA_CTL1_VECTKEYSTAT_Msk   0xFFFF0000UL
/* FLASHC.CM0_CA_CTL2 */
#define FLASHC_V2_CM0_CA_CTL2_PWRUP_DELAY_Pos   0UL
#define FLASHC_V2_CM0_CA_CTL2_PWRUP_DELAY_Msk   0x3FFUL
/* FLASHC.CM0_CA_STATUS0 */
#define FLASHC_V2_CM0_CA_STATUS0_VALID32_Pos    0UL
#define FLASHC_V2_CM0_CA_STATUS0_VALID32_Msk    0xFFFFFFFFUL
/* FLASHC.CM0_CA_STATUS1 */
#define FLASHC_V2_CM0_CA_STATUS1_TAG_Pos        0UL
#define FLASHC_V2_CM0_CA_STATUS1_TAG_Msk        0xFFFFFFFFUL
/* FLASHC.CM0_CA_STATUS2 */
#define FLASHC_V2_CM0_CA_STATUS2_LRU_Pos        0UL
#define FLASHC_V2_CM0_CA_STATUS2_LRU_Msk        0x3FUL
/* FLASHC.CM0_STATUS */
#define FLASHC_V2_CM0_STATUS_MAIN_INTERNAL_ERR_Pos 0UL
#define FLASHC_V2_CM0_STATUS_MAIN_INTERNAL_ERR_Msk 0x1UL
#define FLASHC_V2_CM0_STATUS_WORK_INTERNAL_ERR_Pos 1UL
#define FLASHC_V2_CM0_STATUS_WORK_INTERNAL_ERR_Msk 0x2UL
/* FLASHC.CM4_CA_CTL0 */
#define FLASHC_V2_CM4_CA_CTL0_RAM_ECC_EN_Pos    0UL
#define FLASHC_V2_CM4_CA_CTL0_RAM_ECC_EN_Msk    0x1UL
#define FLASHC_V2_CM4_CA_CTL0_RAM_ECC_INJ_EN_Pos 1UL
#define FLASHC_V2_CM4_CA_CTL0_RAM_ECC_INJ_EN_Msk 0x2UL
#define FLASHC_V2_CM4_CA_CTL0_WAY_Pos           16UL
#define FLASHC_V2_CM4_CA_CTL0_WAY_Msk           0x30000UL
#define FLASHC_V2_CM4_CA_CTL0_SET_ADDR_Pos      24UL
#define FLASHC_V2_CM4_CA_CTL0_SET_ADDR_Msk      0x7000000UL
#define FLASHC_V2_CM4_CA_CTL0_PREF_EN_Pos       30UL
#define FLASHC_V2_CM4_CA_CTL0_PREF_EN_Msk       0x40000000UL
#define FLASHC_V2_CM4_CA_CTL0_CA_EN_Pos         31UL
#define FLASHC_V2_CM4_CA_CTL0_CA_EN_Msk         0x80000000UL
/* FLASHC.CM4_CA_CTL1 */
#define FLASHC_V2_CM4_CA_CTL1_PWR_MODE_Pos      0UL
#define FLASHC_V2_CM4_CA_CTL1_PWR_MODE_Msk      0x3UL
#define FLASHC_V2_CM4_CA_CTL1_VECTKEYSTAT_Pos   16UL
#define FLASHC_V2_CM4_CA_CTL1_VECTKEYSTAT_Msk   0xFFFF0000UL
/* FLASHC.CM4_CA_CTL2 */
#define FLASHC_V2_CM4_CA_CTL2_PWRUP_DELAY_Pos   0UL
#define FLASHC_V2_CM4_CA_CTL2_PWRUP_DELAY_Msk   0x3FFUL
/* FLASHC.CM4_CA_STATUS0 */
#define FLASHC_V2_CM4_CA_STATUS0_VALID32_Pos    0UL
#define FLASHC_V2_CM4_CA_STATUS0_VALID32_Msk    0xFFFFFFFFUL
/* FLASHC.CM4_CA_STATUS1 */
#define FLASHC_V2_CM4_CA_STATUS1_TAG_Pos        0UL
#define FLASHC_V2_CM4_CA_STATUS1_TAG_Msk        0xFFFFFFFFUL
/* FLASHC.CM4_CA_STATUS2 */
#define FLASHC_V2_CM4_CA_STATUS2_LRU_Pos        0UL
#define FLASHC_V2_CM4_CA_STATUS2_LRU_Msk        0x3FUL
/* FLASHC.CM4_STATUS */
#define FLASHC_V2_CM4_STATUS_MAIN_INTERNAL_ERR_Pos 0UL
#define FLASHC_V2_CM4_STATUS_MAIN_INTERNAL_ERR_Msk 0x1UL
#define FLASHC_V2_CM4_STATUS_WORK_INTERNAL_ERR_Pos 1UL
#define FLASHC_V2_CM4_STATUS_WORK_INTERNAL_ERR_Msk 0x2UL
/* FLASHC.CRYPTO_BUFF_CTL */
#define FLASHC_V2_CRYPTO_BUFF_CTL_PREF_EN_Pos   30UL
#define FLASHC_V2_CRYPTO_BUFF_CTL_PREF_EN_Msk   0x40000000UL
/* FLASHC.DW0_BUFF_CTL */
#define FLASHC_V2_DW0_BUFF_CTL_PREF_EN_Pos      30UL
#define FLASHC_V2_DW0_BUFF_CTL_PREF_EN_Msk      0x40000000UL
/* FLASHC.DW1_BUFF_CTL */
#define FLASHC_V2_DW1_BUFF_CTL_PREF_EN_Pos      30UL
#define FLASHC_V2_DW1_BUFF_CTL_PREF_EN_Msk      0x40000000UL
/* FLASHC.DMAC_BUFF_CTL */
#define FLASHC_V2_DMAC_BUFF_CTL_PREF_EN_Pos     30UL
#define FLASHC_V2_DMAC_BUFF_CTL_PREF_EN_Msk     0x40000000UL
/* FLASHC.EXT_MS0_BUFF_CTL */
#define FLASHC_V2_EXT_MS0_BUFF_CTL_PREF_EN_Pos  30UL
#define FLASHC_V2_EXT_MS0_BUFF_CTL_PREF_EN_Msk  0x40000000UL
/* FLASHC.EXT_MS1_BUFF_CTL */
#define FLASHC_V2_EXT_MS1_BUFF_CTL_PREF_EN_Pos  30UL
#define FLASHC_V2_EXT_MS1_BUFF_CTL_PREF_EN_Msk  0x40000000UL


#endif /* _CYIP_FLASHC_V2_H_ */


/* [] END OF FILE */
